/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.bedrock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.KeyPair;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.raphimc.minecraftauth.bedrock.model.MinecraftCertificateChain;
import net.raphimc.minecraftauth.bedrock.model.MinecraftMultiplayerToken;
import net.raphimc.minecraftauth.bedrock.model.MinecraftSession;
import net.raphimc.minecraftauth.bedrock.request.MinecraftAuthenticationRequest;
import net.raphimc.minecraftauth.bedrock.request.MinecraftMultiplayerSessionStartRequest;
import net.raphimc.minecraftauth.bedrock.request.MinecraftSessionStartRequest;
import net.raphimc.minecraftauth.msa.model.MsaApplicationConfig;
import net.raphimc.minecraftauth.msa.model.MsaToken;
import net.raphimc.minecraftauth.msa.request.MsaRefreshTokenRequest;
import net.raphimc.minecraftauth.msa.service.MsaAuthService;
import net.raphimc.minecraftauth.msa.service.util.MsaAuthServiceSupplier;
import net.raphimc.minecraftauth.msa.service.util.ParamMsaAuthServiceSupplier;
import net.raphimc.minecraftauth.playfab.model.PlayFabToken;
import net.raphimc.minecraftauth.playfab.request.PlayFabLoginWithXboxRequest;
import net.raphimc.minecraftauth.util.CryptUtil;
import net.raphimc.minecraftauth.util.JsonUtil;
import net.raphimc.minecraftauth.util.holder.Holder;
import net.raphimc.minecraftauth.util.holder.listener.ChangeListeners;
import net.raphimc.minecraftauth.xbl.model.XblDeviceToken;
import net.raphimc.minecraftauth.xbl.model.XblSisuTokens;
import net.raphimc.minecraftauth.xbl.model.XblTitleToken;
import net.raphimc.minecraftauth.xbl.model.XblUserToken;
import net.raphimc.minecraftauth.xbl.model.XblXstsToken;
import net.raphimc.minecraftauth.xbl.request.XblDeviceAuthenticateRequest;
import net.raphimc.minecraftauth.xbl.request.XblSisuAuthorizeRequest;
import net.raphimc.minecraftauth.xbl.request.XblUserAuthenticateRequest;
import net.raphimc.minecraftauth.xbl.request.XblXstsAuthorizeRequest;

public class BedrockAuthManager {
    private final HttpClient httpClient;
    private final String gameVersion;
    private final MsaApplicationConfig msaApplicationConfig;
    private final String deviceType;
    private final KeyPair deviceKeyPair;
    private final UUID deviceId;
    private final KeyPair sessionKeyPair;
    private final ChangeListeners changeListeners = new ChangeListeners();
    private final Object sisuTokenLock = new Object();
    private final Holder<MsaToken> msaToken = new Holder<MsaToken>(this::refreshMsaToken);
    private final Holder<XblDeviceToken> xblDeviceToken = new Holder<XblDeviceToken>(this::refreshXblDeviceToken);
    private final Holder<XblUserToken> xblUserToken = new Holder<XblUserToken>(this::refreshXblUserToken, this.sisuTokenLock);
    private final Holder<XblTitleToken> xblTitleToken = new Holder<XblTitleToken>(this::refreshXblTitleToken, this.sisuTokenLock);
    private final Holder<XblXstsToken> bedrockXstsToken = new Holder<XblXstsToken>(this::refreshBedrockXstsToken, this.sisuTokenLock);
    private final Holder<XblXstsToken> playFabXstsToken = new Holder<XblXstsToken>(this::refreshPlayFabXstsToken);
    private final Holder<XblXstsToken> realmsXstsToken = new Holder<XblXstsToken>(this::refreshRealmsXstsToken);
    private final Holder<PlayFabToken> playFabToken = new Holder<PlayFabToken>(this::refreshPlayFabToken);
    private final Holder<MinecraftSession> minecraftSession = new Holder<MinecraftSession>(this::refreshMinecraftSession);
    private final Holder<MinecraftMultiplayerToken> minecraftMultiplayerToken = new Holder<MinecraftMultiplayerToken>(this::refreshMinecraftMultiplayerToken);
    private final Holder<MinecraftCertificateChain> minecraftCertificateChain = new Holder<MinecraftCertificateChain>(this::refreshMinecraftCertificateChain);

    public static BedrockAuthManager fromJson(HttpClient httpClient, String gameVersion, JsonObject json) {
        return BedrockAuthManager.fromJson(httpClient, gameVersion, new GsonObject(json));
    }

    public static BedrockAuthManager fromJson(HttpClient httpClient, String gameVersion, GsonObject json) {
        return new BedrockAuthManager(httpClient, gameVersion, MsaApplicationConfig.fromJson(json.reqObject("msaApplicationConfig")), json.reqString("deviceType"), JsonUtil.decodeKeyPair(json.reqObject("deviceKeyPair")), UUID.fromString(json.reqString("deviceId")), JsonUtil.decodeKeyPair(json.reqObject("sessionKeyPair")), MsaToken.fromJson(json.reqObject("msaToken")), json.optObject("xblDeviceToken").map(XblDeviceToken::fromJson).orElse(null), json.optObject("xblUserToken").map(XblUserToken::fromJson).orElse(null), json.optObject("xblTitleToken").map(XblTitleToken::fromJson).orElse(null), json.optObject("bedrockXstsToken").map(XblXstsToken::fromJson).orElse(null), json.optObject("playFabXstsToken").map(XblXstsToken::fromJson).orElse(null), json.optObject("realmsXstsToken").map(XblXstsToken::fromJson).orElse(null), json.optObject("playFabToken").map(PlayFabToken::fromJson).orElse(null), json.optObject("minecraftSession").map(MinecraftSession::fromJson).orElse(null), json.optObject("minecraftMultiplayerToken").map(MinecraftMultiplayerToken::fromJson).orElse(null), json.optObject("minecraftCertificateChain").map(MinecraftCertificateChain::fromJson).orElse(null));
    }

    public static JsonObject toJson(BedrockAuthManager authManager) {
        JsonObject json = new JsonObject();
        json.addProperty("_saveVersion", (Number)1);
        json.add("msaApplicationConfig", (JsonElement)MsaApplicationConfig.toJson(authManager.msaApplicationConfig));
        json.addProperty("deviceType", authManager.deviceType);
        json.add("deviceKeyPair", (JsonElement)JsonUtil.encodeKeyPair(authManager.deviceKeyPair));
        json.addProperty("deviceId", authManager.deviceId.toString());
        json.add("sessionKeyPair", (JsonElement)JsonUtil.encodeKeyPair(authManager.sessionKeyPair));
        json.add("msaToken", (JsonElement)MsaToken.toJson(authManager.msaToken.getCached()));
        if (authManager.xblDeviceToken.hasValue()) {
            json.add("xblDeviceToken", (JsonElement)XblDeviceToken.toJson(authManager.xblDeviceToken.getCached()));
        }
        if (authManager.xblUserToken.hasValue()) {
            json.add("xblUserToken", (JsonElement)XblUserToken.toJson(authManager.xblUserToken.getCached()));
        }
        if (authManager.xblTitleToken.hasValue()) {
            json.add("xblTitleToken", (JsonElement)XblTitleToken.toJson(authManager.xblTitleToken.getCached()));
        }
        if (authManager.bedrockXstsToken.hasValue()) {
            json.add("bedrockXstsToken", (JsonElement)XblXstsToken.toJson(authManager.bedrockXstsToken.getCached()));
        }
        if (authManager.playFabXstsToken.hasValue()) {
            json.add("playFabXstsToken", (JsonElement)XblXstsToken.toJson(authManager.playFabXstsToken.getCached()));
        }
        if (authManager.realmsXstsToken.hasValue()) {
            json.add("realmsXstsToken", (JsonElement)XblXstsToken.toJson(authManager.realmsXstsToken.getCached()));
        }
        if (authManager.playFabToken.hasValue()) {
            json.add("playFabToken", (JsonElement)PlayFabToken.toJson(authManager.playFabToken.getCached()));
        }
        if (authManager.minecraftSession.hasValue()) {
            json.add("minecraftSession", (JsonElement)MinecraftSession.toJson(authManager.minecraftSession.getCached()));
        }
        if (authManager.minecraftMultiplayerToken.hasValue()) {
            json.add("minecraftMultiplayerToken", (JsonElement)MinecraftMultiplayerToken.toJson(authManager.minecraftMultiplayerToken.getCached()));
        }
        if (authManager.minecraftCertificateChain.hasValue()) {
            json.add("minecraftCertificateChain", (JsonElement)MinecraftCertificateChain.toJson(authManager.minecraftCertificateChain.getCached()));
        }
        return json;
    }

    public static Builder create(HttpClient httpClient, String gameVersion) {
        return new Builder(httpClient, gameVersion);
    }

    private BedrockAuthManager(HttpClient httpClient, String gameVersion, MsaApplicationConfig msaApplicationConfig, String deviceType, KeyPair deviceKeyPair, UUID deviceId, KeyPair sessionKeyPair, MsaToken msaToken) {
        this.httpClient = httpClient;
        this.gameVersion = gameVersion;
        this.msaApplicationConfig = msaApplicationConfig;
        this.deviceType = deviceType;
        this.deviceKeyPair = deviceKeyPair;
        this.deviceId = deviceId;
        this.sessionKeyPair = sessionKeyPair;
        this.msaToken.set(msaToken);
        this.hookChangeListeners();
    }

    private BedrockAuthManager(HttpClient httpClient, String gameVersion, MsaApplicationConfig msaApplicationConfig, String deviceType, KeyPair deviceKeyPair, UUID deviceId, KeyPair sessionKeyPair, MsaToken msaToken, XblDeviceToken xblDeviceToken, XblUserToken xblUserToken, XblTitleToken xblTitleToken, XblXstsToken bedrockXstsToken, XblXstsToken playFabXstsToken, XblXstsToken realmsXstsToken, PlayFabToken playFabToken, MinecraftSession minecraftSession, MinecraftMultiplayerToken minecraftMultiplayerToken, MinecraftCertificateChain minecraftCertificateChain) {
        this.httpClient = httpClient;
        this.gameVersion = gameVersion;
        this.msaApplicationConfig = msaApplicationConfig;
        this.deviceType = deviceType;
        this.deviceKeyPair = deviceKeyPair;
        this.deviceId = deviceId;
        this.sessionKeyPair = sessionKeyPair;
        this.msaToken.set(msaToken);
        this.xblDeviceToken.set(xblDeviceToken);
        this.xblUserToken.set(xblUserToken);
        this.xblTitleToken.set(xblTitleToken);
        this.bedrockXstsToken.set(bedrockXstsToken);
        this.playFabXstsToken.set(playFabXstsToken);
        this.realmsXstsToken.set(realmsXstsToken);
        this.playFabToken.set(playFabToken);
        this.minecraftSession.set(minecraftSession);
        this.minecraftMultiplayerToken.set(minecraftMultiplayerToken);
        this.minecraftCertificateChain.set(minecraftCertificateChain);
        this.hookChangeListeners();
    }

    private MsaToken refreshMsaToken() throws IOException {
        if (this.msaToken.getCached().getRefreshToken() == null) {
            throw new IllegalStateException("Can't refresh MSA token, because it was created without a refresh token. The user has to sign in again.");
        }
        return (MsaToken)this.httpClient.executeAndHandle((HttpRequest)new MsaRefreshTokenRequest(this.msaApplicationConfig, this.msaToken.getCached()));
    }

    private XblDeviceToken refreshXblDeviceToken() throws IOException {
        return (XblDeviceToken)this.httpClient.executeAndHandle((HttpRequest)new XblDeviceAuthenticateRequest(this.deviceType, this.deviceId, this.deviceKeyPair));
    }

    private XblUserToken refreshXblUserToken() throws IOException {
        if (this.msaApplicationConfig.isTitleClientId()) {
            this.refreshSisuTokens();
            return this.xblUserToken.getCached();
        }
        return (XblUserToken)this.httpClient.executeAndHandle((HttpRequest)new XblUserAuthenticateRequest(this.msaApplicationConfig, this.msaToken.getUpToDate()));
    }

    private XblTitleToken refreshXblTitleToken() throws IOException {
        if (!this.msaApplicationConfig.isTitleClientId()) {
            throw new UnsupportedOperationException("Can't refresh XBL title token, because the MSA application client ID is not a title client ID");
        }
        this.refreshSisuTokens();
        return this.xblTitleToken.getCached();
    }

    private XblXstsToken refreshBedrockXstsToken() throws IOException {
        if (this.msaApplicationConfig.isTitleClientId()) {
            this.refreshSisuTokens();
            return this.bedrockXstsToken.getCached();
        }
        return (XblXstsToken)this.httpClient.executeAndHandle((HttpRequest)new XblXstsAuthorizeRequest(this.xblDeviceToken.getUpToDate(), this.xblUserToken.getUpToDate(), null, "https://multiplayer.minecraft.net/"));
    }

    private XblXstsToken refreshPlayFabXstsToken() throws IOException {
        XblTitleToken titleToken = this.msaApplicationConfig.isTitleClientId() ? this.xblTitleToken.getUpToDate() : null;
        return (XblXstsToken)this.httpClient.executeAndHandle((HttpRequest)new XblXstsAuthorizeRequest(this.xblDeviceToken.getUpToDate(), this.xblUserToken.getUpToDate(), titleToken, "https://b980a380.minecraft.playfabapi.com/"));
    }

    private XblXstsToken refreshRealmsXstsToken() throws IOException {
        XblTitleToken titleToken = this.msaApplicationConfig.isTitleClientId() ? this.xblTitleToken.getUpToDate() : null;
        return (XblXstsToken)this.httpClient.executeAndHandle((HttpRequest)new XblXstsAuthorizeRequest(this.xblDeviceToken.getUpToDate(), this.xblUserToken.getUpToDate(), titleToken, "https://pocket.realms.minecraft.net/"));
    }

    private PlayFabToken refreshPlayFabToken() throws IOException {
        return (PlayFabToken)this.httpClient.executeAndHandle((HttpRequest)new PlayFabLoginWithXboxRequest(this.playFabXstsToken.getUpToDate(), "20CA2"));
    }

    private MinecraftSession refreshMinecraftSession() throws IOException {
        return (MinecraftSession)this.httpClient.executeAndHandle((HttpRequest)new MinecraftSessionStartRequest(this.bedrockXstsToken.getUpToDate(), this.playFabToken.getUpToDate(), this.gameVersion, this.deviceId));
    }

    private MinecraftMultiplayerToken refreshMinecraftMultiplayerToken() throws IOException {
        return (MinecraftMultiplayerToken)this.httpClient.executeAndHandle((HttpRequest)new MinecraftMultiplayerSessionStartRequest(this.minecraftSession.getUpToDate(), this.sessionKeyPair));
    }

    private MinecraftCertificateChain refreshMinecraftCertificateChain() throws IOException {
        return (MinecraftCertificateChain)this.httpClient.executeAndHandle((HttpRequest)new MinecraftAuthenticationRequest(this.bedrockXstsToken.getUpToDate(), this.sessionKeyPair));
    }

    private void refreshSisuTokens() throws IOException {
        XblSisuTokens sisuTokens = (XblSisuTokens)this.httpClient.executeAndHandle((HttpRequest)new XblSisuAuthorizeRequest(this.msaApplicationConfig, this.msaToken.getUpToDate(), this.xblDeviceToken.getUpToDate(), this.deviceKeyPair, "https://multiplayer.minecraft.net/"));
        this.xblUserToken.set(sisuTokens.getUserToken());
        this.xblTitleToken.set(sisuTokens.getTitleToken());
        this.bedrockXstsToken.set(sisuTokens.getXstsToken());
    }

    private void hookChangeListeners() {
        this.msaToken.getChangeListeners().add(this.changeListeners::invoke);
        this.xblDeviceToken.getChangeListeners().add(this.changeListeners::invoke);
        this.xblUserToken.getChangeListeners().add(this.changeListeners::invoke);
        this.xblTitleToken.getChangeListeners().add(this.changeListeners::invoke);
        this.bedrockXstsToken.getChangeListeners().add(this.changeListeners::invoke);
        this.playFabXstsToken.getChangeListeners().add(this.changeListeners::invoke);
        this.realmsXstsToken.getChangeListeners().add(this.changeListeners::invoke);
        this.playFabToken.getChangeListeners().add(this.changeListeners::invoke);
        this.minecraftSession.getChangeListeners().add(this.changeListeners::invoke);
        this.minecraftMultiplayerToken.getChangeListeners().add(this.changeListeners::invoke);
        this.minecraftCertificateChain.getChangeListeners().add(this.changeListeners::invoke);
    }

    @Generated
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public String getGameVersion() {
        return this.gameVersion;
    }

    @Generated
    public MsaApplicationConfig getMsaApplicationConfig() {
        return this.msaApplicationConfig;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public KeyPair getDeviceKeyPair() {
        return this.deviceKeyPair;
    }

    @Generated
    public UUID getDeviceId() {
        return this.deviceId;
    }

    @Generated
    public KeyPair getSessionKeyPair() {
        return this.sessionKeyPair;
    }

    @Generated
    public ChangeListeners getChangeListeners() {
        return this.changeListeners;
    }

    @Generated
    public Holder<MsaToken> getMsaToken() {
        return this.msaToken;
    }

    @Generated
    public Holder<XblDeviceToken> getXblDeviceToken() {
        return this.xblDeviceToken;
    }

    @Generated
    public Holder<XblUserToken> getXblUserToken() {
        return this.xblUserToken;
    }

    @Generated
    public Holder<XblTitleToken> getXblTitleToken() {
        return this.xblTitleToken;
    }

    @Generated
    public Holder<XblXstsToken> getBedrockXstsToken() {
        return this.bedrockXstsToken;
    }

    @Generated
    public Holder<XblXstsToken> getPlayFabXstsToken() {
        return this.playFabXstsToken;
    }

    @Generated
    public Holder<XblXstsToken> getRealmsXstsToken() {
        return this.realmsXstsToken;
    }

    @Generated
    public Holder<PlayFabToken> getPlayFabToken() {
        return this.playFabToken;
    }

    @Generated
    public Holder<MinecraftSession> getMinecraftSession() {
        return this.minecraftSession;
    }

    @Generated
    public Holder<MinecraftMultiplayerToken> getMinecraftMultiplayerToken() {
        return this.minecraftMultiplayerToken;
    }

    @Generated
    public Holder<MinecraftCertificateChain> getMinecraftCertificateChain() {
        return this.minecraftCertificateChain;
    }

    public static class Builder {
        private final HttpClient httpClient;
        private final String gameVersion;
        private MsaApplicationConfig msaApplicationConfig = new MsaApplicationConfig("0000000048183522", "service::user.auth.xboxlive.com::MBI_SSL");
        private String deviceType = "Android";
        private KeyPair deviceKeyPair;
        private UUID deviceId;
        private KeyPair sessionKeyPair;

        public BedrockAuthManager login(MsaAuthServiceSupplier msaAuthServiceSupplier) throws IOException, InterruptedException, TimeoutException {
            MsaAuthService msaAuthService = msaAuthServiceSupplier.get(this.httpClient, this.msaApplicationConfig);
            return this.login(msaAuthService.acquireToken());
        }

        public <T> BedrockAuthManager login(ParamMsaAuthServiceSupplier<T> msaAuthServiceSupplier, T param) throws IOException, InterruptedException, TimeoutException {
            MsaAuthService msaAuthService = msaAuthServiceSupplier.get(this.httpClient, this.msaApplicationConfig, param);
            return this.login(msaAuthService.acquireToken());
        }

        public BedrockAuthManager login(String refreshToken) throws IOException {
            return this.login((MsaToken)this.httpClient.executeAndHandle((HttpRequest)new MsaRefreshTokenRequest(this.msaApplicationConfig, refreshToken)));
        }

        public BedrockAuthManager login(MsaToken msaToken) {
            return new BedrockAuthManager(this.httpClient, this.gameVersion, this.msaApplicationConfig, this.deviceType, this.deviceKeyPair != null ? this.deviceKeyPair : CryptUtil.generateEcdsa256KeyPair(), this.deviceId != null ? this.deviceId : UUID.randomUUID(), this.sessionKeyPair != null ? this.sessionKeyPair : CryptUtil.generateEcdsa384KeyPair(), msaToken);
        }

        @Generated
        public Builder msaApplicationConfig(MsaApplicationConfig msaApplicationConfig) {
            this.msaApplicationConfig = msaApplicationConfig;
            return this;
        }

        @Generated
        public Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Generated
        public Builder deviceKeyPair(KeyPair deviceKeyPair) {
            this.deviceKeyPair = deviceKeyPair;
            return this;
        }

        @Generated
        public Builder deviceId(UUID deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Generated
        public Builder sessionKeyPair(KeyPair sessionKeyPair) {
            this.sessionKeyPair = sessionKeyPair;
            return this;
        }

        @Generated
        private Builder(HttpClient httpClient, String gameVersion) {
            this.httpClient = httpClient;
            this.gameVersion = gameVersion;
        }
    }
}

