/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.bedrock.request;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyPair;
import java.time.Instant;
import java.util.Base64;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.bedrock.model.MinecraftMultiplayerToken;
import net.raphimc.minecraftauth.bedrock.model.MinecraftSession;
import net.raphimc.minecraftauth.bedrock.responsehandler.MinecraftServicesResponseHandler;
import net.raphimc.minecraftauth.util.http.content.JsonContent;

public class MinecraftMultiplayerSessionStartRequest
extends PostRequest
implements MinecraftServicesResponseHandler<MinecraftMultiplayerToken> {
    public MinecraftMultiplayerSessionStartRequest(MinecraftSession session, KeyPair ecdsa384KeyPair) throws MalformedURLException {
        super("https://authorization.franchise.minecraft-services.net/api/v1.0/multiplayer/session/start");
        JsonObject postData = new JsonObject();
        postData.addProperty("publicKey", Base64.getEncoder().encodeToString(ecdsa384KeyPair.getPublic().getEncoded()));
        this.setContent((HttpContent)new JsonContent(postData));
        this.setHeader("Authorization", session.getAuthorizationHeader());
    }

    @Override
    public MinecraftMultiplayerToken handle(HttpResponse response, GsonObject json) throws IOException {
        GsonObject result = json.reqObject("result");
        return new MinecraftMultiplayerToken(Instant.parse(result.reqString("validUntil")).toEpochMilli(), result.reqString("signedToken"));
    }
}

