/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.extra.realms.service.impl;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.raphimc.minecraftauth.extra.realms.model.RealmsJoinInformation;
import net.raphimc.minecraftauth.extra.realms.model.RealmsServer;
import net.raphimc.minecraftauth.extra.realms.request.BedrockRealmsInviteDeleteRequest;
import net.raphimc.minecraftauth.extra.realms.request.BedrockRealmsInviteLinkAcceptRequest;
import net.raphimc.minecraftauth.extra.realms.request.BedrockRealmsWorldJoinRequest;
import net.raphimc.minecraftauth.extra.realms.service.RealmsService;
import net.raphimc.minecraftauth.util.holder.Holder;
import net.raphimc.minecraftauth.xbl.model.XblXstsToken;

public class BedrockRealmsService
extends RealmsService {
    private final Holder<XblXstsToken> xstsToken;
    private final String gameVersion;

    public BedrockRealmsService(HttpClient httpClient, String gameVersion, Holder<XblXstsToken> xstsToken) {
        super(httpClient, "pocket.realms.minecraft.net");
        this.xstsToken = xstsToken;
        this.gameVersion = gameVersion;
    }

    public RealmsServer acceptInvite(String code) throws IOException {
        return (RealmsServer)this.httpClient.executeAndHandle((HttpRequest)this.authorizeRequest(new BedrockRealmsInviteLinkAcceptRequest(code)));
    }

    public RealmsServer acceptInviteUnchecked(String code) {
        return this.acceptInvite(code);
    }

    public CompletableFuture<RealmsServer> acceptInviteAsync(String code) {
        return CompletableFuture.supplyAsync(() -> this.acceptInviteUnchecked(code));
    }

    public void leaveInvitedRealm(RealmsServer server) throws IOException {
        this.httpClient.executeAndHandle((HttpRequest)this.authorizeRequest(new BedrockRealmsInviteDeleteRequest(server)));
    }

    public void leaveInvitedRealmUnchecked(RealmsServer server) {
        this.leaveInvitedRealm(server);
    }

    public CompletableFuture<Void> leaveInvitedRealmAsync(RealmsServer server) {
        return CompletableFuture.runAsync(() -> this.leaveInvitedRealmUnchecked(server));
    }

    @Override
    public RealmsJoinInformation joinWorld(RealmsServer server) throws IOException {
        return (RealmsJoinInformation)this.httpClient.executeAndHandle((HttpRequest)this.authorizeRequest(new BedrockRealmsWorldJoinRequest(server)));
    }

    @Override
    protected <T extends HttpRequest> T authorizeRequest(T httpRequest) throws IOException {
        httpRequest.setHeader("Authorization", this.xstsToken.getUpToDate().getAuthorizationHeader());
        httpRequest.setHeader("Client-Version", this.gameVersion);
        return httpRequest;
    }
}

