/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.extra.realms.service.impl;

import java.io.IOException;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.util.concurrent.CompletableFuture;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.raphimc.minecraftauth.extra.realms.model.RealmsJoinInformation;
import net.raphimc.minecraftauth.extra.realms.model.RealmsServer;
import net.raphimc.minecraftauth.extra.realms.request.JavaRealmsTosAgreedRequest;
import net.raphimc.minecraftauth.extra.realms.request.JavaRealmsWorldJoinRequest;
import net.raphimc.minecraftauth.extra.realms.service.RealmsService;
import net.raphimc.minecraftauth.java.model.MinecraftProfile;
import net.raphimc.minecraftauth.java.model.MinecraftToken;
import net.raphimc.minecraftauth.util.UuidUtil;
import net.raphimc.minecraftauth.util.holder.Holder;

public class JavaRealmsService
extends RealmsService {
    private final Holder<MinecraftToken> token;
    private final Holder<MinecraftProfile> profile;
    private final String gameVersion;

    public JavaRealmsService(HttpClient httpClient, String gameVersion, Holder<MinecraftToken> token, Holder<MinecraftProfile> profile) {
        super(httpClient, "pc.realms.minecraft.net");
        this.token = token;
        this.profile = profile;
        this.gameVersion = gameVersion;
    }

    @Override
    public RealmsJoinInformation joinWorld(RealmsServer server) throws IOException {
        return (RealmsJoinInformation)this.httpClient.executeAndHandle((HttpRequest)this.authorizeRequest(new JavaRealmsWorldJoinRequest(server)));
    }

    public void acceptTos() throws IOException {
        this.httpClient.executeAndHandle((HttpRequest)this.authorizeRequest(new JavaRealmsTosAgreedRequest()));
    }

    public void acceptTosUnchecked() {
        this.acceptTos();
    }

    public CompletableFuture<Void> acceptTosAsync() {
        return CompletableFuture.runAsync(this::acceptTosUnchecked);
    }

    @Override
    protected <T extends HttpRequest> T authorizeRequest(T httpRequest) throws IOException {
        CookieManager cookieManager = new CookieManager();
        MinecraftProfile profile = this.profile.getUpToDate();
        cookieManager.getCookieStore().add(null, this.createCookie("sid", "token:" + this.token.getUpToDate().getToken() + ':' + UuidUtil.toUndashedString(profile.getId())));
        cookieManager.getCookieStore().add(null, this.createCookie("user", profile.getName()));
        cookieManager.getCookieStore().add(null, this.createCookie("version", this.gameVersion));
        httpRequest.setCookieManager(cookieManager);
        httpRequest.setHeader("Is-Prerelease", String.valueOf(!this.gameVersion.matches("\\d+\\.\\d+(\\.\\d+)?")));
        return httpRequest;
    }

    private HttpCookie createCookie(String name, String value) {
        HttpCookie cookie = new HttpCookie(name, value);
        cookie.setDomain(this.host);
        cookie.setPath("/");
        return cookie;
    }
}

