/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.KeyPair;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.raphimc.minecraftauth.java.model.MinecraftPlayerCertificates;
import net.raphimc.minecraftauth.java.model.MinecraftProfile;
import net.raphimc.minecraftauth.java.model.MinecraftToken;
import net.raphimc.minecraftauth.java.request.MinecraftLauncherLoginRequest;
import net.raphimc.minecraftauth.java.request.MinecraftPlayerCertificatesRequest;
import net.raphimc.minecraftauth.java.request.MinecraftProfileRequest;
import net.raphimc.minecraftauth.msa.model.MsaApplicationConfig;
import net.raphimc.minecraftauth.msa.model.MsaToken;
import net.raphimc.minecraftauth.msa.request.MsaRefreshTokenRequest;
import net.raphimc.minecraftauth.msa.service.MsaAuthService;
import net.raphimc.minecraftauth.msa.service.util.MsaAuthServiceSupplier;
import net.raphimc.minecraftauth.msa.service.util.ParamMsaAuthServiceSupplier;
import net.raphimc.minecraftauth.util.CryptUtil;
import net.raphimc.minecraftauth.util.JsonUtil;
import net.raphimc.minecraftauth.util.holder.Holder;
import net.raphimc.minecraftauth.util.holder.listener.ChangeListeners;
import net.raphimc.minecraftauth.xbl.model.XblDeviceToken;
import net.raphimc.minecraftauth.xbl.model.XblSisuTokens;
import net.raphimc.minecraftauth.xbl.model.XblTitleToken;
import net.raphimc.minecraftauth.xbl.model.XblUserToken;
import net.raphimc.minecraftauth.xbl.model.XblXstsToken;
import net.raphimc.minecraftauth.xbl.request.XblDeviceAuthenticateRequest;
import net.raphimc.minecraftauth.xbl.request.XblSisuAuthorizeRequest;
import net.raphimc.minecraftauth.xbl.request.XblUserAuthenticateRequest;
import net.raphimc.minecraftauth.xbl.request.XblXstsAuthorizeRequest;

public class JavaAuthManager {
    private final HttpClient httpClient;
    private final MsaApplicationConfig msaApplicationConfig;
    private final String deviceType;
    private final KeyPair deviceKeyPair;
    private final UUID deviceId;
    private final ChangeListeners changeListeners = new ChangeListeners();
    private final Object sisuTokenLock = new Object();
    private final Holder<MsaToken> msaToken = new Holder<MsaToken>(this::refreshMsaToken);
    private final Holder<XblDeviceToken> xblDeviceToken = new Holder<XblDeviceToken>(this::refreshXblDeviceToken);
    private final Holder<XblUserToken> xblUserToken = new Holder<XblUserToken>(this::refreshXblUserToken, this.sisuTokenLock);
    private final Holder<XblTitleToken> xblTitleToken = new Holder<XblTitleToken>(this::refreshXblTitleToken, this.sisuTokenLock);
    private final Holder<XblXstsToken> javaXstsToken = new Holder<XblXstsToken>(this::refreshJavaXstsToken, this.sisuTokenLock);
    private final Holder<MinecraftToken> minecraftToken = new Holder<MinecraftToken>(this::refreshMinecraftToken);
    private final Holder<MinecraftProfile> minecraftProfile = new Holder<MinecraftProfile>(this::refreshMinecraftProfile);
    private final Holder<MinecraftPlayerCertificates> minecraftPlayerCertificates = new Holder<MinecraftPlayerCertificates>(this::refreshMinecraftPlayerCertificates);

    public static JavaAuthManager fromJson(HttpClient httpClient, JsonObject json) {
        return JavaAuthManager.fromJson(httpClient, new GsonObject(json));
    }

    public static JavaAuthManager fromJson(HttpClient httpClient, GsonObject json) {
        return new JavaAuthManager(httpClient, MsaApplicationConfig.fromJson(json.reqObject("msaApplicationConfig")), json.reqString("deviceType"), JsonUtil.decodeKeyPair(json.reqObject("deviceKeyPair")), UUID.fromString(json.reqString("deviceId")), MsaToken.fromJson(json.reqObject("msaToken")), json.optObject("xblDeviceToken").map(XblDeviceToken::fromJson).orElse(null), json.optObject("xblUserToken").map(XblUserToken::fromJson).orElse(null), json.optObject("xblTitleToken").map(XblTitleToken::fromJson).orElse(null), json.optObject("javaXstsToken").map(XblXstsToken::fromJson).orElse(null), json.optObject("minecraftToken").map(MinecraftToken::fromJson).orElse(null), json.optObject("minecraftProfile").map(MinecraftProfile::fromJson).orElse(null), json.optObject("minecraftPlayerCertificates").map(MinecraftPlayerCertificates::fromJson).orElse(null));
    }

    public static JsonObject toJson(JavaAuthManager authManager) {
        JsonObject json = new JsonObject();
        json.addProperty("_saveVersion", (Number)1);
        json.add("msaApplicationConfig", (JsonElement)MsaApplicationConfig.toJson(authManager.msaApplicationConfig));
        json.addProperty("deviceType", authManager.deviceType);
        json.add("deviceKeyPair", (JsonElement)JsonUtil.encodeKeyPair(authManager.deviceKeyPair));
        json.addProperty("deviceId", authManager.deviceId.toString());
        json.add("msaToken", (JsonElement)MsaToken.toJson(authManager.msaToken.getCached()));
        if (authManager.xblDeviceToken.hasValue()) {
            json.add("xblDeviceToken", (JsonElement)XblDeviceToken.toJson(authManager.xblDeviceToken.getCached()));
        }
        if (authManager.xblUserToken.hasValue()) {
            json.add("xblUserToken", (JsonElement)XblUserToken.toJson(authManager.xblUserToken.getCached()));
        }
        if (authManager.xblTitleToken.hasValue()) {
            json.add("xblTitleToken", (JsonElement)XblTitleToken.toJson(authManager.xblTitleToken.getCached()));
        }
        if (authManager.javaXstsToken.hasValue()) {
            json.add("javaXstsToken", (JsonElement)XblXstsToken.toJson(authManager.javaXstsToken.getCached()));
        }
        if (authManager.minecraftToken.hasValue()) {
            json.add("minecraftToken", (JsonElement)MinecraftToken.toJson(authManager.minecraftToken.getCached()));
        }
        if (authManager.minecraftProfile.hasValue()) {
            json.add("minecraftProfile", (JsonElement)MinecraftProfile.toJson(authManager.minecraftProfile.getCached()));
        }
        if (authManager.minecraftPlayerCertificates.hasValue()) {
            json.add("minecraftPlayerCertificates", (JsonElement)MinecraftPlayerCertificates.toJson(authManager.minecraftPlayerCertificates.getCached()));
        }
        return json;
    }

    public static Builder create(HttpClient httpClient) {
        return new Builder(httpClient);
    }

    private JavaAuthManager(HttpClient httpClient, MsaApplicationConfig msaApplicationConfig, String deviceType, KeyPair deviceKeyPair, UUID deviceId, MsaToken msaToken) {
        this.httpClient = httpClient;
        this.msaApplicationConfig = msaApplicationConfig;
        this.deviceType = deviceType;
        this.deviceKeyPair = deviceKeyPair;
        this.deviceId = deviceId;
        this.msaToken.set(msaToken);
        this.hookChangeListeners();
    }

    private JavaAuthManager(HttpClient httpClient, MsaApplicationConfig msaApplicationConfig, String deviceType, KeyPair deviceKeyPair, UUID deviceId, MsaToken msaToken, XblDeviceToken xblDeviceToken, XblUserToken xblUserToken, XblTitleToken xblTitleToken, XblXstsToken javaXstsToken, MinecraftToken minecraftToken, MinecraftProfile minecraftProfile, MinecraftPlayerCertificates minecraftPlayerCertificates) {
        this.httpClient = httpClient;
        this.msaApplicationConfig = msaApplicationConfig;
        this.deviceType = deviceType;
        this.deviceKeyPair = deviceKeyPair;
        this.deviceId = deviceId;
        this.msaToken.set(msaToken);
        this.xblDeviceToken.set(xblDeviceToken);
        this.xblUserToken.set(xblUserToken);
        this.xblTitleToken.set(xblTitleToken);
        this.javaXstsToken.set(javaXstsToken);
        this.minecraftToken.set(minecraftToken);
        this.minecraftProfile.set(minecraftProfile);
        this.minecraftPlayerCertificates.set(minecraftPlayerCertificates);
        this.hookChangeListeners();
    }

    private MsaToken refreshMsaToken() throws IOException {
        if (this.msaToken.getCached().getRefreshToken() == null) {
            throw new IllegalStateException("Can't refresh MSA token, because it was created without a refresh token. The user has to sign in again.");
        }
        return (MsaToken)this.httpClient.executeAndHandle((HttpRequest)new MsaRefreshTokenRequest(this.msaApplicationConfig, this.msaToken.getCached()));
    }

    private XblDeviceToken refreshXblDeviceToken() throws IOException {
        return (XblDeviceToken)this.httpClient.executeAndHandle((HttpRequest)new XblDeviceAuthenticateRequest(this.deviceType, this.deviceId, this.deviceKeyPair));
    }

    private XblUserToken refreshXblUserToken() throws IOException {
        if (this.msaApplicationConfig.isTitleClientId()) {
            this.refreshSisuTokens();
            return this.xblUserToken.getCached();
        }
        return (XblUserToken)this.httpClient.executeAndHandle((HttpRequest)new XblUserAuthenticateRequest(this.msaApplicationConfig, this.msaToken.getUpToDate()));
    }

    private XblTitleToken refreshXblTitleToken() throws IOException {
        if (!this.msaApplicationConfig.isTitleClientId()) {
            throw new UnsupportedOperationException("Can't refresh XBL title token, because the MSA application client ID is not a title client ID");
        }
        this.refreshSisuTokens();
        return this.xblTitleToken.getCached();
    }

    private XblXstsToken refreshJavaXstsToken() throws IOException {
        if (this.msaApplicationConfig.isTitleClientId()) {
            this.refreshSisuTokens();
            return this.javaXstsToken.getCached();
        }
        return (XblXstsToken)this.httpClient.executeAndHandle((HttpRequest)new XblXstsAuthorizeRequest(this.xblDeviceToken.getUpToDate(), this.xblUserToken.getUpToDate(), null, "rp://api.minecraftservices.com/"));
    }

    private MinecraftToken refreshMinecraftToken() throws IOException {
        return (MinecraftToken)this.httpClient.executeAndHandle((HttpRequest)new MinecraftLauncherLoginRequest(this.javaXstsToken.getUpToDate()));
    }

    private MinecraftProfile refreshMinecraftProfile() throws IOException {
        return (MinecraftProfile)this.httpClient.executeAndHandle((HttpRequest)new MinecraftProfileRequest(this.minecraftToken.getUpToDate()));
    }

    private MinecraftPlayerCertificates refreshMinecraftPlayerCertificates() throws IOException {
        return (MinecraftPlayerCertificates)this.httpClient.executeAndHandle((HttpRequest)new MinecraftPlayerCertificatesRequest(this.minecraftToken.getUpToDate()));
    }

    private void refreshSisuTokens() throws IOException {
        XblSisuTokens sisuTokens = (XblSisuTokens)this.httpClient.executeAndHandle((HttpRequest)new XblSisuAuthorizeRequest(this.msaApplicationConfig, this.msaToken.getUpToDate(), this.xblDeviceToken.getUpToDate(), this.deviceKeyPair, "rp://api.minecraftservices.com/"));
        this.xblUserToken.set(sisuTokens.getUserToken());
        this.xblTitleToken.set(sisuTokens.getTitleToken());
        this.javaXstsToken.set(sisuTokens.getXstsToken());
    }

    private void hookChangeListeners() {
        this.msaToken.getChangeListeners().add(this.changeListeners::invoke);
        this.xblDeviceToken.getChangeListeners().add(this.changeListeners::invoke);
        this.xblUserToken.getChangeListeners().add(this.changeListeners::invoke);
        this.xblTitleToken.getChangeListeners().add(this.changeListeners::invoke);
        this.javaXstsToken.getChangeListeners().add(this.changeListeners::invoke);
        this.minecraftToken.getChangeListeners().add(this.changeListeners::invoke);
        this.minecraftProfile.getChangeListeners().add(this.changeListeners::invoke);
        this.minecraftPlayerCertificates.getChangeListeners().add(this.changeListeners::invoke);
    }

    @Generated
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public MsaApplicationConfig getMsaApplicationConfig() {
        return this.msaApplicationConfig;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public KeyPair getDeviceKeyPair() {
        return this.deviceKeyPair;
    }

    @Generated
    public UUID getDeviceId() {
        return this.deviceId;
    }

    @Generated
    public ChangeListeners getChangeListeners() {
        return this.changeListeners;
    }

    @Generated
    public Holder<MsaToken> getMsaToken() {
        return this.msaToken;
    }

    @Generated
    public Holder<XblDeviceToken> getXblDeviceToken() {
        return this.xblDeviceToken;
    }

    @Generated
    public Holder<XblUserToken> getXblUserToken() {
        return this.xblUserToken;
    }

    @Generated
    public Holder<XblTitleToken> getXblTitleToken() {
        return this.xblTitleToken;
    }

    @Generated
    public Holder<XblXstsToken> getJavaXstsToken() {
        return this.javaXstsToken;
    }

    @Generated
    public Holder<MinecraftToken> getMinecraftToken() {
        return this.minecraftToken;
    }

    @Generated
    public Holder<MinecraftProfile> getMinecraftProfile() {
        return this.minecraftProfile;
    }

    @Generated
    public Holder<MinecraftPlayerCertificates> getMinecraftPlayerCertificates() {
        return this.minecraftPlayerCertificates;
    }

    public static class Builder {
        private final HttpClient httpClient;
        private MsaApplicationConfig msaApplicationConfig = new MsaApplicationConfig("00000000402b5328", "service::user.auth.xboxlive.com::MBI_SSL");
        private String deviceType = "Win32";
        private KeyPair deviceKeyPair;
        private UUID deviceId;

        public JavaAuthManager login(MsaAuthServiceSupplier msaAuthServiceSupplier) throws IOException, InterruptedException, TimeoutException {
            MsaAuthService msaAuthService = msaAuthServiceSupplier.get(this.httpClient, this.msaApplicationConfig);
            return this.login(msaAuthService.acquireToken());
        }

        public <T> JavaAuthManager login(ParamMsaAuthServiceSupplier<T> msaAuthServiceSupplier, T param) throws IOException, InterruptedException, TimeoutException {
            MsaAuthService msaAuthService = msaAuthServiceSupplier.get(this.httpClient, this.msaApplicationConfig, param);
            return this.login(msaAuthService.acquireToken());
        }

        public JavaAuthManager login(String refreshToken) throws IOException {
            return this.login((MsaToken)this.httpClient.executeAndHandle((HttpRequest)new MsaRefreshTokenRequest(this.msaApplicationConfig, refreshToken)));
        }

        public JavaAuthManager login(MsaToken msaToken) {
            return new JavaAuthManager(this.httpClient, this.msaApplicationConfig, this.deviceType, this.deviceKeyPair != null ? this.deviceKeyPair : CryptUtil.generateEcdsa256KeyPair(), this.deviceId != null ? this.deviceId : UUID.randomUUID(), msaToken);
        }

        @Generated
        public Builder msaApplicationConfig(MsaApplicationConfig msaApplicationConfig) {
            this.msaApplicationConfig = msaApplicationConfig;
            return this;
        }

        @Generated
        public Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Generated
        public Builder deviceKeyPair(KeyPair deviceKeyPair) {
            this.deviceKeyPair = deviceKeyPair;
            return this;
        }

        @Generated
        public Builder deviceId(UUID deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Generated
        private Builder(HttpClient httpClient) {
            this.httpClient = httpClient;
        }
    }
}

