/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.msa.model;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.raphimc.minecraftauth.msa.data.MsaEnvironment;
import net.raphimc.minecraftauth.util.UuidUtil;

public final class MsaApplicationConfig {
    private final String clientId;
    private final String scope;
    private final String clientSecret;
    private final String redirectUri;
    private final MsaEnvironment environment;

    public static MsaApplicationConfig fromJson(JsonObject json) {
        return MsaApplicationConfig.fromJson(new GsonObject(json));
    }

    public static MsaApplicationConfig fromJson(GsonObject json) {
        return new MsaApplicationConfig(json.reqString("clientId"), json.reqString("scope"), json.getString("clientSecret", null), json.getString("redirectUri", null), MsaEnvironment.valueOf(json.getString("environment", MsaEnvironment.LIVE.name())));
    }

    public static JsonObject toJson(MsaApplicationConfig applicationConfig) {
        JsonObject json = new JsonObject();
        json.addProperty("_saveVersion", (Number)1);
        json.addProperty("clientId", applicationConfig.clientId);
        json.addProperty("scope", applicationConfig.scope);
        json.addProperty("clientSecret", applicationConfig.clientSecret);
        json.addProperty("redirectUri", applicationConfig.redirectUri);
        json.addProperty("environment", applicationConfig.environment.name());
        return json;
    }

    public MsaApplicationConfig(String clientId, String scope) {
        this(clientId, scope, null, null, MsaEnvironment.LIVE);
    }

    public boolean isTitleClientId() {
        return !UuidUtil.isDashedUuid(this.clientId);
    }

    public Map<String, String> getAuthCodeParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_id", this.clientId);
        parameters.put("scope", this.scope);
        if (this.redirectUri != null) {
            parameters.put("redirect_uri", this.redirectUri);
        }
        parameters.put("response_type", "code");
        parameters.put("response_mode", "query");
        return parameters;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getScope() {
        return this.scope;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Generated
    public MsaEnvironment getEnvironment() {
        return this.environment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MsaApplicationConfig)) {
            return false;
        }
        MsaApplicationConfig other = (MsaApplicationConfig)o;
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$redirectUri = this.getRedirectUri();
        String other$redirectUri = other.getRedirectUri();
        if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
            return false;
        }
        MsaEnvironment this$environment = this.getEnvironment();
        MsaEnvironment other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !((Object)((Object)this$environment)).equals((Object)other$environment));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $redirectUri = this.getRedirectUri();
        result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
        MsaEnvironment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)((Object)$environment)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MsaApplicationConfig(clientId=" + this.getClientId() + ", scope=" + this.getScope() + ", clientSecret=" + this.getClientSecret() + ", redirectUri=" + this.getRedirectUri() + ", environment=" + (Object)((Object)this.getEnvironment()) + ")";
    }

    @Generated
    public MsaApplicationConfig withClientId(String clientId) {
        return this.clientId == clientId ? this : new MsaApplicationConfig(clientId, this.scope, this.clientSecret, this.redirectUri, this.environment);
    }

    @Generated
    public MsaApplicationConfig withScope(String scope) {
        return this.scope == scope ? this : new MsaApplicationConfig(this.clientId, scope, this.clientSecret, this.redirectUri, this.environment);
    }

    @Generated
    public MsaApplicationConfig withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new MsaApplicationConfig(this.clientId, this.scope, clientSecret, this.redirectUri, this.environment);
    }

    @Generated
    public MsaApplicationConfig withRedirectUri(String redirectUri) {
        return this.redirectUri == redirectUri ? this : new MsaApplicationConfig(this.clientId, this.scope, this.clientSecret, redirectUri, this.environment);
    }

    @Generated
    public MsaApplicationConfig withEnvironment(MsaEnvironment environment) {
        return this.environment == environment ? this : new MsaApplicationConfig(this.clientId, this.scope, this.clientSecret, this.redirectUri, environment);
    }

    @Generated
    public MsaApplicationConfig(String clientId, String scope, String clientSecret, String redirectUri, MsaEnvironment environment) {
        this.clientId = clientId;
        this.scope = scope;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.environment = environment;
    }
}

