/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.msa.service.impl;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.CookieManager;
import java.net.URL;
import java.util.HashMap;
import java.util.Optional;
import net.lenni0451.commons.gson.GsonParser;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.constants.ContentTypes;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.content.impl.URLEncodedFormContent;
import net.lenni0451.commons.httpclient.exceptions.HttpRequestException;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.GetRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.lenni0451.commons.httpclient.utils.URLWrapper;
import net.raphimc.minecraftauth.msa.exception.MsaRequestException;
import net.raphimc.minecraftauth.msa.model.MsaApplicationConfig;
import net.raphimc.minecraftauth.msa.model.MsaCredentials;
import net.raphimc.minecraftauth.msa.model.MsaToken;
import net.raphimc.minecraftauth.msa.request.MsaAuthCodeTokenRequest;
import net.raphimc.minecraftauth.msa.service.MsaAuthService;
import net.raphimc.minecraftauth.util.http.exception.InformativeHttpRequestException;

public class CredentialsMsaAuthService
extends MsaAuthService {
    private final MsaCredentials credentials;

    public CredentialsMsaAuthService(HttpClient httpClient, MsaApplicationConfig applicationConfig, MsaCredentials credentials) {
        super(httpClient, applicationConfig);
        this.credentials = credentials;
    }

    @Override
    public MsaToken acquireToken() throws IOException {
        return this.acquireToken(this.credentials);
    }

    public MsaToken acquireToken(MsaCredentials credentials) throws IOException {
        CookieManager cookieManager = new CookieManager();
        PostRequest loginRequest = this.prepareLoginRequest(credentials, cookieManager);
        HttpResponse loginResponse = this.sendLoginRequest((HttpRequest)loginRequest);
        String location = (String)loginResponse.getFirstHeader("Location").orElseThrow(() -> new IllegalStateException("Could not get redirect url"));
        String code = (String)URLWrapper.ofURI((String)location).wrapQueryParameters().getFirstValue("code").orElseThrow(() -> new IllegalStateException("Could not extract auth code from redirect url"));
        return (MsaToken)this.httpClient.executeAndHandle((HttpRequest)new MsaAuthCodeTokenRequest(this.applicationConfig, code));
    }

    private PostRequest prepareLoginRequest(MsaCredentials credentials, CookieManager cookieManager) throws IOException {
        String postUrl;
        URL authenticationUrl = URLWrapper.ofURL((String)this.applicationConfig.getEnvironment().getAuthorizeUrl()).wrapQueryParameters().addParameters(this.applicationConfig.getAuthCodeParameters()).apply().toURL();
        GetRequest getRequest = new GetRequest(authenticationUrl);
        getRequest.setCookieManager(cookieManager);
        getRequest.setHeader("Accept", ContentTypes.TEXT_HTML.getMimeType());
        GsonObject config = (GsonObject)this.httpClient.execute((HttpRequest)getRequest, response -> {
            if (response.getStatusCode() >= 300) {
                Optional locationHeader = response.getFirstHeader("Location");
                if (locationHeader.isPresent()) {
                    URLWrapper.QueryParametersWrapper parameters = URLWrapper.ofURI((String)((String)locationHeader.get())).wrapQueryParameters();
                    Optional error = parameters.getFirstValue("error");
                    Optional errorDescription = parameters.getFirstValue("error_description");
                    if (error.isPresent() && errorDescription.isPresent()) {
                        throw new MsaRequestException(response, (String)error.get(), (String)errorDescription.get());
                    }
                }
                throw new HttpRequestException(response);
            }
            return this.extractConfig(response.getContent().getAsString());
        });
        HashMap<String, String> postData = new HashMap<String, String>();
        switch (this.applicationConfig.getEnvironment()) {
            case LIVE: {
                postUrl = config.reqString("urlPost");
                String sFTTag = config.reqString("sFTTag");
                String sFT = sFTTag.substring(sFTTag.indexOf("value=\"") + 7);
                sFT = sFT.substring(0, sFT.indexOf("\""));
                String sFTName = sFTTag.substring(sFTTag.indexOf("name=\"") + 6);
                sFTName = sFTName.substring(0, sFTName.indexOf("\""));
                postData.put("login", credentials.getEmail());
                postData.put("loginfmt", credentials.getEmail());
                postData.put("passwd", credentials.getPassword());
                postData.put(sFTName, sFT);
                break;
            }
            case MICROSOFT_ONLINE_COMMON: 
            case MICROSOFT_ONLINE_CONSUMERS: {
                postUrl = URLWrapper.ofURI((String)config.reqString("urlPost")).setProtocol(authenticationUrl.getProtocol()).setHost(authenticationUrl.getHost()).toURL().toString();
                postData.put("login", credentials.getEmail());
                postData.put("loginfmt", credentials.getEmail());
                postData.put("passwd", credentials.getPassword());
                postData.put("ctx", config.reqString("sCtx"));
                postData.put(config.reqString("sFTName"), config.reqString("sFT"));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported MsaEnvironment: " + (Object)((Object)this.applicationConfig.getEnvironment()));
            }
        }
        PostRequest postRequest = new PostRequest(postUrl);
        postRequest.setCookieManager(cookieManager);
        postRequest.setHeader("Accept", ContentTypes.TEXT_HTML.getMimeType());
        postRequest.setContent((HttpContent)new URLEncodedFormContent(postData));
        return postRequest;
    }

    private HttpResponse sendLoginRequest(HttpRequest request) throws IOException {
        HttpResponse loginResponse = this.httpClient.execute(request);
        if (loginResponse.getStatusCode() != 302) {
            if (!loginResponse.getContent().getType().getMimeType().equals(ContentTypes.TEXT_HTML.getMimeType())) {
                throw new InformativeHttpRequestException(loginResponse, "Wrong content type");
            }
            String responseString = loginResponse.getContent().getAsString();
            if (responseString.contains("<body onload=\"javascript:DoSubmit();\">")) {
                String actionUrl = responseString.substring(responseString.indexOf("action=\"") + 8);
                String returnUrl = URLWrapper.ofURL((String)(actionUrl = actionUrl.substring(0, actionUrl.indexOf("\"")))).wrapQueryParameters().getFirstValue("ru").orElse(null);
                if (returnUrl == null) {
                    throw new IllegalStateException("Could not extract return url from html");
                }
                GetRequest getRequest = new GetRequest(returnUrl);
                getRequest.setCookieManager(request.getCookieManager());
                getRequest.setHeader("Accept", ContentTypes.TEXT_HTML.getMimeType());
                return this.sendLoginRequest((HttpRequest)getRequest);
            }
            GsonObject errorConfig = this.extractConfig(responseString);
            switch (this.applicationConfig.getEnvironment()) {
                case LIVE: {
                    if (!errorConfig.hasString("sErrorCode") || !errorConfig.hasString("sErrTxt")) break;
                    throw new MsaRequestException(loginResponse, errorConfig.reqString("sErrorCode"), errorConfig.reqString("sErrTxt"));
                }
                case MICROSOFT_ONLINE_COMMON: 
                case MICROSOFT_ONLINE_CONSUMERS: {
                    if (!errorConfig.hasString("iErrorCode") || !errorConfig.hasString("strServiceExceptionMessage")) break;
                    throw new MsaRequestException(loginResponse, errorConfig.reqString("iErrorCode"), errorConfig.reqString("strServiceExceptionMessage"));
                }
                default: {
                    throw new IllegalStateException("Unsupported MsaEnvironment: " + (Object)((Object)this.applicationConfig.getEnvironment()));
                }
            }
            throw new IllegalStateException("Could not extract config from html. This most likely indicates that the application config or credentials are not valid");
        }
        return loginResponse;
    }

    private GsonObject extractConfig(String html) {
        String configStart;
        switch (this.applicationConfig.getEnvironment()) {
            case LIVE: {
                int configStartIndex = html.indexOf("var ServerData = ");
                if (configStartIndex == -1) {
                    throw new IllegalStateException("Could not find config start in html");
                }
                configStart = html.substring(configStartIndex + 17);
                break;
            }
            case MICROSOFT_ONLINE_COMMON: 
            case MICROSOFT_ONLINE_CONSUMERS: {
                int configStartIndex = html.indexOf("$Config=");
                if (configStartIndex == -1) {
                    throw new IllegalStateException("Could not find config start in html");
                }
                configStart = html.substring(configStartIndex + 8);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported MsaEnvironment: " + (Object)((Object)this.applicationConfig.getEnvironment()));
            }
        }
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(configStart));
            jsonReader.setLenient(true);
            return GsonParser.parse((JsonReader)jsonReader).asObject();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not extract config from html. This most likely indicates that the application config or credentials are not valid", e);
        }
    }
}

