/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.msa.service.impl;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JFrame;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.utils.URLWrapper;
import net.raphimc.minecraftauth.msa.exception.MsaRequestException;
import net.raphimc.minecraftauth.msa.model.MsaApplicationConfig;
import net.raphimc.minecraftauth.msa.model.MsaToken;
import net.raphimc.minecraftauth.msa.request.MsaAuthCodeTokenRequest;
import net.raphimc.minecraftauth.msa.service.MsaAuthService;

public class JfxWebViewMsaAuthService
extends MsaAuthService {
    private final Consumer<JFrame> openCallback;
    private final Consumer<JFrame> closeCallback;
    private final int timeoutMs;

    public JfxWebViewMsaAuthService(HttpClient httpClient, MsaApplicationConfig applicationConfig) {
        this(httpClient, applicationConfig, window -> window.setVisible(true), Window::dispose);
    }

    public JfxWebViewMsaAuthService(HttpClient httpClient, MsaApplicationConfig applicationConfig, Consumer<JFrame> openCallback, Consumer<JFrame> closeCallback) {
        this(httpClient, applicationConfig, openCallback, closeCallback, 300000);
    }

    public JfxWebViewMsaAuthService(HttpClient httpClient, MsaApplicationConfig applicationConfig, Consumer<JFrame> openCallback, Consumer<JFrame> closeCallback, int timeoutMs) {
        super(httpClient, applicationConfig);
        this.openCallback = openCallback;
        this.closeCallback = closeCallback;
        this.timeoutMs = timeoutMs;
    }

    @Override
    public MsaToken acquireToken() throws IOException, InterruptedException, TimeoutException {
        URL authenticationUrl = URLWrapper.ofURL((String)this.applicationConfig.getEnvironment().getAuthorizeUrl()).wrapQueryParameters().addParameters(this.applicationConfig.getAuthCodeParameters()).apply().toURL();
        final CompletableFuture authCodeFuture = new CompletableFuture();
        JFXPanel jfxPanel = new JFXPanel();
        JFrame window = new JFrame("MinecraftAuth - Microsoft Login");
        window.setDefaultCloseOperation(0);
        window.setSize(800, 600);
        window.setLocationRelativeTo(null);
        window.setResizable(false);
        window.setContentPane((Container)jfxPanel);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!authCodeFuture.isDone()) {
                    authCodeFuture.completeExceptionally(new UserClosedWindowException());
                }
            }
        });
        Platform.runLater(() -> {
            WebView webView = new WebView();
            webView.setContextMenuEnabled(false);
            this.httpClient.getFirstHeader("User-Agent").ifPresent(arg_0 -> ((WebEngine)webView.getEngine()).setUserAgent(arg_0));
            webView.getEngine().load(authenticationUrl.toString());
            webView.getEngine().locationProperty().addListener((observable, oldValue, newValue) -> {
                try {
                    URLWrapper.QueryParametersWrapper parameters = URLWrapper.ofURI((String)newValue).wrapQueryParameters();
                    Optional error = parameters.getFirstValue("error");
                    Optional errorDescription = parameters.getFirstValue("error_description");
                    if (error.isPresent() && errorDescription.isPresent()) {
                        HttpResponse fakeResponse = new HttpResponse(null, 500, new byte[0], Collections.emptyMap());
                        throw new MsaRequestException(fakeResponse, (String)error.get(), (String)errorDescription.get());
                    }
                    parameters.getFirstValue("code").ifPresent(authCodeFuture::complete);
                }
                catch (Throwable e) {
                    authCodeFuture.completeExceptionally(e);
                }
            });
            jfxPanel.setScene(new Scene((Parent)webView, (double)window.getWidth(), (double)window.getHeight()));
            this.openCallback.accept(window);
        });
        try {
            String authCode = (String)authCodeFuture.get(this.timeoutMs, TimeUnit.MILLISECONDS);
            MsaToken msaToken = (MsaToken)this.httpClient.executeAndHandle((HttpRequest)new MsaAuthCodeTokenRequest(this.applicationConfig, authCode));
            return msaToken;
        }
        catch (TimeoutException e) {
            throw new TimeoutException("Login timed out");
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        finally {
            this.closeCallback.accept(window);
        }
    }

    public static class UserClosedWindowException
    extends RuntimeException {
        public UserClosedWindowException() {
            super("User closed the login window");
        }
    }
}

