/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.xbl.request;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.MalformedURLException;
import java.time.Instant;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.msa.model.MsaApplicationConfig;
import net.raphimc.minecraftauth.msa.model.MsaToken;
import net.raphimc.minecraftauth.util.http.content.JsonContent;
import net.raphimc.minecraftauth.xbl.model.XblUserToken;
import net.raphimc.minecraftauth.xbl.responsehandler.XblResponseHandler;

public class XblUserAuthenticateRequest
extends PostRequest
implements XblResponseHandler<XblUserToken> {
    public XblUserAuthenticateRequest(MsaApplicationConfig applicationConfig, MsaToken token) throws MalformedURLException {
        super("https://user.auth.xboxlive.com/user/authenticate");
        JsonObject properties = new JsonObject();
        properties.addProperty("SiteName", "user.auth.xboxlive.com");
        properties.addProperty("AuthMethod", "RPS");
        properties.addProperty("RpsTicket", (applicationConfig.isTitleClientId() ? "t=" : "d=") + token.getAccessToken());
        JsonObject postData = new JsonObject();
        postData.add("Properties", (JsonElement)properties);
        postData.addProperty("RelyingParty", "http://auth.xboxlive.com");
        postData.addProperty("TokenType", "JWT");
        this.setContent((HttpContent)new JsonContent(postData));
        this.setHeader("x-xbl-contract-version", "1");
    }

    @Override
    public XblUserToken handle(HttpResponse response, GsonObject json) {
        return new XblUserToken(Instant.parse(json.reqString("NotAfter")).toEpochMilli(), json.reqString("Token"), json.reqObject("DisplayClaims").reqArray("xui").get(0).asObject().reqString("uhs"));
    }
}

