/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.io.compression;

import net.raphimc.viabedrock.api.io.compression.CompressionAlgorithm;
import net.raphimc.viabedrock.api.io.compression.NoopCompression;
import net.raphimc.viabedrock.api.io.compression.SnappyCompression;
import net.raphimc.viabedrock.api.io.compression.ZLibCompression;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.PacketCompressionAlgorithm;

public class ProtocolCompression {
    private final CompressionAlgorithm preferredCompressionAlgorithm;
    private final int threshold;
    private ZLibCompression zLibCompression;
    private SnappyCompression snappyCompression;

    public ProtocolCompression(PacketCompressionAlgorithm preferredCompressionAlgorithm, int threshold) {
        this.preferredCompressionAlgorithm = this.getCompressionAlgorithm(preferredCompressionAlgorithm);
        this.threshold = threshold;
    }

    public void end() {
        if (this.zLibCompression != null) {
            this.zLibCompression.end();
        }
        if (this.snappyCompression != null) {
            this.snappyCompression.end();
        }
    }

    public CompressionAlgorithm getCompressionAlgorithmForSize(int inputSize) {
        if (inputSize < this.threshold) {
            return NoopCompression.INSTANCE;
        }
        return this.preferredCompressionAlgorithm;
    }

    public CompressionAlgorithm getCompressionAlgorithm(PacketCompressionAlgorithm algorithm) {
        return switch (algorithm) {
            case PacketCompressionAlgorithm.None -> NoopCompression.INSTANCE;
            case PacketCompressionAlgorithm.ZLib -> {
                if (this.zLibCompression == null) {
                    this.zLibCompression = new ZLibCompression();
                }
                yield this.zLibCompression;
            }
            case PacketCompressionAlgorithm.Snappy -> {
                if (this.snappyCompression == null) {
                    this.snappyCompression = new SnappyCompression();
                }
                yield this.snappyCompression;
            }
            default -> throw new IllegalStateException("Unhandled PacketCompressionAlgorithm " + algorithm);
        };
    }
}

