/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.io.compression;

import com.viaversion.viaversion.api.type.Types;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.Snappy;
import net.raphimc.viabedrock.api.io.compression.CompressionAlgorithm;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.PacketCompressionAlgorithm;

public class SnappyCompression
implements CompressionAlgorithm {
    private final Snappy snappy = new Snappy();

    @Override
    public void compress(ByteBuf in, ByteBuf out) {
        if (in.readableBytes() <= Short.MAX_VALUE) {
            this.snappy.encode(in, out, in.readableBytes());
            this.snappy.reset();
        } else {
            Types.VAR_INT.writePrimitive(out, in.readableBytes());
            int value = in.readableBytes() - 1;
            int highestOneBit = Integer.highestOneBit(value);
            int bitLength = 0;
            while ((highestOneBit >>= 1) != 0) {
                ++bitLength;
            }
            int bytesToEncode = 1 + bitLength / 8;
            out.writeByte(59 + bytesToEncode << 2);
            for (int i = 0; i < bytesToEncode; ++i) {
                out.writeByte(in.readableBytes() - 1 >> i * 8 & 0xFF);
            }
            out.writeBytes(in);
        }
    }

    @Override
    public void decompress(ByteBuf in, ByteBuf out) {
        this.snappy.decode(in, out);
        this.snappy.reset();
    }

    @Override
    public PacketCompressionAlgorithm getAlgorithm() {
        return PacketCompressionAlgorithm.Snappy;
    }
}

