/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.io.compression;

import io.netty.buffer.ByteBuf;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.raphimc.viabedrock.api.io.compression.CompressionAlgorithm;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.PacketCompressionAlgorithm;

public class ZLibCompression
implements CompressionAlgorithm {
    private final Deflater deflater = new Deflater(-1, true);
    private final Inflater inflater = new Inflater(true);
    private final byte[] deflateBuffer = new byte[8192];
    private final byte[] inflateBuffer = new byte[8192];

    @Override
    public void compress(ByteBuf in, ByteBuf out) {
        byte[] uncompressedData = new byte[in.readableBytes()];
        in.readBytes(uncompressedData);
        this.deflater.setInput(uncompressedData);
        this.deflater.finish();
        while (!this.deflater.finished()) {
            out.writeBytes(this.deflateBuffer, 0, this.deflater.deflate(this.deflateBuffer));
        }
        this.deflater.reset();
    }

    @Override
    public void decompress(ByteBuf in, ByteBuf out) throws Exception {
        byte[] compressedData = new byte[in.readableBytes()];
        in.readBytes(compressedData);
        this.inflater.setInput(compressedData);
        while (!this.inflater.finished()) {
            out.writeBytes(this.inflateBuffer, 0, this.inflater.inflate(this.inflateBuffer));
        }
        this.inflater.reset();
    }

    @Override
    public void end() {
        this.inflater.end();
        this.deflater.end();
    }

    @Override
    public PacketCompressionAlgorithm getAlgorithm() {
        return PacketCompressionAlgorithm.ZLib;
    }
}

