/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.entity;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityData;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import com.viaversion.viaversion.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.PlayerEntity;
import net.raphimc.viabedrock.api.util.EnumUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.enums.Direction;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AbilitiesIndex;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AnimatePacket_Action;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AttributeModifierOperation;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AttributeOperands;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.GameType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.PlayerActionType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.PlayerAuthInputPacket_InputData;
import net.raphimc.viabedrock.protocol.data.enums.java.AbilitiesFlag;
import net.raphimc.viabedrock.protocol.data.enums.java.GameMode;
import net.raphimc.viabedrock.protocol.data.enums.java.InputFlag;
import net.raphimc.viabedrock.protocol.data.enums.java.MovePlayerFlag;
import net.raphimc.viabedrock.protocol.data.enums.java.Relative;
import net.raphimc.viabedrock.protocol.model.EntityAttribute;
import net.raphimc.viabedrock.protocol.model.PlayerAbilities;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.GameTypeRewriter;
import net.raphimc.viabedrock.protocol.storage.ChunkTracker;
import net.raphimc.viabedrock.protocol.storage.CommandsStorage;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.PlayerListStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ClientPlayerEntity
extends PlayerEntity {
    private final AtomicInteger TELEPORT_ID = new AtomicInteger(1);
    private final GameSessionStorage gameSession;
    private boolean initiallySpawned;
    private DimensionChangeInfo dimensionChangeInfo;
    private boolean wasInsideUnloadedChunk;
    private int pendingTeleportId;
    private boolean waitingForPositionSync;
    private boolean serverSideTeleportConfirmed;
    private Position3f prevPosition;
    private boolean prevOnGround;
    private final Set<PlayerAuthInputPacket_InputData> authInputData = EnumSet.noneOf(PlayerAuthInputPacket_InputData.class);
    private final List<AuthInputBlockAction> authInputBlockActions = new ArrayList<AuthInputBlockAction>();
    private Set<InputFlag> inputFlags = EnumSet.noneOf(InputFlag.class);
    private Set<InputFlag> prevInputFlags = EnumSet.noneOf(InputFlag.class);
    private boolean horizontalCollision;
    private boolean sneaking;
    private boolean sprinting;
    private GameType gameType;
    private GameMode javaGameMode;
    private boolean cancelNextSwingPacket;
    private BlockBreakingInfo blockBreakingInfo;

    public ClientPlayerEntity(UserConnection user, long runtimeId, UUID javaUuid, PlayerAbilities abilities) {
        super(user, runtimeId, 0, javaUuid, abilities);
        this.attributes.put("minecraft:movement", new EntityAttribute("minecraft:movement", 0.7f, 0.0f, Float.MAX_VALUE));
        this.attributes.put("minecraft:player.hunger", new EntityAttribute("minecraft:player.hunger", 20.0f, 0.0f, 20.0f));
        this.attributes.put("minecraft:player.saturation", new EntityAttribute("minecraft:player.saturation", 5.0f, 0.0f, 20.0f));
        this.attributes.put("minecraft:player.experience", new EntityAttribute("minecraft:player.experience", 0.0f, 0.0f, 1.0f));
        this.attributes.put("minecraft:player.level", new EntityAttribute("minecraft:player.level", 0.0f, 0.0f, 24791.0f));
        this.gameSession = (GameSessionStorage)user.get(GameSessionStorage.class);
    }

    @Override
    public void tick() {
        super.tick();
        this.prevPosition = this.position;
        this.prevOnGround = this.onGround;
        this.prevInputFlags = this.inputFlags;
    }

    public void sendPlayerPositionPacketToClient(Set<Relative> relatives) {
        PacketWrapper playerPosition = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.PLAYER_POSITION, (UserConnection)this.user);
        this.writePlayerPositionPacketToClient(playerPosition, relatives, true);
        playerPosition.send(BedrockProtocol.class);
    }

    public void writePlayerPositionPacketToClient(PacketWrapper wrapper, Set<Relative> relatives, boolean fakeTeleport) {
        this.pendingTeleportId = this.TELEPORT_ID.getAndIncrement();
        wrapper.write((Type)Types.VAR_INT, (Object)(this.pendingTeleportId * (fakeTeleport ? -1 : 1)));
        wrapper.write((Type)Types.DOUBLE, (Object)(relatives.contains((Object)Relative.X) ? 0.0 : (double)this.position.x()));
        wrapper.write((Type)Types.DOUBLE, (Object)(relatives.contains((Object)Relative.Y) ? 0.0 : (double)(this.position.y() - this.eyeOffset())));
        wrapper.write((Type)Types.DOUBLE, (Object)(relatives.contains((Object)Relative.Z) ? 0.0 : (double)this.position.z()));
        wrapper.write((Type)Types.DOUBLE, (Object)0.0);
        wrapper.write((Type)Types.DOUBLE, (Object)0.0);
        wrapper.write((Type)Types.DOUBLE, (Object)0.0);
        wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(relatives.contains((Object)Relative.Y_ROT) ? 0.0f : this.rotation.y()));
        wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(relatives.contains((Object)Relative.X_ROT) ? 0.0f : this.rotation.x()));
        wrapper.write((Type)Types.INT, (Object)EnumUtil.getIntBitmaskFromEnumSet(relatives, Enum::ordinal));
    }

    public void sendPlayerActionPacketToServer(PlayerActionType action) {
        this.sendPlayerActionPacketToServer(action, 0);
    }

    public void sendPlayerActionPacketToServer(PlayerActionType action, int direction) {
        this.sendPlayerActionPacketToServer(action, new BlockPosition(0, 0, 0), direction);
    }

    public void sendPlayerActionPacketToServer(PlayerActionType action, BlockPosition blockPosition, int direction) {
        PacketWrapper playerAction = PacketWrapper.create((PacketType)ServerboundBedrockPackets.PLAYER_ACTION, (UserConnection)this.user);
        playerAction.write((Type)BedrockTypes.UNSIGNED_VAR_LONG, (Object)this.runtimeId);
        playerAction.write((Type)BedrockTypes.VAR_INT, (Object)action.getValue());
        playerAction.write(BedrockTypes.BLOCK_POSITION, (Object)blockPosition);
        playerAction.write(BedrockTypes.BLOCK_POSITION, (Object)new BlockPosition(0, 0, 0));
        playerAction.write((Type)BedrockTypes.VAR_INT, (Object)direction);
        playerAction.sendToServer(BedrockProtocol.class);
    }

    public void sendSwingPacketToServer() {
        PacketWrapper animate = PacketWrapper.create((PacketType)ServerboundBedrockPackets.ANIMATE, (UserConnection)this.user);
        animate.write((Type)BedrockTypes.VAR_INT, (Object)AnimatePacket_Action.Swing.getValue());
        animate.write((Type)BedrockTypes.UNSIGNED_VAR_LONG, (Object)this.runtimeId);
        animate.sendToServer(BedrockProtocol.class);
    }

    public void updatePlayerPosition(short flags) {
        boolean newOnGround;
        boolean bl = newOnGround = (flags & MovePlayerFlag.ON_GROUND.getBit()) != 0;
        if (!this.preMove(null, null, newOnGround)) {
            return;
        }
        this.onGround = newOnGround;
        this.horizontalCollision = (flags & MovePlayerFlag.HORIZONTAL_COLLISION.getBit()) != 0;
    }

    public void updatePlayerPosition(double x, double y, double z, short flags) {
        boolean newOnGround;
        Position3f newPosition = new Position3f((float)x, (float)y + this.eyeOffset(), (float)z);
        boolean bl = newOnGround = (flags & MovePlayerFlag.ON_GROUND.getBit()) != 0;
        if (!this.preMove(newPosition, null, newOnGround)) {
            return;
        }
        this.position = newPosition;
        this.onGround = newOnGround;
        this.horizontalCollision = (flags & MovePlayerFlag.HORIZONTAL_COLLISION.getBit()) != 0;
    }

    public void updatePlayerPosition(double x, double y, double z, float yaw, float pitch, short flags) {
        boolean newOnGround;
        Position3f newPosition = new Position3f((float)x, (float)y + this.eyeOffset(), (float)z);
        Position3f newRotation = new Position3f(pitch, yaw, yaw);
        boolean bl = newOnGround = (flags & MovePlayerFlag.ON_GROUND.getBit()) != 0;
        if (!this.preMove(newPosition, newRotation, newOnGround)) {
            return;
        }
        this.position = newPosition;
        this.rotation = newRotation;
        this.onGround = newOnGround;
        this.horizontalCollision = (flags & MovePlayerFlag.HORIZONTAL_COLLISION.getBit()) != 0;
    }

    public void updatePlayerPosition(float yaw, float pitch, short flags) {
        boolean newOnGround;
        Position3f newRotation = new Position3f(pitch, yaw, yaw);
        boolean bl = newOnGround = (flags & MovePlayerFlag.ON_GROUND.getBit()) != 0;
        if (!this.preMove(null, newRotation, newOnGround)) {
            return;
        }
        this.rotation = newRotation;
        this.onGround = newOnGround;
        this.horizontalCollision = (flags & MovePlayerFlag.HORIZONTAL_COLLISION.getBit()) != 0;
    }

    public void confirmTeleport(int teleportId) {
        if (teleportId < 0) {
            if (this.pendingTeleportId == -teleportId) {
                this.pendingTeleportId = 0;
                this.waitingForPositionSync = false;
            }
        } else {
            this.serverSideTeleportConfirmed = true;
            if (!this.initiallySpawned) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received teleport confirm for teleport id " + teleportId + " but player is not spawned yet");
            }
            this.authInputData.add(PlayerAuthInputPacket_InputData.HandledTeleport);
        }
    }

    public Position3f prevPosition() {
        return this.prevPosition;
    }

    public boolean prevOnGround() {
        return this.prevOnGround;
    }

    public Set<PlayerAuthInputPacket_InputData> authInputData() {
        return this.authInputData;
    }

    public void addAuthInputData(PlayerAuthInputPacket_InputData data) {
        this.authInputData.add(data);
    }

    public void addAuthInputData(PlayerAuthInputPacket_InputData ... data) {
        this.authInputData.addAll(Arrays.asList(data));
    }

    public List<AuthInputBlockAction> authInputBlockActions() {
        return this.authInputBlockActions;
    }

    public void addAuthInputBlockAction(AuthInputBlockAction blockAction) {
        this.authInputData.add(PlayerAuthInputPacket_InputData.PerformBlockActions);
        this.authInputBlockActions.add(blockAction);
    }

    @Override
    public void setPosition(Position3f position) {
        super.setPosition(position);
        this.prevPosition = position;
    }

    @Override
    public void setOnGround(boolean onGround) {
        super.setOnGround(onGround);
        this.prevOnGround = onGround;
    }

    @Override
    public String name() {
        PlayerListStorage playerList = (PlayerListStorage)this.user.get(PlayerListStorage.class);
        Pair<Long, String> entry = playerList.getPlayer(this.javaUuid);
        if (entry != null) {
            return (String)entry.value();
        }
        return this.name;
    }

    @Override
    public void setAbilities(PlayerAbilities abilities) {
        PacketWrapper playerAbilities = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.PLAYER_ABILITIES, (UserConnection)this.user);
        this.setAbilities(abilities, playerAbilities);
        playerAbilities.send(BedrockProtocol.class);
    }

    public void setAbilities(PlayerAbilities abilities, PacketWrapper javaAbilities) {
        CommandsStorage commandsStorage;
        PlayerAbilities prevAbilities = this.abilities;
        super.setAbilities(abilities);
        if (abilities.commandPermission() != prevAbilities.commandPermission() && (commandsStorage = (CommandsStorage)this.user.get(CommandsStorage.class)) != null) {
            commandsStorage.updateCommandTree();
        }
        byte flags = 0;
        if (abilities.getBooleanValue(AbilitiesIndex.Invulnerable)) {
            flags = (byte)(flags | AbilitiesFlag.INVULNERABLE.getBit());
        }
        if (abilities.getBooleanValue(AbilitiesIndex.Flying)) {
            flags = (byte)(flags | AbilitiesFlag.FLYING.getBit());
        }
        if (abilities.getBooleanValue(AbilitiesIndex.MayFly)) {
            flags = (byte)(flags | AbilitiesFlag.CAN_FLY.getBit());
        }
        if (abilities.getBooleanValue(AbilitiesIndex.Instabuild)) {
            flags = (byte)(flags | AbilitiesFlag.INSTABUILD.getBit());
        }
        javaAbilities.write((Type)Types.BYTE, (Object)flags);
        javaAbilities.write((Type)Types.FLOAT, (Object)Float.valueOf(abilities.getFloatValue(AbilitiesIndex.FlySpeed)));
        javaAbilities.write((Type)Types.FLOAT, (Object)Float.valueOf(abilities.getFloatValue(AbilitiesIndex.WalkSpeed)));
    }

    public boolean isInitiallySpawned() {
        return this.initiallySpawned;
    }

    public void setInitiallySpawned() {
        this.initiallySpawned = true;
    }

    public DimensionChangeInfo dimensionChangeInfo() {
        return this.dimensionChangeInfo;
    }

    public void setDimensionChangeInfo(DimensionChangeInfo dimensionChangeInfo) {
        this.dimensionChangeInfo = dimensionChangeInfo;
    }

    public Set<InputFlag> inputFlags() {
        return this.inputFlags;
    }

    public void setInputFlags(Set<InputFlag> inputFlags) {
        this.inputFlags = inputFlags;
    }

    public Set<InputFlag> prevInputFlags() {
        return this.prevInputFlags;
    }

    public boolean horizontalCollision() {
        return this.horizontalCollision;
    }

    public void setHorizontalCollision(boolean horizontalCollision) {
        this.horizontalCollision = horizontalCollision;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    public boolean isSprinting() {
        return this.sprinting;
    }

    public void setSprinting(boolean sprinting) {
        this.sprinting = sprinting;
        EntityAttribute oldMovementAttribute = (EntityAttribute)this.attributes.get("minecraft:movement");
        ArrayList<EntityAttribute.Modifier> modifiers = new ArrayList<EntityAttribute.Modifier>(Arrays.asList(oldMovementAttribute.modifiers()));
        modifiers.removeIf(modifier -> modifier.id().equals("d208fc00-42aa-4aad-9276-d5446530de43") && modifier.name().equals("Sprinting speed boost") && modifier.operation() == AttributeModifierOperation.OPERATION_MULTIPLY_TOTAL);
        if (this.sprinting) {
            modifiers.add(new EntityAttribute.Modifier("d208fc00-42aa-4aad-9276-d5446530de43", "Sprinting speed boost", 0.3f, AttributeModifierOperation.OPERATION_MULTIPLY_TOTAL, AttributeOperands.OPERAND_CURRENT, false));
        }
        EntityAttribute newMovementAttribute = oldMovementAttribute.withModifiers(modifiers.toArray(new EntityAttribute.Modifier[0]));
        this.updateAttributes(new EntityAttribute[]{newMovementAttribute.withValue(newMovementAttribute.computeCurrentValue())});
    }

    public GameType gameType() {
        return this.gameType;
    }

    public void setGameType(GameType gameType) {
        this.gameType = gameType;
        this.updateJavaGameMode();
    }

    public GameMode javaGameMode() {
        return this.javaGameMode;
    }

    public void updateJavaGameMode() {
        this.javaGameMode = GameTypeRewriter.getEffectiveGameMode(this.gameType, this.gameSession.getLevelGameType());
        PlayerAbilities.AbilitiesLayer abilitiesLayer = this.abilities.getOrCreateCacheLayer();
        switch (this.javaGameMode) {
            case CREATIVE: {
                abilitiesLayer.setAbility(AbilitiesIndex.Invulnerable, true);
                abilitiesLayer.setAbility(AbilitiesIndex.MayFly, true);
                abilitiesLayer.setAbility(AbilitiesIndex.Instabuild, true);
                abilitiesLayer.setAbility(AbilitiesIndex.NoClip, false);
                break;
            }
            case SPECTATOR: {
                abilitiesLayer.setAbility(AbilitiesIndex.Invulnerable, true);
                abilitiesLayer.setAbility(AbilitiesIndex.Flying, true);
                abilitiesLayer.setAbility(AbilitiesIndex.MayFly, true);
                abilitiesLayer.setAbility(AbilitiesIndex.Instabuild, false);
                abilitiesLayer.setAbility(AbilitiesIndex.NoClip, true);
                break;
            }
            default: {
                abilitiesLayer.setAbility(AbilitiesIndex.Invulnerable, false);
                abilitiesLayer.setAbility(AbilitiesIndex.Flying, false);
                abilitiesLayer.setAbility(AbilitiesIndex.MayFly, false);
                abilitiesLayer.setAbility(AbilitiesIndex.Instabuild, false);
                abilitiesLayer.setAbility(AbilitiesIndex.NoClip, false);
            }
        }
    }

    public boolean checkCancelSwingPacket() {
        boolean cancel = this.cancelNextSwingPacket;
        this.cancelNextSwingPacket = false;
        return cancel;
    }

    public void cancelNextSwingPacket() {
        this.cancelNextSwingPacket = true;
    }

    public BlockBreakingInfo blockBreakingInfo() {
        return this.blockBreakingInfo;
    }

    public void setBlockBreakingInfo(BlockBreakingInfo blockBreakingInfo) {
        this.blockBreakingInfo = blockBreakingInfo;
    }

    @Override
    protected boolean translateAttribute(EntityAttribute attribute, PacketWrapper javaAttributes, AtomicInteger attributeCount, List<EntityData> javaEntityData) {
        return switch (attribute.name()) {
            case "minecraft:health", "minecraft:player.hunger", "minecraft:player.saturation" -> {
                EntityAttribute health = attribute.name().equals("minecraft:health") ? attribute : (EntityAttribute)this.attributes.get("minecraft:health");
                EntityAttribute hunger = attribute.name().equals("minecraft:player.hunger") ? attribute : (EntityAttribute)this.attributes.get("minecraft:player.hunger");
                EntityAttribute saturation = attribute.name().equals("minecraft:player.saturation") ? attribute : (EntityAttribute)this.attributes.get("minecraft:player.saturation");
                PacketWrapper setHealth = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.SET_HEALTH, (UserConnection)this.user);
                setHealth.write((Type)Types.FLOAT, (Object)Float.valueOf(health.computeClampedValue()));
                setHealth.write((Type)Types.VAR_INT, (Object)((int)hunger.computeClampedValue()));
                setHealth.write((Type)Types.FLOAT, (Object)Float.valueOf(saturation.computeClampedValue()));
                setHealth.send(BedrockProtocol.class);
                if (attribute.name().equals("minecraft:health")) {
                    yield super.translateAttribute(attribute, javaAttributes, attributeCount, javaEntityData);
                }
                yield true;
            }
            case "minecraft:player.experience", "minecraft:player.level" -> {
                EntityAttribute experience = attribute.name().equals("minecraft:player.experience") ? attribute : (EntityAttribute)this.attributes.get("minecraft:player.experience");
                EntityAttribute level = attribute.name().equals("minecraft:player.level") ? attribute : (EntityAttribute)this.attributes.get("minecraft:player.level");
                PacketWrapper setExperience = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.SET_EXPERIENCE, (UserConnection)this.user);
                setExperience.write((Type)Types.FLOAT, (Object)Float.valueOf(experience.computeClampedValue()));
                setExperience.write((Type)Types.VAR_INT, (Object)((int)level.computeClampedValue()));
                setExperience.write((Type)Types.VAR_INT, (Object)0);
                setExperience.send(BedrockProtocol.class);
                yield true;
            }
            case "minecraft:player.exhaustion" -> true;
            default -> super.translateAttribute(attribute, javaAttributes, attributeCount, javaEntityData);
        };
    }

    private boolean preMove(Position3f newPosition, Position3f newRotation, boolean newOnGround) {
        ChunkTracker chunkTracker = (ChunkTracker)this.user.get(ChunkTracker.class);
        if (this.serverSideTeleportConfirmed) {
            this.serverSideTeleportConfirmed = false;
            return true;
        }
        if (this.waitingForPositionSync) {
            return false;
        }
        if (!this.initiallySpawned || this.dimensionChangeInfo != null) {
            if (!this.position.equals(newPosition)) {
                this.sendPlayerPositionPacketToClient(Relative.NONE);
            }
            return false;
        }
        if (chunkTracker.isInUnloadedChunkSection(this.position)) {
            this.wasInsideUnloadedChunk = true;
            if (!this.position.equals(newPosition)) {
                this.waitingForPositionSync = true;
                this.sendPlayerPositionPacketToClient(Relative.ROTATION);
            }
            return false;
        }
        if (this.wasInsideUnloadedChunk) {
            this.wasInsideUnloadedChunk = false;
            this.waitingForPositionSync = true;
            this.sendPlayerPositionPacketToClient(Relative.ROTATION);
            return false;
        }
        if (newPosition != null && chunkTracker.isInUnloadedChunkSection(newPosition)) {
            this.waitingForPositionSync = true;
            this.sendPlayerPositionPacketToClient(Relative.ROTATION);
            return false;
        }
        if (newPosition != null && !this.position.equals(newPosition)) {
            return true;
        }
        if (newRotation != null && !this.rotation.equals(newRotation)) {
            return true;
        }
        return this.onGround != newOnGround;
    }

    public record DimensionChangeInfo(Long loadingScreenId) {
    }

    public record BlockBreakingInfo(BlockPosition position, Direction direction) {
    }

    public record AuthInputBlockAction(PlayerActionType action, BlockPosition position, int direction) {
        public AuthInputBlockAction(PlayerActionType action) {
            this(action, null, -1);
        }
    }
}

