/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.entity;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Vector3f;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataContainer;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataKey;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_21_6;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityData;
import com.viaversion.viaversion.api.minecraft.entitydata.types.EntityDataTypes1_21_5;
import com.viaversion.viaversion.api.minecraft.item.StructuredItem;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import com.viaversion.viaversion.util.Key;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.Entity;
import net.raphimc.viabedrock.api.model.resourcepack.EntityDefinitions;
import net.raphimc.viabedrock.api.modinterface.ViaBedrockUtilityInterface;
import net.raphimc.viabedrock.api.util.MathUtil;
import net.raphimc.viabedrock.api.util.MoLangEngine;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.data.ProtocolConstants;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ActorDataIDs;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ActorFlags;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.resourcepack.CustomEntityResourceRewriter;
import net.raphimc.viabedrock.protocol.storage.ChannelStorage;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import org.cube.converter.data.bedrock.BedrockEntityData;
import org.cube.converter.data.bedrock.controller.BedrockRenderController;
import team.unnamed.mocha.runtime.Scope;
import team.unnamed.mocha.runtime.binding.JavaObjectBinding;
import team.unnamed.mocha.runtime.standard.MochaMath;
import team.unnamed.mocha.runtime.value.MutableObjectBinding;
import team.unnamed.mocha.runtime.value.ObjectValue;
import team.unnamed.mocha.runtime.value.Value;

public class CustomEntity
extends Entity {
    private static final Scope BASE_SCOPE = Scope.create();
    private final EntityDefinitions.EntityDefinition entityDefinition;
    private final Map<String, String> inverseGeometryMap = new HashMap<String, String>();
    private final Map<String, String> inverseTextureMap = new HashMap<String, String>();
    private final Scope entityScope = BASE_SCOPE.copy();
    private final List<EvaluatedModel> models = new ArrayList<EvaluatedModel>();
    private final List<ItemDisplayEntity> partEntities = new ArrayList<ItemDisplayEntity>();
    private boolean spawned;

    public CustomEntity(UserConnection user, long uniqueId, long runtimeId, String type, int javaId, EntityDefinitions.EntityDefinition entityDefinition) {
        super(user, uniqueId, runtimeId, type, javaId, UUID.randomUUID(), EntityTypes1_21_6.INTERACTION);
        this.entityDefinition = entityDefinition;
        MutableObjectBinding variableBinding = new MutableObjectBinding();
        this.entityScope.set("variable", (Value)variableBinding);
        this.entityScope.set("v", (Value)variableBinding);
        try {
            for (Object initExpression : this.entityDefinition.entityData().getScripts().initialize()) {
                MoLangEngine.eval(this.entityScope, (String)initExpression);
            }
        }
        catch (Throwable e) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to initialize custom entity variables", e);
        }
        MutableObjectBinding geometryBinding = new MutableObjectBinding();
        for (Map.Entry entry : entityDefinition.entityData().getGeometries().entrySet()) {
            geometryBinding.set((String)entry.getKey(), Value.of((String)((String)entry.getValue())));
            this.inverseGeometryMap.putIfAbsent((String)entry.getValue(), (String)entry.getKey());
        }
        geometryBinding.block();
        this.entityScope.set("geometry", (Value)geometryBinding);
        MutableObjectBinding textureBinding = new MutableObjectBinding();
        for (Map.Entry entry : entityDefinition.entityData().getTextures().entrySet()) {
            textureBinding.set((String)entry.getKey(), Value.of((String)((String)entry.getValue())));
            this.inverseTextureMap.putIfAbsent((String)entry.getValue(), (String)entry.getKey());
        }
        textureBinding.block();
        this.entityScope.set("texture", (Value)textureBinding);
        MutableObjectBinding mutableObjectBinding = new MutableObjectBinding();
        mutableObjectBinding.block();
        this.entityScope.set("material", (Value)mutableObjectBinding);
        this.entityScope.readOnly(true);
    }

    @Override
    public void setPosition(Position3f position) {
        super.setPosition(position);
        if (!this.spawned) {
            this.evaluateRenderControllerChange();
            this.spawn();
        } else {
            this.partEntities.forEach(ItemDisplayEntity::updatePositionAndRotation);
        }
    }

    @Override
    public void setRotation(Position3f rotation) {
        super.setRotation(rotation);
        if (this.spawned) {
            this.partEntities.forEach(ItemDisplayEntity::updatePositionAndRotation);
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.despawn();
    }

    @Override
    protected void onEntityDataChanged() {
        super.onEntityDataChanged();
        if (this.evaluateRenderControllerChange()) {
            this.despawn();
            this.spawn();
        }
    }

    private void spawn() {
        this.spawned = true;
        if (this.models.isEmpty()) {
            return;
        }
        EntityTracker entityTracker = (EntityTracker)this.user.get(EntityTracker.class);
        ResourcePacksStorage resourcePacksStorage = (ResourcePacksStorage)this.user.get(ResourcePacksStorage.class);
        ChannelStorage channelStorage = (ChannelStorage)this.user.get(ChannelStorage.class);
        if (channelStorage.hasChannel("viabedrockutility:confirm")) {
            ViaBedrockUtilityInterface.spawnCustomEntity(this.user, this.javaUuid(), this.entityDefinition.identifier(), this.entityData());
            return;
        }
        for (EvaluatedModel model : this.models) {
            String key = this.entityDefinition.identifier() + "_" + model.key();
            if (!resourcePacksStorage.getConverterData().containsKey("ce_" + key + "_scale")) continue;
            ItemDisplayEntity partEntity = new ItemDisplayEntity(entityTracker.getNextJavaEntityId());
            this.partEntities.add(partEntity);
            ArrayList<EntityData> javaEntityData = new ArrayList<EntityData>();
            StructuredDataContainer data = ProtocolConstants.createStructuredDataContainer();
            data.set(StructuredDataKey.ITEM_MODEL, (Object)Key.of((String)"viabedrock:entity"));
            data.set(StructuredDataKey.CUSTOM_MODEL_DATA1_21_4, (Object)CustomEntityResourceRewriter.getCustomModelData(key));
            StructuredItem item = new StructuredItem(((Integer)BedrockProtocol.MAPPINGS.getJavaItems().get((Object)"minecraft:paper")).intValue(), 1, data);
            javaEntityData.add(new EntityData(partEntity.getJavaEntityDataIndex("ITEM_STACK"), ((EntityDataTypes1_21_5)VersionedTypes.V1_21_6.entityDataTypes).itemType, (Object)item));
            float scale = ((Float)resourcePacksStorage.getConverterData().get("ce_" + key + "_scale")).floatValue();
            javaEntityData.add(new EntityData(partEntity.getJavaEntityDataIndex("SCALE"), ((EntityDataTypes1_21_5)VersionedTypes.V1_21_6.entityDataTypes).vector3FType, (Object)new Vector3f(scale, scale, scale)));
            javaEntityData.add(new EntityData(partEntity.getJavaEntityDataIndex("TRANSLATION"), ((EntityDataTypes1_21_5)VersionedTypes.V1_21_6.entityDataTypes).vector3FType, (Object)new Vector3f(0.0f, scale * 0.5f, 0.0f)));
            PacketWrapper addEntity = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.ADD_ENTITY, (UserConnection)this.user);
            addEntity.write((Type)Types.VAR_INT, (Object)partEntity.javaId());
            addEntity.write(Types.UUID, (Object)partEntity.javaUuid());
            addEntity.write((Type)Types.VAR_INT, (Object)partEntity.javaType().getId());
            addEntity.write((Type)Types.DOUBLE, (Object)this.position.x());
            addEntity.write((Type)Types.DOUBLE, (Object)this.position.y());
            addEntity.write((Type)Types.DOUBLE, (Object)this.position.z());
            addEntity.write((Type)Types.BYTE, (Object)MathUtil.float2Byte(this.rotation.x()));
            addEntity.write((Type)Types.BYTE, (Object)MathUtil.float2Byte(this.rotation.y()));
            addEntity.write((Type)Types.BYTE, (Object)MathUtil.float2Byte(this.rotation.z()));
            addEntity.write((Type)Types.VAR_INT, (Object)0);
            addEntity.write((Type)Types.SHORT, (Object)0);
            addEntity.write((Type)Types.SHORT, (Object)0);
            addEntity.write((Type)Types.SHORT, (Object)0);
            addEntity.send(BedrockProtocol.class);
            PacketWrapper setEntityData = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.SET_ENTITY_DATA, (UserConnection)this.user);
            setEntityData.write((Type)Types.VAR_INT, (Object)partEntity.javaId());
            setEntityData.write(VersionedTypes.V1_21_6.entityDataList, javaEntityData);
            setEntityData.send(BedrockProtocol.class);
        }
    }

    private void despawn() {
        this.spawned = false;
        int[] entityIds = new int[this.partEntities.size()];
        for (int i = 0; i < this.partEntities.size(); ++i) {
            entityIds[i] = this.partEntities.get(i).javaId();
        }
        this.partEntities.clear();
        PacketWrapper removeEntities = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.REMOVE_ENTITIES, (UserConnection)this.user);
        removeEntities.write(Types.VAR_INT_ARRAY_PRIMITIVE, (Object)entityIds);
        removeEntities.send(BedrockProtocol.class);
    }

    private boolean evaluateRenderControllerChange() {
        Scope executionScope = this.entityScope.copy();
        MutableObjectBinding queryBinding = new MutableObjectBinding();
        if (this.entityData.containsKey((Object)ActorDataIDs.VARIANT)) {
            queryBinding.set("variant", Value.of((Object)((EntityData)this.entityData.get((Object)ActorDataIDs.VARIANT)).value()));
        }
        if (this.entityData.containsKey((Object)ActorDataIDs.MARK_VARIANT)) {
            queryBinding.set("mark_variant", Value.of((Object)((EntityData)this.entityData.get((Object)ActorDataIDs.MARK_VARIANT)).value()));
        }
        Set<ActorFlags> entityFlags = this.entityFlags();
        for (Map.Entry<ActorFlags, String> entry : BedrockProtocol.MAPPINGS.getBedrockEntityFlagMoLangQueries().entrySet()) {
            if (!entityFlags.contains((Object)entry.getKey())) continue;
            queryBinding.set(entry.getValue(), Value.of((boolean)true));
        }
        if (entityFlags.contains((Object)ActorFlags.ONFIRE)) {
            queryBinding.set("is_onfire", Value.of((boolean)true));
        }
        queryBinding.block();
        executionScope.set("query", (Value)queryBinding);
        executionScope.set("q", (Value)queryBinding);
        ArrayList<EvaluatedModel> newModels = new ArrayList<EvaluatedModel>();
        ResourcePacksStorage resourcePacksStorage = (ResourcePacksStorage)this.user.get(ResourcePacksStorage.class);
        for (BedrockEntityData.RenderController entityRenderController : this.entityDefinition.entityData().getControllers()) {
            BedrockRenderController renderController;
            block13: {
                renderController = resourcePacksStorage.getRenderControllers().get(entityRenderController.identifier());
                if (renderController == null) continue;
                if (!entityRenderController.condition().isBlank()) {
                    try {
                        Value conditionResult = MoLangEngine.eval(executionScope, entityRenderController.condition());
                        if (!conditionResult.getAsBoolean()) {
                        }
                        break block13;
                    }
                    catch (Throwable e) {
                        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to evaluate render controller condition", e);
                    }
                    continue;
                }
            }
            try {
                Scope renderControllerGeometryScope = executionScope.copy();
                renderControllerGeometryScope.set("array", (Value)this.getArrayBinding(executionScope, renderController.geometries()));
                Scope renderControllerTextureScope = executionScope.copy();
                renderControllerTextureScope.set("array", (Value)this.getArrayBinding(executionScope, renderController.textures()));
                String geometryValue = MoLangEngine.eval(renderControllerGeometryScope, renderController.geometryExpression()).getAsString();
                String geometryName = this.inverseGeometryMap.get(geometryValue);
                for (String textureExpression : renderController.textureExpressions()) {
                    String textureValue = MoLangEngine.eval(renderControllerTextureScope, textureExpression).getAsString();
                    String textureName = this.inverseTextureMap.get(textureValue);
                    if (geometryName == null || textureName == null) continue;
                    newModels.add(new EvaluatedModel(geometryName + "_" + textureName, geometryValue, textureValue));
                }
            }
            catch (Throwable e) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to evaluate render controller", e);
                this.models.clear();
                return true;
            }
        }
        if (!newModels.isEmpty() && !this.models.equals(newModels)) {
            this.models.clear();
            this.models.addAll(newModels);
            return true;
        }
        return false;
    }

    private MutableObjectBinding getArrayBinding(Scope executionScope, List<BedrockRenderController.Array> arrays) throws IOException {
        MutableObjectBinding arrayBinding = new MutableObjectBinding();
        for (BedrockRenderController.Array array : arrays) {
            if (!array.name().toLowerCase(Locale.ROOT).startsWith("array.")) continue;
            String[] resolvedExpressions = new String[array.values().size()];
            for (int i = 0; i < array.values().size(); ++i) {
                resolvedExpressions[i] = MoLangEngine.eval(executionScope, (String)array.values().get(i)).getAsString();
            }
            arrayBinding.set(array.name().substring(6), Value.of((Object)resolvedExpressions));
        }
        arrayBinding.block();
        return arrayBinding;
    }

    static {
        BASE_SCOPE.set("math", (Value)JavaObjectBinding.of(MochaMath.class, null, (ObjectValue)new MochaMath()));
        BASE_SCOPE.readOnly(true);
    }

    public record EvaluatedModel(String key, String geometryValue, String textureValue) {
    }

    private class ItemDisplayEntity
    extends Entity {
        public ItemDisplayEntity(int javaId) {
            super(CustomEntity.this.user, 0L, 0L, null, javaId, UUID.randomUUID(), EntityTypes1_21_6.ITEM_DISPLAY);
        }

        public void updatePositionAndRotation() {
            PacketWrapper entityPositionSync = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.ENTITY_POSITION_SYNC, (UserConnection)this.user);
            entityPositionSync.write((Type)Types.VAR_INT, (Object)this.javaId());
            entityPositionSync.write((Type)Types.DOUBLE, (Object)CustomEntity.this.position.x());
            entityPositionSync.write((Type)Types.DOUBLE, (Object)CustomEntity.this.position.y());
            entityPositionSync.write((Type)Types.DOUBLE, (Object)CustomEntity.this.position.z());
            entityPositionSync.write((Type)Types.DOUBLE, (Object)0.0);
            entityPositionSync.write((Type)Types.DOUBLE, (Object)0.0);
            entityPositionSync.write((Type)Types.DOUBLE, (Object)0.0);
            entityPositionSync.write((Type)Types.FLOAT, (Object)Float.valueOf(CustomEntity.this.rotation.y()));
            entityPositionSync.write((Type)Types.FLOAT, (Object)Float.valueOf(CustomEntity.this.rotation.x()));
            entityPositionSync.write((Type)Types.BOOLEAN, (Object)CustomEntity.this.onGround);
            entityPositionSync.send(BedrockProtocol.class);
        }
    }
}

