/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.resourcepack;

import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.util.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class ParticleDefinitions {
    private final Map<String, ParticleDefinition> particles = new HashMap<String, ParticleDefinition>();

    public ParticleDefinitions(ResourcePacksStorage resourcePacksStorage) {
        for (ResourcePack pack : resourcePacksStorage.getPackStackBottomToTop()) {
            for (String particlePath : pack.content().getFilesDeep("particles/", ".json")) {
                try {
                    JsonObject particleEffect = pack.content().getJson(particlePath).getAsJsonObject("particle_effect");
                    String identifier = Key.namespaced((String)particleEffect.getAsJsonObject("description").get("identifier").getAsString());
                    ParticleDefinition particleDefinition = new ParticleDefinition(identifier);
                    if (particleEffect.has("components")) {
                        JsonObject jsonObject = particleEffect.getAsJsonObject("components");
                    }
                    this.particles.put(identifier, particleDefinition);
                }
                catch (Throwable e) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to parse particle definition " + particlePath + " in pack " + pack.packId(), e);
                }
            }
        }
    }

    public ParticleDefinition get(String identifier) {
        return this.particles.get(identifier);
    }

    public Map<String, ParticleDefinition> particles() {
        return Collections.unmodifiableMap(this.particles);
    }

    public static class ParticleDefinition {
        private final String identifier;

        public ParticleDefinition(String identifier) {
            this.identifier = identifier;
        }

        public String identifier() {
            return this.identifier;
        }
    }
}

