/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.resourcepack;

import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.util.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.api.util.JsonUtil;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class SoundDefinitions {
    private final Map<String, SoundDefinition> soundDefinitions = new HashMap<String, SoundDefinition>();
    private final Map<String, EventSound> eventSounds = new HashMap<String, EventSound>();
    private final Map<String, EventSounds> entitySounds = new HashMap<String, EventSounds>();
    private final Map<String, EventSounds> blockSounds = new HashMap<String, EventSounds>();

    public SoundDefinitions(ResourcePacksStorage resourcePacksStorage) {
        for (ResourcePack pack : resourcePacksStorage.getPackStackBottomToTop()) {
            if (pack.content().contains("sounds/sound_definitions.json")) {
                try {
                    JsonObject soundDefinitions = pack.content().getJson("sounds/sound_definitions.json");
                    soundDefinitions = soundDefinitions.has("sound_definitions") ? soundDefinitions.getAsJsonObject("sound_definitions") : soundDefinitions;
                    for (Object entry : soundDefinitions.entrySet()) {
                        JsonObject entryData = ((JsonElement)entry.getValue()).getAsJsonObject();
                        String category = entryData.has("category") ? entryData.get("category").getAsString() : null;
                        SoundDefinition soundDefinition = new SoundDefinition((String)entry.getKey(), category);
                        this.soundDefinitions.put((String)entry.getKey(), soundDefinition);
                    }
                }
                catch (Throwable e) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to parse sound_definitions.json in pack " + pack.packId(), e);
                }
            }
            if (!pack.content().contains("sounds.json")) continue;
            try {
                JsonObject sounds = pack.content().getJson("sounds.json");
                if (sounds.has("individual_event_sounds")) {
                    Object entry;
                    JsonObject events = sounds.getAsJsonObject("individual_event_sounds").getAsJsonObject("events");
                    entry = events.entrySet().iterator();
                    while (entry.hasNext()) {
                        Map.Entry entry2 = (Map.Entry)entry.next();
                        ConfiguredSound configuredSound = ConfiguredSound.fromJson(((JsonElement)entry2.getValue()).getAsJsonObject());
                        if (configuredSound == null) continue;
                        this.eventSounds.put((String)entry2.getKey(), new EventSound((String)entry2.getKey(), configuredSound));
                    }
                }
                if (sounds.has("entity_sounds")) {
                    JsonObject entitySounds = sounds.getAsJsonObject("entity_sounds");
                    JsonObject entities = entitySounds.getAsJsonObject("entities");
                    this.mergeDefaults(entitySounds, entities);
                    this.parseEvents(entities, true, this.entitySounds);
                }
                if (sounds.has("block_sounds")) {
                    JsonObject blockSounds = sounds.getAsJsonObject("block_sounds");
                    this.parseEvents(blockSounds, false, this.blockSounds);
                }
                if (!sounds.has("interactive_sounds")) continue;
                JsonObject interactiveSounds = sounds.getAsJsonObject("interactive_sounds");
                if (interactiveSounds.has("entity_sounds")) {
                    JsonObject entitySounds = interactiveSounds.getAsJsonObject("entity_sounds");
                    JsonObject entities = entitySounds.getAsJsonObject("entities");
                    this.mergeDefaults(entitySounds, entities);
                    for (Map.Entry entityEntry : entities.entrySet()) {
                        JsonObject events = ((JsonElement)entityEntry.getValue()).getAsJsonObject().getAsJsonObject("events");
                        for (Map.Entry eventEntry : events.entrySet()) {
                            if (!((JsonElement)eventEntry.getValue()).isJsonObject() || !((JsonElement)eventEntry.getValue()).getAsJsonObject().has("default")) continue;
                            events.add((String)eventEntry.getKey(), ((JsonElement)eventEntry.getValue()).getAsJsonObject().get("default"));
                        }
                    }
                    this.parseEvents(entities, true, this.entitySounds);
                }
                if (!interactiveSounds.has("block_sounds")) continue;
                this.parseEvents(interactiveSounds.getAsJsonObject("block_sounds"), false, this.blockSounds);
            }
            catch (Throwable e) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to parse sounds.json in pack " + pack.packId(), e);
            }
        }
    }

    private void parseEvents(JsonObject sounds, boolean namespace, Map<String, EventSounds> soundMap) {
        for (Map.Entry entry : sounds.entrySet()) {
            String key;
            JsonObject entity = ((JsonElement)entry.getValue()).getAsJsonObject();
            JsonElement volume = entity.has("volume") ? entity.get("volume") : null;
            JsonElement pitch = entity.has("pitch") ? entity.get("pitch") : null;
            HashMap<String, ConfiguredSound> eventSounds = new HashMap<String, ConfiguredSound>();
            for (Map.Entry eventEntry : entity.getAsJsonObject("events").entrySet()) {
                ConfiguredSound configuredSound;
                JsonObject eventSound;
                if (((JsonElement)eventEntry.getValue()).isJsonPrimitive()) {
                    eventSound = new JsonObject();
                    eventSound.addProperty("sound", ((JsonElement)eventEntry.getValue()).getAsString());
                    if (volume != null) {
                        eventSound.add("volume", volume);
                    }
                    if (pitch != null) {
                        eventSound.add("pitch", pitch);
                    }
                    if ((configuredSound = ConfiguredSound.fromJson(eventSound)) == null) continue;
                    eventSounds.put((String)eventEntry.getKey(), configuredSound);
                    continue;
                }
                eventSound = ((JsonElement)eventEntry.getValue()).getAsJsonObject();
                if (!eventSound.has("volume") && volume != null) {
                    eventSound.add("volume", volume);
                }
                if (!eventSound.has("pitch") && pitch != null) {
                    eventSound.add("pitch", pitch);
                }
                if ((configuredSound = ConfiguredSound.fromJson(eventSound)) == null) continue;
                eventSounds.put((String)eventEntry.getKey(), configuredSound);
            }
            String string = key = namespace ? Key.namespaced((String)((String)entry.getKey())) : (String)entry.getKey();
            if (soundMap.containsKey(key)) {
                soundMap.get(key).eventSounds().putAll(eventSounds);
                continue;
            }
            soundMap.put(key, new EventSounds(key, eventSounds));
        }
    }

    private void mergeDefaults(JsonObject sounds, JsonObject target) {
        if (sounds.has("defaults")) {
            JsonObject defaults = sounds.getAsJsonObject("defaults");
            for (JsonElement value : target.asMap().values()) {
                JsonUtil.merge(value.getAsJsonObject(), defaults);
            }
        }
    }

    public Map<String, SoundDefinition> soundDefinitions() {
        return Collections.unmodifiableMap(this.soundDefinitions);
    }

    public Map<String, EventSound> eventSounds() {
        return Collections.unmodifiableMap(this.eventSounds);
    }

    public Map<String, EventSounds> entitySounds() {
        return Collections.unmodifiableMap(this.entitySounds);
    }

    public Map<String, EventSounds> blockSounds() {
        return Collections.unmodifiableMap(this.blockSounds);
    }

    public record SoundDefinition(String name, String category) {
    }

    public record ConfiguredSound(String sound, float minVolume, float maxVolume, float minPitch, float maxPitch) {
        public static ConfiguredSound fromJson(JsonObject obj) {
            float maxPitch;
            float minPitch;
            float maxVolume;
            float minVolume;
            if (!obj.has("sound")) {
                return null;
            }
            String sound = obj.get("sound").getAsString();
            if (sound.isEmpty()) {
                return null;
            }
            if (obj.has("volume")) {
                if (obj.get("volume").isJsonArray()) {
                    minVolume = obj.get("volume").getAsJsonArray().get(0).getAsFloat();
                    maxVolume = obj.get("volume").getAsJsonArray().get(1).getAsFloat();
                } else {
                    minVolume = obj.get("volume").getAsFloat();
                    maxVolume = obj.get("volume").getAsFloat();
                }
            } else {
                minVolume = 1.0f;
                maxVolume = 1.0f;
            }
            if (obj.has("pitch")) {
                if (obj.get("pitch").isJsonArray()) {
                    minPitch = obj.get("pitch").getAsJsonArray().get(0).getAsFloat();
                    maxPitch = obj.get("pitch").getAsJsonArray().get(1).getAsFloat();
                } else {
                    minPitch = obj.get("pitch").getAsFloat();
                    maxPitch = obj.get("pitch").getAsFloat();
                }
            } else {
                minPitch = 1.0f;
                maxPitch = 1.0f;
            }
            return new ConfiguredSound(sound, minVolume, maxVolume, minPitch, maxPitch);
        }

        public JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("sound", this.sound);
            if (this.minVolume != 1.0f || this.maxVolume != 1.0f) {
                if (this.minVolume == this.maxVolume) {
                    obj.addProperty("volume", (Number)Float.valueOf(this.minVolume));
                } else {
                    JsonArray volumeArray = new JsonArray();
                    volumeArray.add((Number)Float.valueOf(this.minVolume));
                    volumeArray.add((Number)Float.valueOf(this.maxVolume));
                    obj.add("volume", (JsonElement)volumeArray);
                }
            }
            if (this.minPitch != 1.0f || this.maxPitch != 1.0f) {
                if (this.minPitch == this.maxPitch) {
                    obj.addProperty("pitch", (Number)Float.valueOf(this.minPitch));
                } else {
                    JsonArray pitchArray = new JsonArray();
                    pitchArray.add((Number)Float.valueOf(this.minPitch));
                    pitchArray.add((Number)Float.valueOf(this.maxPitch));
                    obj.add("pitch", (JsonElement)pitchArray);
                }
            }
            return obj;
        }
    }

    public record EventSound(String event, ConfiguredSound sound) {
    }

    public record EventSounds(String identifier, Map<String, ConfiguredSound> eventSounds) {
    }
}

