/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.scoreboard;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.util.Pair;
import java.util.Objects;
import java.util.UUID;
import net.raphimc.viabedrock.api.util.StringUtil;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.IdentityDefinition_Type;
import net.raphimc.viabedrock.protocol.storage.PlayerListStorage;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class ScoreboardEntry {
    private IdentityDefinition_Type type;
    private Long uniqueEntityId;
    private String fakePlayerName;
    private int score;
    private String javaName;

    public ScoreboardEntry(int score, IdentityDefinition_Type type, Long uniqueEntityId, String fakePlayerName) {
        this.updateTarget(type, uniqueEntityId, fakePlayerName);
        this.score = score;
    }

    public boolean isSameTarget(ScoreboardEntry entry) {
        return this.type == entry.type && Objects.equals(this.uniqueEntityId, entry.uniqueEntityId) && Objects.equals(this.fakePlayerName, entry.fakePlayerName);
    }

    public void updateTarget(IdentityDefinition_Type type, Long uniqueEntityId, String fakePlayerName) {
        this.type = type;
        this.uniqueEntityId = uniqueEntityId;
        this.fakePlayerName = fakePlayerName;
    }

    public boolean isValid() {
        return this.uniqueEntityId != null || this.fakePlayerName != null;
    }

    public IdentityDefinition_Type type() {
        return this.type;
    }

    public Long uniqueEntityId() {
        return this.uniqueEntityId;
    }

    public String fakePlayerName() {
        return this.fakePlayerName;
    }

    public int score() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public String javaName() {
        return this.javaName;
    }

    public void updateJavaName(UserConnection user) {
        switch (this.type) {
            case Player: {
                PlayerListStorage playerList = (PlayerListStorage)user.get(PlayerListStorage.class);
                Pair<UUID, String> player = playerList.getPlayer(this.uniqueEntityId);
                if (player != null) {
                    this.javaName = (String)player.value();
                    break;
                }
                this.javaName = StringUtil.encodeLong(this.uniqueEntityId) + ((ResourcePacksStorage)user.get(ResourcePacksStorage.class)).getTexts().get("commands.scoreboard.players.offlinePlayerName");
                break;
            }
            case Entity: {
                this.javaName = String.valueOf(this.uniqueEntityId);
                break;
            }
            case FakePlayer: {
                this.javaName = this.fakePlayerName;
            }
        }
    }
}

