/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.modinterface;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.model.SkinData;
import net.raphimc.viabedrock.protocol.types.primitive.ImageType;

public class BedrockSkinUtilityInterface {
    public static final String CHANNEL = "bedrockskin:data";
    private static final int VERSION = 1;
    private static final int MESSAGE_CAPE = 0;
    private static final int MESSAGE_SKIN_INFORMATION = 1;
    private static final int MESSAGE_SKIN_DATA = 2;
    private static final int MAX_PAYLOAD_SIZE = 0x100000;

    public static void sendSkin(UserConnection user, UUID uuid, SkinData skin) {
        PacketWrapper pluginMessage;
        if (skin.skinData() == null || skin.persona()) {
            return;
        }
        boolean hasGeometry = !skin.geometryData().isEmpty() && !skin.geometryData().toLowerCase(Locale.ROOT).equals("null");
        byte[] skinData = ImageType.getImageData(skin.skinData());
        int maxPayloadSize = 1048552;
        int chunkCount = (int)Math.ceil((double)skinData.length / 1048552.0);
        PacketWrapper pluginMessage2 = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.CUSTOM_PAYLOAD, (UserConnection)user);
        pluginMessage2.write(Types.STRING, (Object)CHANNEL);
        pluginMessage2.write((Type)Types.INT, (Object)1);
        pluginMessage2.write((Type)Types.INT, (Object)1);
        pluginMessage2.write(Types.UUID, (Object)uuid);
        pluginMessage2.write((Type)Types.INT, (Object)skin.skinData().getWidth());
        pluginMessage2.write((Type)Types.INT, (Object)skin.skinData().getHeight());
        pluginMessage2.write((Type)Types.BOOLEAN, (Object)hasGeometry);
        if (hasGeometry) {
            BedrockSkinUtilityInterface.writeString(pluginMessage2, skin.geometryData());
            BedrockSkinUtilityInterface.writeString(pluginMessage2, skin.skinResourcePatch());
        }
        pluginMessage2.write((Type)Types.INT, (Object)chunkCount);
        pluginMessage2.send(BedrockProtocol.class);
        for (int i = 0; i < chunkCount; ++i) {
            pluginMessage = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.CUSTOM_PAYLOAD, (UserConnection)user);
            pluginMessage.write(Types.STRING, (Object)CHANNEL);
            pluginMessage.write((Type)Types.INT, (Object)2);
            pluginMessage.write(Types.UUID, (Object)uuid);
            pluginMessage.write((Type)Types.INT, (Object)i);
            if (chunkCount == 1) {
                pluginMessage.write(Types.REMAINING_BYTES, (Object)skinData);
            } else {
                pluginMessage.write(Types.REMAINING_BYTES, (Object)Arrays.copyOfRange(skinData, i * 1048552, Math.min((i + 1) * 1048552, skinData.length)));
            }
            pluginMessage.send(BedrockProtocol.class);
        }
        if (skin.capeData() != null) {
            byte[] capeData = ImageType.getImageData(skin.capeData());
            pluginMessage = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.CUSTOM_PAYLOAD, (UserConnection)user);
            pluginMessage.write(Types.STRING, (Object)CHANNEL);
            pluginMessage.write((Type)Types.INT, (Object)0);
            pluginMessage.write((Type)Types.INT, (Object)1);
            pluginMessage.write(Types.UUID, (Object)uuid);
            pluginMessage.write((Type)Types.INT, (Object)skin.capeData().getWidth());
            pluginMessage.write((Type)Types.INT, (Object)skin.capeData().getHeight());
            BedrockSkinUtilityInterface.writeString(pluginMessage, skin.capeId());
            pluginMessage.write((Type)Types.INT, (Object)capeData.length);
            pluginMessage.write(Types.REMAINING_BYTES, (Object)capeData);
            pluginMessage.send(BedrockProtocol.class);
        }
    }

    private static void writeString(PacketWrapper wrapper, String s) {
        wrapper.write((Type)Types.INT, (Object)s.length());
        wrapper.write(Types.REMAINING_BYTES, (Object)s.getBytes(StandardCharsets.UTF_8));
    }
}

