/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class BatchLengthCodec
extends ByteToMessageCodec<ByteBuf> {
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) {
        BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(out, in.readableBytes());
        out.writeBytes(in);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        while (in.isReadable()) {
            int length = BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(in);
            out.add(in.readRetainedSlice(length));
        }
    }
}

