/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.data.enums.bedrock;

import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;

public enum ActorType {
    Undefined(1),
    TypeMask(255),
    Mob(256),
    PathfinderMob(0x200 | Mob.getValue()),
    Monster(0x800 | PathfinderMob.getValue()),
    Animal(0x1000 | PathfinderMob.getValue()),
    TamableAnimal(0x4000 | Animal.getValue()),
    Ambient(0x8000 | Mob.getValue()),
    UndeadMob(0x10000 | Monster.getValue()),
    ZombieMonster(0x20000 | UndeadMob.getValue()),
    Arthropod(0x40000 | Monster.getValue()),
    Minecart(524288),
    SkeletonMonster(0x100000 | UndeadMob.getValue()),
    EquineAnimal(0x200000 | TamableAnimal.getValue()),
    Projectile(0x400000),
    AbstractArrow(0x800000),
    WaterAnimal(0x2000 | PathfinderMob.getValue()),
    VillagerBase(0x1000000 | PathfinderMob.getValue()),
    Chicken(0xA | Animal.getValue()),
    Cow(0xB | Animal.getValue()),
    Pig(0xC | Animal.getValue()),
    Sheep(0xD | Animal.getValue()),
    Wolf(0xE | TamableAnimal.getValue()),
    Villager(0xF | VillagerBase.getValue()),
    MushroomCow(0x10 | Animal.getValue()),
    Squid(0x11 | WaterAnimal.getValue()),
    Rabbit(0x12 | Animal.getValue()),
    Bat(0x13 | Ambient.getValue()),
    IronGolem(0x14 | PathfinderMob.getValue()),
    SnowGolem(0x15 | PathfinderMob.getValue()),
    Ocelot(0x16 | TamableAnimal.getValue()),
    Horse(0x17 | EquineAnimal.getValue()),
    PolarBear(0x1C | Animal.getValue()),
    Llama(0x1D | Animal.getValue()),
    Parrot(0x1E | TamableAnimal.getValue()),
    Dolphin(0x1F | WaterAnimal.getValue()),
    Donkey(0x18 | EquineAnimal.getValue()),
    Mule(0x19 | EquineAnimal.getValue()),
    SkeletonHorse(0x1A | EquineAnimal.getValue() | UndeadMob.getValue()),
    ZombieHorse(0x1B | EquineAnimal.getValue() | UndeadMob.getValue()),
    Zombie(0x20 | ZombieMonster.getValue()),
    Creeper(0x21 | Monster.getValue()),
    Skeleton(0x22 | SkeletonMonster.getValue()),
    Spider(0x23 | Arthropod.getValue()),
    PigZombie(0x24 | UndeadMob.getValue()),
    Slime(0x25 | Monster.getValue()),
    EnderMan(0x26 | Monster.getValue()),
    Silverfish(0x27 | Arthropod.getValue()),
    CaveSpider(0x28 | Arthropod.getValue()),
    Ghast(0x29 | Monster.getValue()),
    LavaSlime(0x2A | Monster.getValue()),
    Blaze(0x2B | Monster.getValue()),
    ZombieVillager(0x2C | ZombieMonster.getValue()),
    Witch(0x2D | Monster.getValue()),
    Stray(0x2E | SkeletonMonster.getValue()),
    Husk(0x2F | ZombieMonster.getValue()),
    WitherSkeleton(0x30 | SkeletonMonster.getValue()),
    Guardian(0x31 | Monster.getValue()),
    ElderGuardian(0x32 | Monster.getValue()),
    Npc(0x33 | Mob.getValue()),
    WitherBoss(0x34 | UndeadMob.getValue()),
    Dragon(0x35 | Monster.getValue()),
    Shulker(0x36 | Monster.getValue()),
    Endermite(0x37 | Arthropod.getValue()),
    Agent(0x38 | Mob.getValue()),
    Vindicator(0x39 | Monster.getValue()),
    Phantom(0x3A | UndeadMob.getValue()),
    IllagerBeast(0x3B | Monster.getValue()),
    ArmorStand(0x3D | Mob.getValue()),
    TripodCamera(0x3E | Mob.getValue()),
    Player(0x3F | Mob.getValue()),
    ItemEntity(64),
    PrimedTnt(65),
    FallingBlock(66),
    MovingBlock(67),
    ExperiencePotion(0x44 | Projectile.getValue()),
    Experience(69),
    EyeOfEnder(70),
    EnderCrystal(71),
    FireworksRocket(72),
    Trident(0x49 | Projectile.getValue() | AbstractArrow.getValue()),
    Turtle(0x4A | Animal.getValue()),
    Cat(0x4B | TamableAnimal.getValue()),
    ShulkerBullet(0x4C | Projectile.getValue()),
    FishingHook(77),
    Chalkboard(78),
    DragonFireball(0x4F | Projectile.getValue()),
    Arrow(0x50 | Projectile.getValue() | AbstractArrow.getValue()),
    Snowball(0x51 | Projectile.getValue()),
    ThrownEgg(0x52 | Projectile.getValue()),
    Painting(83),
    LargeFireball(0x55 | Projectile.getValue()),
    ThrownPotion(0x56 | Projectile.getValue()),
    Enderpearl(0x57 | Projectile.getValue()),
    LeashKnot(88),
    WitherSkull(0x59 | Projectile.getValue()),
    BoatRideable(90),
    WitherSkullDangerous(0x5B | Projectile.getValue()),
    LightningBolt(93),
    SmallFireball(0x5E | Projectile.getValue()),
    AreaEffectCloud(95),
    LingeringPotion(0x65 | Projectile.getValue()),
    LlamaSpit(0x66 | Projectile.getValue()),
    EvocationFang(0x67 | Projectile.getValue()),
    EvocationIllager(0x68 | Monster.getValue()),
    Vex(0x69 | Monster.getValue()),
    MinecartRideable(0x54 | Minecart.getValue()),
    MinecartHopper(0x60 | Minecart.getValue()),
    MinecartTNT(0x61 | Minecart.getValue()),
    MinecartChest(0x62 | Minecart.getValue()),
    MinecartFurnace(0x63 | Minecart.getValue()),
    MinecartCommandBlock(0x64 | Minecart.getValue()),
    IceBomb(0x6A | Projectile.getValue()),
    Balloon(107),
    Pufferfish(0x6C | WaterAnimal.getValue()),
    Salmon(0x6D | WaterAnimal.getValue()),
    Drowned(0x6E | ZombieMonster.getValue()),
    Tropicalfish(0x6F | WaterAnimal.getValue()),
    Fish(0x70 | WaterAnimal.getValue()),
    Panda(0x71 | Animal.getValue()),
    Pillager(0x72 | Monster.getValue()),
    VillagerV2(0x73 | VillagerBase.getValue()),
    ZombieVillagerV2(0x74 | ZombieMonster.getValue()),
    Shield(117),
    WanderingTrader(0x76 | PathfinderMob.getValue()),
    Lectern(119),
    ElderGuardianGhost(0x78 | Monster.getValue()),
    Fox(0x79 | Animal.getValue()),
    Bee(0x7A | Mob.getValue()),
    Piglin(0x7B | Mob.getValue()),
    Hoglin(0x7C | Animal.getValue()),
    Strider(0x7D | Animal.getValue()),
    Zoglin(0x7E | UndeadMob.getValue()),
    PiglinBrute(0x7F | Mob.getValue()),
    Goat(0x80 | Animal.getValue()),
    GlowSquid(0x81 | WaterAnimal.getValue()),
    Axolotl(0x82 | Animal.getValue()),
    Warden(0x83 | Monster.getValue()),
    Frog(0x84 | Animal.getValue()),
    Tadpole(0x85 | WaterAnimal.getValue()),
    Allay(0x86 | Mob.getValue()),
    ChestBoatRideable(0x88 | BoatRideable.getValue()),
    TraderLlama(0x89 | Llama.getValue()),
    Camel(0x8A | Animal.getValue()),
    Sniffer(0x8B | Animal.getValue()),
    Breeze(0x8C | Monster.getValue()),
    BreezeWindChargeProjectile(0x8D | Projectile.getValue()),
    Armadillo(0x8E | Animal.getValue()),
    WindChargeProjectile(0x8F | Projectile.getValue()),
    Bogged(0x90 | SkeletonMonster.getValue()),
    OminousItemSpawner(145),
    Creaking(0x92 | Monster.getValue()),
    HappyGhast(0x93 | Animal.getValue());

    private static final Int2ObjectMap<ActorType> BY_VALUE;
    private final int value;

    public static ActorType getByValue(int value) {
        return (ActorType)((Object)BY_VALUE.get(value));
    }

    public static ActorType getByValue(int value, ActorType fallback) {
        return (ActorType)((Object)BY_VALUE.getOrDefault(value, (Object)fallback));
    }

    private ActorType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    static {
        BY_VALUE = new Int2ObjectOpenHashMap();
        for (ActorType value : ActorType.values()) {
            if (BY_VALUE.containsKey(value.value)) continue;
            BY_VALUE.put(value.value, (Object)value);
        }
    }
}

