/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.data.enums.bedrock;

import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;

public enum PackType {
    Invalid(0),
    Addon(1),
    Cached(2),
    CopyProtected(3),
    Behavior(4),
    PersonaPiece(5),
    Resources(6),
    Skins(7),
    WorldTemplate(8);

    private static final Int2ObjectMap<PackType> BY_VALUE;
    private final int value;

    public static PackType getByValue(int value) {
        return (PackType)((Object)BY_VALUE.get(value));
    }

    public static PackType getByValue(int value, PackType fallback) {
        return (PackType)((Object)BY_VALUE.getOrDefault(value, (Object)fallback));
    }

    private PackType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    static {
        BY_VALUE = new Int2ObjectOpenHashMap();
        for (PackType value : PackType.values()) {
            if (BY_VALUE.containsKey(value.value)) continue;
            BY_VALUE.put(value.value, (Object)value);
        }
    }
}

