/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packet;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ServerboundPackets1_21_6;
import com.viaversion.viaversion.util.Pair;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.container.player.InventoryContainer;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.model.entity.Entity;
import net.raphimc.viabedrock.api.util.BitSets;
import net.raphimc.viabedrock.api.util.EnumUtil;
import net.raphimc.viabedrock.api.util.MathUtil;
import net.raphimc.viabedrock.api.util.PacketFactory;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.enums.Direction;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AbilitiesIndex;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AnimatePacket_Action;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ClientPlayMode;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ComplexInventoryTransaction_Type;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.GameType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.InputMode;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ItemUseOnActorInventoryTransaction_ActionType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.NewInteractionModel;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.PlayerActionType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.PlayerAuthInputPacket_InputData;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.PlayerRespawnState;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.PredictionType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ServerboundLoadingScreenPacketType;
import net.raphimc.viabedrock.protocol.data.enums.java.AbilitiesFlag;
import net.raphimc.viabedrock.protocol.data.enums.java.ClientCommandAction;
import net.raphimc.viabedrock.protocol.data.enums.java.GameEventType;
import net.raphimc.viabedrock.protocol.data.enums.java.InputFlag;
import net.raphimc.viabedrock.protocol.data.enums.java.InteractActionType;
import net.raphimc.viabedrock.protocol.data.enums.java.InteractionHand;
import net.raphimc.viabedrock.protocol.data.enums.java.PlayerActionAction;
import net.raphimc.viabedrock.protocol.data.enums.java.PlayerCommandAction;
import net.raphimc.viabedrock.protocol.data.enums.java.PlayerInfoUpdateAction;
import net.raphimc.viabedrock.protocol.data.enums.java.Relative;
import net.raphimc.viabedrock.protocol.model.Position2f;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.GameTypeRewriter;
import net.raphimc.viabedrock.protocol.rewriter.ItemRewriter;
import net.raphimc.viabedrock.protocol.storage.ChunkTracker;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameRulesStorage;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.InventoryTracker;
import net.raphimc.viabedrock.protocol.storage.PlayerListStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ClientPlayerPackets {
    private static final PacketHandler CLIENT_PLAYER_GAME_MODE_INFO_UPDATE = wrapper -> {
        ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
        PacketWrapper playerInfoUpdate = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.PLAYER_INFO_UPDATE, (UserConnection)wrapper.user());
        playerInfoUpdate.write((Type)Types.PROFILE_ACTIONS_ENUM1_21_4, (Object)BitSets.create(8, PlayerInfoUpdateAction.UPDATE_GAME_MODE));
        playerInfoUpdate.write((Type)Types.VAR_INT, (Object)1);
        playerInfoUpdate.write(Types.UUID, (Object)clientPlayer.javaUuid());
        playerInfoUpdate.write((Type)Types.VAR_INT, (Object)clientPlayer.javaGameMode().ordinal());
        playerInfoUpdate.send(BedrockProtocol.class);
    };
    private static final PacketHandler CLIENT_PLAYER_GAME_MODE_UPDATE = wrapper -> {
        ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
        PacketFactory.sendJavaGameEvent(wrapper.user(), GameEventType.CHANGE_GAME_MODE, clientPlayer.javaGameMode().ordinal());
    };

    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.RESPAWN, (ClientboundPacketType)ClientboundPackets1_21_6.RESPAWN, wrapper -> {
            Position3f position = (Position3f)wrapper.read(BedrockTypes.POSITION_3F);
            byte rawState = (Byte)wrapper.read((Type)Types.BYTE);
            PlayerRespawnState state = PlayerRespawnState.getByValue(rawState);
            if (state == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown PlayerRespawnState: " + rawState);
                wrapper.cancel();
                return;
            }
            wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            switch (state) {
                case ReadyToSpawn: {
                    ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
                    clientPlayer.setPosition(position);
                    if (clientPlayer.isInitiallySpawned()) {
                        GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
                        GameRulesStorage gameRulesStorage = (GameRulesStorage)wrapper.user().get(GameRulesStorage.class);
                        ChunkTracker chunkTracker = (ChunkTracker)wrapper.user().get(ChunkTracker.class);
                        InventoryTracker inventoryTracker = (InventoryTracker)wrapper.user().get(InventoryTracker.class);
                        if (clientPlayer.isDead() && !((Boolean)gameRulesStorage.getGameRule("keepInventory")).booleanValue()) {
                            inventoryTracker.getInventoryContainer().clearItems();
                            inventoryTracker.getOffhandContainer().clearItems();
                            inventoryTracker.getArmorContainer().clearItems();
                            inventoryTracker.getHudContainer().clearItems();
                        }
                        clientPlayer.clearEffects();
                        clientPlayer.setHealth(clientPlayer.attributes().get("minecraft:health").maxValue());
                        clientPlayer.sendPlayerActionPacketToServer(PlayerActionType.Respawn, -1);
                        wrapper.write((Type)Types.VAR_INT, (Object)chunkTracker.getDimension().ordinal());
                        wrapper.write(Types.STRING, (Object)chunkTracker.getDimension().getKey());
                        wrapper.write((Type)Types.LONG, (Object)0L);
                        wrapper.write((Type)Types.BYTE, (Object)((byte)clientPlayer.javaGameMode().ordinal()));
                        wrapper.write((Type)Types.BYTE, (Object)-1);
                        wrapper.write((Type)Types.BOOLEAN, (Object)false);
                        wrapper.write((Type)Types.BOOLEAN, (Object)gameSession.isFlatGenerator());
                        wrapper.write(Types.OPTIONAL_GLOBAL_POSITION, null);
                        wrapper.write((Type)Types.VAR_INT, (Object)0);
                        wrapper.write((Type)Types.VAR_INT, (Object)64);
                        wrapper.write((Type)Types.BYTE, (Object)3);
                        wrapper.send(BedrockProtocol.class);
                        clientPlayer.sendAttribute("minecraft:health");
                        clientPlayer.setAbilities(clientPlayer.abilities());
                        PacketFactory.sendJavaGameEvent(wrapper.user(), GameEventType.LEVEL_CHUNKS_LOAD_START, 0.0f);
                        if (((Boolean)gameRulesStorage.getGameRule("keepInventory")).booleanValue()) {
                            PacketFactory.sendJavaContainerSetContent(wrapper.user(), inventoryTracker.getInventoryContainer());
                        }
                        inventoryTracker.getInventoryContainer().sendSelectedHotbarSlotToClient();
                    }
                    wrapper.cancel();
                    clientPlayer.sendPlayerPositionPacketToClient(Relative.NONE);
                    break;
                }
                case SearchingForSpawn: 
                case ClientReadyToSpawn: {
                    wrapper.cancel();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled PlayerRespawnState: " + state);
                }
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.PLAYER_ACTION, null, wrapper -> {
            ClientPlayerEntity clientPlayer;
            wrapper.cancel();
            wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            int rawAction = (Integer)wrapper.read((Type)BedrockTypes.VAR_INT);
            PlayerActionType action = PlayerActionType.getByValue(rawAction);
            if (action == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown PlayerActionType: " + rawAction);
                return;
            }
            wrapper.read(BedrockTypes.BLOCK_POSITION);
            wrapper.read(BedrockTypes.BLOCK_POSITION);
            wrapper.read((Type)BedrockTypes.VAR_INT);
            if (action == PlayerActionType.ChangeDimensionAck && (clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer()).dimensionChangeInfo() != null) {
                clientPlayer.sendPlayerActionPacketToServer(PlayerActionType.ChangeDimensionAck);
                PacketFactory.sendBedrockLoadingScreen(wrapper.user(), ServerboundLoadingScreenPacketType.EndLoadingScreen, clientPlayer.dimensionChangeInfo().loadingScreenId());
                clientPlayer.sendPlayerPositionPacketToClient(Relative.NONE);
                PacketFactory.sendJavaGameEvent(wrapper.user(), GameEventType.LEVEL_CHUNKS_LOAD_START, 0.0f);
                clientPlayer.setDimensionChangeInfo(null);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.CORRECT_PLAYER_MOVE_PREDICTION, (ClientboundPacketType)ClientboundPackets1_21_6.PLAYER_POSITION, wrapper -> {
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            byte rawPredictionType = (Byte)wrapper.read((Type)Types.BYTE);
            PredictionType predictionType = PredictionType.getByValue(rawPredictionType);
            if (predictionType == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown PredictionType: " + rawPredictionType);
                return;
            }
            Position3f position = (Position3f)wrapper.read(BedrockTypes.POSITION_3F);
            wrapper.read(BedrockTypes.POSITION_3F);
            switch (predictionType) {
                case Player: {
                    ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
                    boolean onGround = (Boolean)wrapper.read((Type)Types.BOOLEAN);
                    long tick = (Long)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
                    if (tick > (long)clientPlayer.age() || tick < (long)(clientPlayer.age() - gameSession.getMovementRewindHistorySize())) {
                        wrapper.cancel();
                        return;
                    }
                    clientPlayer.setPosition(position);
                    clientPlayer.setOnGround(onGround);
                    clientPlayer.writePlayerPositionPacketToClient(wrapper, Relative.union(Relative.ROTATION, Relative.VELOCITY), true);
                    break;
                }
                case Vehicle: {
                    wrapper.cancel();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled PredictionType: " + predictionType);
                }
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_PLAYER_GAME_TYPE, null, (PacketHandler)new PacketHandlers(){

            protected void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer().setGameType(GameType.getByValue((Integer)wrapper.read((Type)BedrockTypes.VAR_INT), GameType.Undefined));
                });
                this.handler(CLIENT_PLAYER_GAME_MODE_INFO_UPDATE);
                this.handler(CLIENT_PLAYER_GAME_MODE_UPDATE);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_DEFAULT_GAME_TYPE, null, (PacketHandler)new PacketHandlers(){

            protected void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    ((GameSessionStorage)wrapper.user().get(GameSessionStorage.class)).setLevelGameType(GameType.getByValue((Integer)wrapper.read((Type)BedrockTypes.VAR_INT), GameType.Undefined));
                    ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer().updateJavaGameMode();
                });
                this.handler(CLIENT_PLAYER_GAME_MODE_INFO_UPDATE);
                this.handler(CLIENT_PLAYER_GAME_MODE_UPDATE);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.UPDATE_PLAYER_GAME_TYPE, (ClientboundPacketType)ClientboundPackets1_21_6.PLAYER_INFO_UPDATE, wrapper -> {
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            PlayerListStorage playerList = (PlayerListStorage)wrapper.user().get(PlayerListStorage.class);
            GameType gameType = GameType.getByValue((Integer)wrapper.read((Type)BedrockTypes.VAR_INT), GameType.Undefined);
            long uniqueEntityId = (Long)wrapper.read((Type)BedrockTypes.VAR_LONG);
            wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_LONG);
            Pair<UUID, String> playerListEntry = playerList.getPlayer(uniqueEntityId);
            if (playerListEntry == null) {
                wrapper.cancel();
                return;
            }
            wrapper.write((Type)Types.PROFILE_ACTIONS_ENUM1_21_4, (Object)BitSets.create(8, PlayerInfoUpdateAction.UPDATE_GAME_MODE));
            wrapper.write((Type)Types.VAR_INT, (Object)1);
            wrapper.write(Types.UUID, (Object)((UUID)playerListEntry.key()));
            wrapper.write((Type)Types.VAR_INT, (Object)GameTypeRewriter.getEffectiveGameMode(gameType, gameSession.getLevelGameType()).ordinal());
            if (((UUID)playerListEntry.key()).equals(clientPlayer.javaUuid())) {
                clientPlayer.setGameType(gameType);
                CLIENT_PLAYER_GAME_MODE_UPDATE.handle(wrapper);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.UPDATE_ADVENTURE_SETTINGS, null, wrapper -> {
            wrapper.cancel();
            wrapper.read((Type)Types.BOOLEAN);
            wrapper.read((Type)Types.BOOLEAN);
            ((GameSessionStorage)wrapper.user().get(GameSessionStorage.class)).setImmutableWorld((Boolean)wrapper.read((Type)Types.BOOLEAN));
            wrapper.read((Type)Types.BOOLEAN);
            wrapper.read((Type)Types.BOOLEAN);
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.CLIENT_COMMAND, ServerboundBedrockPackets.RESPAWN, wrapper -> {
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            ClientCommandAction action = ClientCommandAction.values()[(Integer)wrapper.read((Type)Types.VAR_INT)];
            switch (action) {
                case PERFORM_RESPAWN: {
                    wrapper.write(BedrockTypes.POSITION_3F, (Object)Position3f.ZERO);
                    wrapper.write((Type)Types.BYTE, (Object)((byte)PlayerRespawnState.ClientReadyToSpawn.getValue()));
                    wrapper.write((Type)BedrockTypes.UNSIGNED_VAR_LONG, (Object)clientPlayer.runtimeId());
                    break;
                }
                case REQUEST_STATS: {
                    wrapper.cancel();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled ClientCommandAction: " + action);
                }
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.PLAYER_COMMAND, null, wrapper -> {
            wrapper.cancel();
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            wrapper.read((Type)Types.VAR_INT);
            PlayerCommandAction action = PlayerCommandAction.values()[(Integer)wrapper.read((Type)Types.VAR_INT)];
            int data = (Integer)wrapper.read((Type)Types.VAR_INT);
            switch (action) {
                case START_SPRINTING: {
                    clientPlayer.setSprinting(true);
                    clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.StartSprinting);
                    break;
                }
                case STOP_SPRINTING: {
                    clientPlayer.setSprinting(false);
                    clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.StopSprinting);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled PlayerCommandAction: " + action);
                }
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.PLAYER_ACTION, null, wrapper -> {
            boolean isMining;
            wrapper.cancel();
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            ChunkTracker chunkTracker = (ChunkTracker)wrapper.user().get(ChunkTracker.class);
            PlayerActionAction action = PlayerActionAction.values()[(Integer)wrapper.read((Type)Types.VAR_INT)];
            BlockPosition position = (BlockPosition)wrapper.read(Types.BLOCK_POSITION1_14);
            Direction direction = Direction.values()[(Short)wrapper.read((Type)Types.UNSIGNED_BYTE)];
            int sequence = (Integer)wrapper.read((Type)Types.VAR_INT);
            boolean bl = isMining = action == PlayerActionAction.START_DESTROY_BLOCK || action == PlayerActionAction.ABORT_DESTROY_BLOCK || action == PlayerActionAction.STOP_DESTROY_BLOCK;
            if (isMining && (gameSession.isImmutableWorld() || !clientPlayer.abilities().getBooleanValue(AbilitiesIndex.Mine))) {
                BedrockProtocol.kickForIllegalState(wrapper.user(), "Breaking blocks in protected areas is not handled yet by ViaBedrock");
                PacketFactory.sendJavaBlockUpdate(wrapper.user(), position, chunkTracker.getJavaBlockState(position));
                PacketFactory.sendJavaBlockChangedAck(wrapper.user(), sequence);
                return;
            }
            switch (action) {
                case START_DESTROY_BLOCK: {
                    clientPlayer.sendSwingPacketToServer();
                    clientPlayer.cancelNextSwingPacket();
                    clientPlayer.setBlockBreakingInfo(new ClientPlayerEntity.BlockBreakingInfo(position, direction));
                    clientPlayer.addAuthInputBlockAction(new ClientPlayerEntity.AuthInputBlockAction(PlayerActionType.StartDestroyBlock, position, direction.ordinal()));
                    break;
                }
                case ABORT_DESTROY_BLOCK: {
                    clientPlayer.setBlockBreakingInfo(null);
                    clientPlayer.addAuthInputBlockAction(new ClientPlayerEntity.AuthInputBlockAction(PlayerActionType.AbortDestroyBlock, position, 0));
                    break;
                }
                case STOP_DESTROY_BLOCK: {
                    clientPlayer.cancelNextSwingPacket();
                    clientPlayer.setBlockBreakingInfo(null);
                    if (!gameSession.isBlockBreakingServerAuthoritative()) {
                        clientPlayer.addAuthInputBlockAction(new ClientPlayerEntity.AuthInputBlockAction(PlayerActionType.StopDestroyBlock));
                        clientPlayer.addAuthInputBlockAction(new ClientPlayerEntity.AuthInputBlockAction(PlayerActionType.CrackBlock, position, direction.ordinal()));
                        clientPlayer.addAuthInputBlockAction(new ClientPlayerEntity.AuthInputBlockAction(PlayerActionType.AbortDestroyBlock, position, 0));
                    } else {
                        clientPlayer.addAuthInputBlockAction(new ClientPlayerEntity.AuthInputBlockAction(PlayerActionType.ContinueDestroyBlock, position, direction.ordinal()));
                        clientPlayer.addAuthInputBlockAction(new ClientPlayerEntity.AuthInputBlockAction(PlayerActionType.PredictDestroyBlock, position, direction.ordinal()));
                        clientPlayer.addAuthInputBlockAction(new ClientPlayerEntity.AuthInputBlockAction(PlayerActionType.AbortDestroyBlock, position, 0));
                    }
                    chunkTracker.handleBlockChange(position, 0, chunkTracker.airId());
                    PacketFactory.sendJavaBlockUpdate(wrapper.user(), position, 0);
                    break;
                }
                case DROP_ALL_ITEMS: 
                case DROP_ITEM: {
                    PacketFactory.sendJavaContainerSetContent(wrapper.user(), ((InventoryTracker)wrapper.user().get(InventoryTracker.class)).getInventoryContainer());
                    break;
                }
                case RELEASE_USE_ITEM: {
                    PacketFactory.sendJavaContainerSetContent(wrapper.user(), ((InventoryTracker)wrapper.user().get(InventoryTracker.class)).getInventoryContainer());
                    break;
                }
                case SWAP_ITEM_WITH_OFFHAND: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled PlayerActionAction: " + action);
                }
            }
            if (sequence > 0) {
                PacketFactory.sendJavaBlockChangedAck(wrapper.user(), sequence);
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.INTERACT, ServerboundBedrockPackets.INVENTORY_TRANSACTION, wrapper -> {
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            InventoryContainer inventoryContainer = ((InventoryTracker)wrapper.user().get(InventoryTracker.class)).getInventoryContainer();
            int entityId = (Integer)wrapper.read((Type)Types.VAR_INT);
            InteractActionType action = InteractActionType.values()[(Integer)wrapper.read((Type)Types.VAR_INT)];
            Entity entity = entityTracker.getEntityByJid(entityId);
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            wrapper.write((Type)BedrockTypes.VAR_INT, (Object)0);
            wrapper.write((Type)BedrockTypes.UNSIGNED_VAR_INT, (Object)ComplexInventoryTransaction_Type.ItemUseOnEntityTransaction.getValue());
            wrapper.write((Type)BedrockTypes.UNSIGNED_VAR_INT, (Object)0);
            wrapper.write((Type)BedrockTypes.UNSIGNED_VAR_LONG, (Object)entity.runtimeId());
            wrapper.write((Type)BedrockTypes.UNSIGNED_VAR_INT, (Object)(switch (action) {
                case InteractActionType.INTERACT, InteractActionType.INTERACT_AT -> ItemUseOnActorInventoryTransaction_ActionType.Interact;
                case InteractActionType.ATTACK -> ItemUseOnActorInventoryTransaction_ActionType.Attack;
                default -> throw new IllegalStateException("Unhandled InteractActionType: " + action);
            }).getValue());
            wrapper.write((Type)BedrockTypes.VAR_INT, (Object)inventoryContainer.getSelectedHotbarSlot());
            wrapper.write(((ItemRewriter)wrapper.user().get(ItemRewriter.class)).itemType(), (Object)inventoryContainer.getSelectedHotbarItem());
            wrapper.write(BedrockTypes.POSITION_3F, (Object)entityTracker.getClientPlayer().position());
            switch (action) {
                case INTERACT: {
                    wrapper.cancel();
                    break;
                }
                case ATTACK: {
                    wrapper.read((Type)Types.BOOLEAN);
                    wrapper.write(BedrockTypes.POSITION_3F, (Object)Position3f.ZERO);
                    entityTracker.getClientPlayer().sendSwingPacketToServer();
                    entityTracker.getClientPlayer().cancelNextSwingPacket();
                    break;
                }
                case INTERACT_AT: {
                    float x = ((Float)wrapper.read((Type)Types.FLOAT)).floatValue();
                    float y = ((Float)wrapper.read((Type)Types.FLOAT)).floatValue();
                    float z = ((Float)wrapper.read((Type)Types.FLOAT)).floatValue();
                    InteractionHand hand = InteractionHand.values()[(Integer)wrapper.read((Type)Types.VAR_INT)];
                    if (hand != InteractionHand.MAIN_HAND) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.read((Type)Types.BOOLEAN);
                    wrapper.write(BedrockTypes.POSITION_3F, (Object)entity.position().add(x, y, z));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled InteractActionType: " + action);
                }
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.MOVE_PLAYER_STATUS_ONLY, null, wrapper -> {
            wrapper.cancel();
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            clientPlayer.updatePlayerPosition((Short)wrapper.read((Type)Types.UNSIGNED_BYTE));
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.MOVE_PLAYER_POS, null, wrapper -> {
            wrapper.cancel();
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            clientPlayer.updatePlayerPosition((Double)wrapper.read((Type)Types.DOUBLE), (Double)wrapper.read((Type)Types.DOUBLE), (Double)wrapper.read((Type)Types.DOUBLE), (Short)wrapper.read((Type)Types.UNSIGNED_BYTE));
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.MOVE_PLAYER_POS_ROT, null, wrapper -> {
            wrapper.cancel();
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            clientPlayer.updatePlayerPosition((Double)wrapper.read((Type)Types.DOUBLE), (Double)wrapper.read((Type)Types.DOUBLE), (Double)wrapper.read((Type)Types.DOUBLE), ((Float)wrapper.read((Type)Types.FLOAT)).floatValue(), ((Float)wrapper.read((Type)Types.FLOAT)).floatValue(), (Short)wrapper.read((Type)Types.UNSIGNED_BYTE));
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.MOVE_PLAYER_ROT, null, wrapper -> {
            wrapper.cancel();
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            clientPlayer.updatePlayerPosition(((Float)wrapper.read((Type)Types.FLOAT)).floatValue(), ((Float)wrapper.read((Type)Types.FLOAT)).floatValue(), (Short)wrapper.read((Type)Types.UNSIGNED_BYTE));
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.ACCEPT_TELEPORTATION, null, wrapper -> {
            wrapper.cancel();
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            clientPlayer.confirmTeleport((Integer)wrapper.read((Type)Types.VAR_INT));
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.PLAYER_INPUT, null, wrapper -> {
            wrapper.cancel();
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            Set<InputFlag> inputFlags = EnumUtil.getEnumSetFromBitmask(InputFlag.class, ((Byte)wrapper.read((Type)Types.BYTE)).byteValue(), Enum::ordinal);
            clientPlayer.setInputFlags(inputFlags);
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.CLIENT_TICK_END, ServerboundBedrockPackets.PLAYER_AUTH_INPUT, wrapper -> {
            Position3f velocity;
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            Position3f prevPosition = clientPlayer.prevPosition();
            boolean prevOnGround = clientPlayer.prevOnGround();
            Set<InputFlag> prevInputFlags = clientPlayer.prevInputFlags();
            clientPlayer.tick();
            if (prevOnGround && clientPlayer.inputFlags().contains((Object)InputFlag.JUMP)) {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.StartJumping);
            }
            if (!clientPlayer.isInitiallySpawned() || clientPlayer.isDead()) {
                wrapper.cancel();
                return;
            }
            clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.BlockBreakingDelayEnabled);
            if (clientPlayer.isOnGround()) {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.VerticalCollision);
            }
            if (clientPlayer.horizontalCollision()) {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.HorizontalCollision);
            }
            if (clientPlayer.inputFlags().contains((Object)InputFlag.FORWARD)) {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.Up);
            }
            if (clientPlayer.inputFlags().contains((Object)InputFlag.BACKWARD)) {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.Down);
            }
            if (clientPlayer.inputFlags().contains((Object)InputFlag.LEFT)) {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.Left);
            }
            if (clientPlayer.inputFlags().contains((Object)InputFlag.RIGHT)) {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.Right);
            }
            if (clientPlayer.inputFlags().contains((Object)InputFlag.JUMP)) {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.JumpDown, PlayerAuthInputPacket_InputData.Jumping, PlayerAuthInputPacket_InputData.WantUp, PlayerAuthInputPacket_InputData.JumpCurrentRaw);
            }
            if (clientPlayer.inputFlags().contains((Object)InputFlag.SHIFT)) {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.SneakDown, PlayerAuthInputPacket_InputData.Sneaking, PlayerAuthInputPacket_InputData.WantDown, PlayerAuthInputPacket_InputData.SneakCurrentRaw);
            }
            if (clientPlayer.inputFlags().contains((Object)InputFlag.SPRINT)) {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.SprintDown, PlayerAuthInputPacket_InputData.Sprinting);
            }
            if (clientPlayer.inputFlags().contains((Object)InputFlag.JUMP) && !prevInputFlags.contains((Object)InputFlag.JUMP)) {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.JumpPressedRaw);
            }
            if (prevInputFlags.contains((Object)InputFlag.JUMP) && !clientPlayer.inputFlags().contains((Object)InputFlag.JUMP)) {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.JumpReleasedRaw);
            }
            if (clientPlayer.inputFlags().contains((Object)InputFlag.SHIFT) && !prevInputFlags.contains((Object)InputFlag.SHIFT)) {
                clientPlayer.setSneaking(true);
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.SneakPressedRaw, PlayerAuthInputPacket_InputData.StartSneaking);
            }
            if (prevInputFlags.contains((Object)InputFlag.SHIFT) && !clientPlayer.inputFlags().contains((Object)InputFlag.SHIFT)) {
                clientPlayer.setSneaking(false);
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.SneakReleasedRaw, PlayerAuthInputPacket_InputData.StopSneaking);
            }
            Position3f positionDelta = clientPlayer.position().subtract(prevPosition);
            if (!clientPlayer.isInitiallySpawned() || clientPlayer.dimensionChangeInfo() != null || clientPlayer.abilities().getBooleanValue(AbilitiesIndex.Flying)) {
                velocity = positionDelta;
            } else {
                float dx = positionDelta.x() * 0.98f;
                float dy = positionDelta.y();
                float dz = positionDelta.z() * 0.98f;
                float friction = clientPlayer.isOnGround() ? 0.6f : 1.0f;
                dy = clientPlayer.effects().containsKey("minecraft:levitation") ? (dy += 0.05f * (float)(clientPlayer.effects().get("minecraft:levitation").amplifier() + 1) * 0.2f) : (dy -= 0.08f);
                velocity = new Position3f((dx *= friction) * 0.91f, dy * 0.98f, (dz *= friction) * 0.91f);
            }
            wrapper.write((Type)BedrockTypes.FLOAT_LE, (Object)Float.valueOf(clientPlayer.rotation().x()));
            wrapper.write((Type)BedrockTypes.FLOAT_LE, (Object)Float.valueOf(clientPlayer.rotation().y()));
            wrapper.write(BedrockTypes.POSITION_3F, (Object)clientPlayer.position());
            wrapper.write(BedrockTypes.POSITION_2F, (Object)MathUtil.calculateMovementDirections(clientPlayer.authInputData(), clientPlayer.isSneaking()));
            wrapper.write((Type)BedrockTypes.FLOAT_LE, (Object)Float.valueOf(clientPlayer.rotation().z()));
            wrapper.write(BedrockTypes.UNSIGNED_VAR_BIG_INTEGER, (Object)EnumUtil.getBigBitmaskFromEnumSet(clientPlayer.authInputData(), PlayerAuthInputPacket_InputData::getValue));
            wrapper.write((Type)BedrockTypes.UNSIGNED_VAR_INT, (Object)InputMode.Mouse.getValue());
            wrapper.write((Type)BedrockTypes.UNSIGNED_VAR_INT, (Object)ClientPlayMode.Screen.getValue());
            wrapper.write((Type)BedrockTypes.UNSIGNED_VAR_INT, (Object)NewInteractionModel.Touch.getValue());
            wrapper.write((Type)BedrockTypes.FLOAT_LE, (Object)Float.valueOf(clientPlayer.rotation().x()));
            wrapper.write((Type)BedrockTypes.FLOAT_LE, (Object)Float.valueOf(clientPlayer.rotation().y()));
            wrapper.write((Type)BedrockTypes.UNSIGNED_VAR_LONG, (Object)clientPlayer.age());
            wrapper.write(BedrockTypes.POSITION_3F, (Object)velocity);
            if (clientPlayer.authInputData().contains((Object)PlayerAuthInputPacket_InputData.PerformBlockActions)) {
                wrapper.write((Type)BedrockTypes.VAR_INT, (Object)clientPlayer.authInputBlockActions().size());
                for (ClientPlayerEntity.AuthInputBlockAction blockAction : clientPlayer.authInputBlockActions()) {
                    wrapper.write((Type)BedrockTypes.VAR_INT, (Object)blockAction.action().getValue());
                    switch (blockAction.action()) {
                        case StartDestroyBlock: 
                        case AbortDestroyBlock: 
                        case CrackBlock: 
                        case PredictDestroyBlock: 
                        case ContinueDestroyBlock: {
                            wrapper.write(BedrockTypes.POSITION_3I, (Object)blockAction.position());
                            wrapper.write((Type)BedrockTypes.VAR_INT, (Object)blockAction.direction());
                        }
                    }
                }
            }
            wrapper.write(BedrockTypes.POSITION_2F, (Object)new Position2f(0.0f, 0.0f));
            wrapper.write(BedrockTypes.POSITION_3F, (Object)MathUtil.calculateCameraOrientation(clientPlayer.rotation().y(), clientPlayer.rotation().x()));
            wrapper.write(BedrockTypes.POSITION_2F, (Object)MathUtil.calculateMovementDirections(clientPlayer.authInputData(), false));
            clientPlayer.authInputData().clear();
            clientPlayer.authInputBlockActions().clear();
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.PLAYER_ABILITIES, null, wrapper -> {
            boolean flying;
            wrapper.cancel();
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            byte flags = (Byte)wrapper.read((Type)Types.BYTE);
            boolean bl = flying = (flags & AbilitiesFlag.FLYING.getBit()) != 0;
            if (flying != clientPlayer.abilities().getBooleanValue(AbilitiesIndex.Flying)) {
                clientPlayer.abilities().getOrCreateCacheLayer().setAbility(AbilitiesIndex.Flying, flying);
                clientPlayer.addAuthInputData(flying ? PlayerAuthInputPacket_InputData.StartFlying : PlayerAuthInputPacket_InputData.StopFlying);
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.SWING, ServerboundBedrockPackets.ANIMATE, wrapper -> {
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            ClientPlayerEntity clientPlayer = ((EntityTracker)wrapper.user().get(EntityTracker.class)).getClientPlayer();
            InteractionHand hand = InteractionHand.values()[(Integer)wrapper.read((Type)Types.VAR_INT)];
            if (hand != InteractionHand.MAIN_HAND || clientPlayer.checkCancelSwingPacket()) {
                wrapper.cancel();
                return;
            }
            wrapper.write((Type)BedrockTypes.VAR_INT, (Object)AnimatePacket_Action.Swing.getValue());
            wrapper.write((Type)BedrockTypes.UNSIGNED_VAR_LONG, (Object)clientPlayer.runtimeId());
            if (clientPlayer.blockBreakingInfo() != null) {
                if (!gameSession.isBlockBreakingServerAuthoritative()) {
                    ClientPlayerEntity.BlockBreakingInfo blockBreakingInfo = clientPlayer.blockBreakingInfo();
                    clientPlayer.addAuthInputBlockAction(new ClientPlayerEntity.AuthInputBlockAction(PlayerActionType.CrackBlock, blockBreakingInfo.position(), blockBreakingInfo.direction().ordinal()));
                }
            } else {
                clientPlayer.addAuthInputData(PlayerAuthInputPacket_InputData.MissedSwing);
            }
        });
    }
}

