/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.provider.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.provider.ResourcePackProvider;

public class DiskResourcePackProvider
extends ResourcePackProvider {
    @Override
    public boolean hasPack(ResourcePack pack) {
        return this.getPackFile(pack).isFile();
    }

    @Override
    public void loadPack(ResourcePack pack) throws Exception {
        if (!this.hasPack(pack)) {
            throw new IOException("Pack not found");
        }
        byte[] data = Files.readAllBytes(this.getPackFile(pack).toPath());
        pack.setContentKey(new byte[0]);
        pack.setCompressedDataLength(data.length, data.length);
        pack.processDataChunk(0, data);
    }

    @Override
    public void addPack(ResourcePack pack) throws IOException {
        Files.write(this.getPackFile(pack).toPath(), pack.content().toZip(), new OpenOption[0]);
    }

    private File getPackFile(ResourcePack pack) {
        return new File(ViaBedrock.getPlatform().getServerPacksFolder(), pack.packId() + "_" + pack.version() + ".mcpack");
    }
}

