/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter.blockentity;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.IntTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntityImpl;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.chunk.BedrockBlockEntity;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.rewriter.BlockEntityRewriter;

public class BeaconBlockEntityRewriter
implements BlockEntityRewriter.Rewriter {
    @Override
    public BlockEntity toJava(UserConnection user, BedrockBlockEntity bedrockBlockEntity) {
        CompoundTag bedrockTag = bedrockBlockEntity.tag();
        CompoundTag javaTag = new CompoundTag();
        this.mapEffect(bedrockTag, javaTag, "primary", "primary_effect");
        this.mapEffect(bedrockTag, javaTag, "secondary", "secondary_effect");
        return new BlockEntityImpl(bedrockBlockEntity.packedXZ(), bedrockBlockEntity.y(), -1, javaTag);
    }

    private void mapEffect(CompoundTag oldTag, CompoundTag newTag, String oldName, String newName) {
        Tag tag = oldTag.get(oldName);
        if (tag instanceof IntTag) {
            IntTag effectTag = (IntTag)tag;
            int bedrockId = effectTag.asInt();
            if (bedrockId == 0) {
                return;
            }
            String bedrockIdentifier = (String)BedrockProtocol.MAPPINGS.getBedrockEffects().inverse().get((Object)bedrockId);
            if (bedrockIdentifier == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown bedrock beacon effect: " + bedrockId);
                return;
            }
            newTag.putString(newName, BedrockProtocol.MAPPINGS.getBedrockToJavaEffects().get(bedrockIdentifier));
        }
    }
}

