/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.minecraft.ChunkPosition;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntityImpl;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk1_21_5;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSectionImpl;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.DataPaletteImpl;
import com.viaversion.viaversion.api.minecraft.chunks.Heightmap;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_21_5;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntOpenHashMap;
import com.viaversion.viaversion.libs.fastutil.ints.IntObjectImmutablePair;
import com.viaversion.viaversion.libs.fastutil.ints.IntObjectPair;
import com.viaversion.viaversion.libs.fastutil.ints.IntSet;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntFunction;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import com.viaversion.viaversion.util.CompactArrayUtil;
import com.viaversion.viaversion.util.MathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.chunk.BedrockBlockEntity;
import net.raphimc.viabedrock.api.chunk.BedrockChunk;
import net.raphimc.viabedrock.api.chunk.BlockEntityWithBlockState;
import net.raphimc.viabedrock.api.chunk.datapalette.BedrockBlockArray;
import net.raphimc.viabedrock.api.chunk.datapalette.BedrockDataPalette;
import net.raphimc.viabedrock.api.chunk.section.BedrockChunkSection;
import net.raphimc.viabedrock.api.chunk.section.BedrockChunkSectionImpl;
import net.raphimc.viabedrock.api.model.BedrockBlockState;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.enums.Dimension;
import net.raphimc.viabedrock.protocol.data.enums.java.HeightmapType;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.BlockEntityRewriter;
import net.raphimc.viabedrock.protocol.rewriter.BlockStateRewriter;
import net.raphimc.viabedrock.protocol.storage.ClientSettingsStorage;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ChunkTracker
extends StoredObject {
    private static final byte[] FULL_LIGHT = new byte[2048];
    private final Dimension dimension;
    private final int minY;
    private final int worldHeight;
    private final Type<Chunk> chunkType;
    private final Map<Long, BedrockChunk> chunks = new HashMap<Long, BedrockChunk>();
    private final Set<Long> dirtyChunks = new HashSet<Long>();
    private final Set<SubChunkPosition> subChunkRequests = new HashSet<SubChunkPosition>();
    private final Set<SubChunkPosition> pendingSubChunks = new HashSet<SubChunkPosition>();
    private int centerX = 0;
    private int centerZ = 0;
    private int radius;

    public ChunkTracker(UserConnection user, Dimension dimension) {
        super(user);
        this.dimension = dimension;
        GameSessionStorage gameSession = (GameSessionStorage)user.get(GameSessionStorage.class);
        CompoundTag registries = gameSession.getJavaRegistries();
        String dimensionKey = this.dimension.getKey();
        CompoundTag dimensionRegistry = registries.getCompoundTag("minecraft:dimension_type");
        CompoundTag biomeRegistry = registries.getCompoundTag("minecraft:worldgen/biome");
        CompoundTag dimensionTag = dimensionRegistry.getCompoundTag(dimensionKey);
        this.minY = dimensionTag.getNumberTag("min_y").asInt();
        this.worldHeight = dimensionTag.getNumberTag("height").asInt();
        this.chunkType = new ChunkType1_21_5(this.worldHeight >> 4, MathUtil.ceilLog2((int)BedrockProtocol.MAPPINGS.getJavaBlockStates().size()), MathUtil.ceilLog2((int)biomeRegistry.size()));
        ChunkTracker oldChunkTracker = (ChunkTracker)user.get(ChunkTracker.class);
        this.radius = oldChunkTracker != null ? oldChunkTracker.radius : ((ClientSettingsStorage)user.get(ClientSettingsStorage.class)).viewDistance();
    }

    public void setCenter(int x, int z) {
        this.centerX = x;
        this.centerZ = z;
        this.removeOutOfLoadDistanceChunks();
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.removeOutOfLoadDistanceChunks();
    }

    public BedrockChunk createChunk(int chunkX, int chunkZ, int nonNullSectionCount) {
        int i;
        if (!this.isInLoadDistance(chunkX, chunkZ)) {
            return null;
        }
        if (!this.isInRenderDistance(chunkX, chunkZ)) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received chunk outside of render distance, but within load distance: " + chunkX + ", " + chunkZ);
            EntityTracker entityTracker = (EntityTracker)this.user().get(EntityTracker.class);
            PacketWrapper setChunkCacheCenter = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.SET_CHUNK_CACHE_CENTER, (UserConnection)this.user());
            setChunkCacheCenter.write((Type)Types.VAR_INT, (Object)((int)entityTracker.getClientPlayer().position().x() >> 4));
            setChunkCacheCenter.write((Type)Types.VAR_INT, (Object)((int)entityTracker.getClientPlayer().position().z() >> 4));
            setChunkCacheCenter.send(BedrockProtocol.class);
        }
        BedrockChunk chunk = new BedrockChunk(chunkX, chunkZ, new BedrockChunkSection[this.worldHeight >> 4]);
        for (i = 0; i < nonNullSectionCount && i < chunk.getSections().length; ++i) {
            chunk.getSections()[i] = new BedrockChunkSectionImpl();
        }
        for (i = 0; i < chunk.getSections().length; ++i) {
            if (chunk.getSections()[i] != null) continue;
            chunk.getSections()[i] = new BedrockChunkSectionImpl(true);
        }
        this.chunks.put(ChunkPosition.chunkKey((int)chunk.getX(), (int)chunk.getZ()), chunk);
        return chunk;
    }

    public void unloadChunk(ChunkPosition chunkPos) {
        this.chunks.remove(chunkPos.chunkKey());
        ((EntityTracker)this.user().get(EntityTracker.class)).removeItemFrame(chunkPos);
        PacketWrapper unloadChunk = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.FORGET_LEVEL_CHUNK, (UserConnection)this.user());
        unloadChunk.write(Types.CHUNK_POSITION, (Object)chunkPos);
        unloadChunk.send(BedrockProtocol.class);
    }

    public BedrockChunk getChunk(int chunkX, int chunkZ) {
        if (!this.isInLoadDistance(chunkX, chunkZ)) {
            return null;
        }
        return this.chunks.get(ChunkPosition.chunkKey((int)chunkX, (int)chunkZ));
    }

    public BedrockChunkSection getChunkSection(int chunkX, int subChunkY, int chunkZ) {
        BedrockChunk chunk = this.getChunk(chunkX, chunkZ);
        if (chunk == null) {
            return null;
        }
        int sectionIndex = subChunkY + Math.abs(this.minY >> 4);
        if (sectionIndex < 0 || sectionIndex >= chunk.getSections().length) {
            return null;
        }
        return chunk.getSections()[sectionIndex];
    }

    public BedrockChunkSection getChunkSection(BlockPosition blockPosition) {
        return this.getChunkSection(blockPosition.x() >> 4, blockPosition.y() >> 4, blockPosition.z() >> 4);
    }

    public int getBlockState(BlockPosition blockPosition) {
        return this.getBlockState(0, blockPosition);
    }

    public int getBlockState(int layer, BlockPosition blockPosition) {
        BedrockChunkSection chunkSection = this.getChunkSection(blockPosition);
        if (chunkSection == null) {
            return this.airId();
        }
        if (chunkSection.palettesCount(PaletteType.BLOCKS) <= layer) {
            return this.airId();
        }
        return chunkSection.palettes(PaletteType.BLOCKS).get(layer).idAt(blockPosition.x() & 0xF, blockPosition.y() & 0xF, blockPosition.z() & 0xF);
    }

    public int getJavaBlockState(BlockPosition blockPosition) {
        BedrockChunkSection chunkSection = this.getChunkSection(blockPosition);
        if (chunkSection == null) {
            return 0;
        }
        int sectionX = blockPosition.x() & 0xF;
        int sectionY = blockPosition.y() & 0xF;
        int sectionZ = blockPosition.z() & 0xF;
        return this.getJavaBlockState(chunkSection, sectionX, sectionY, sectionZ);
    }

    public int getJavaBlockState(BedrockChunkSection section, int sectionX, int sectionY, int sectionZ) {
        int layer1BlockState;
        List<DataPalette> blockPalettes;
        int layer0BlockState;
        BlockStateRewriter blockStateRewriter = (BlockStateRewriter)this.user().get(BlockStateRewriter.class);
        int remappedBlockState = blockStateRewriter.javaId(layer0BlockState = (blockPalettes = section.palettes(PaletteType.BLOCKS)).get(0).idAt(sectionX, sectionY, sectionZ));
        if (remappedBlockState == -1) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing block state: " + layer0BlockState);
            remappedBlockState = 0;
        }
        if (blockPalettes.size() > 1 && "water".equals(blockStateRewriter.tag(layer1BlockState = blockPalettes.get(1).idAt(sectionX, sectionY, sectionZ)))) {
            int prevBlockState = remappedBlockState;
            if ((remappedBlockState = blockStateRewriter.waterlog(remappedBlockState)) == -1) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing waterlogged block state: " + prevBlockState);
                remappedBlockState = prevBlockState;
            }
        }
        return remappedBlockState;
    }

    public BedrockBlockEntity getBlockEntity(BlockPosition blockPosition) {
        BedrockChunk chunk = this.getChunk(blockPosition.x() >> 4, blockPosition.z() >> 4);
        if (chunk == null) {
            return null;
        }
        return chunk.getBlockEntityAt(blockPosition);
    }

    public void addBlockEntity(BedrockBlockEntity bedrockBlockEntity) {
        BedrockChunk chunk = this.getChunk(bedrockBlockEntity.position().x() >> 4, bedrockBlockEntity.position().z() >> 4);
        if (chunk == null) {
            return;
        }
        chunk.removeBlockEntityAt(bedrockBlockEntity.position());
        chunk.blockEntities().add(bedrockBlockEntity);
    }

    public boolean isChunkLoaded(ChunkPosition chunkPos) {
        if (!this.isInLoadDistance(chunkPos.chunkX(), chunkPos.chunkZ())) {
            return false;
        }
        return this.chunks.containsKey(chunkPos.chunkKey());
    }

    public boolean isInUnloadedChunkSection(Position3f playerPosition) {
        BlockPosition chunkSectionPosition = new BlockPosition((int)Math.floor(playerPosition.x() / 16.0f), (int)Math.floor((playerPosition.y() - 1.62f) / 16.0f), (int)Math.floor(playerPosition.z() / 16.0f));
        ChunkPosition chunkPos = new ChunkPosition(chunkSectionPosition.x(), chunkSectionPosition.z());
        if (!this.isChunkLoaded(chunkPos)) {
            return true;
        }
        BedrockChunkSection chunkSection = this.getChunkSection(chunkSectionPosition.x(), chunkSectionPosition.y(), chunkSectionPosition.z());
        if (chunkSection == null) {
            return false;
        }
        if (chunkSection.hasPendingBlockUpdates()) {
            return true;
        }
        return this.dirtyChunks.contains(chunkPos.chunkKey());
    }

    public boolean isInLoadDistance(int chunkX, int chunkZ) {
        if (!this.isInRenderDistance(chunkX, chunkZ)) {
            EntityTracker entityTracker = (EntityTracker)this.user().get(EntityTracker.class);
            if (entityTracker == null) {
                return false;
            }
            int centerX = (int)entityTracker.getClientPlayer().position().x() >> 4;
            int centerZ = (int)entityTracker.getClientPlayer().position().z() >> 4;
            return Math.abs(chunkX - centerX) <= this.radius && Math.abs(chunkZ - centerZ) <= this.radius;
        }
        return true;
    }

    public boolean isInRenderDistance(int chunkX, int chunkZ) {
        return Math.abs(chunkX - this.centerX) <= this.radius && Math.abs(chunkZ - this.centerZ) <= this.radius;
    }

    public void removeOutOfLoadDistanceChunks() {
        HashSet<ChunkPosition> chunksToRemove = new HashSet<ChunkPosition>();
        for (long chunkKey : this.chunks.keySet()) {
            ChunkPosition chunkPos = new ChunkPosition(chunkKey);
            if (this.isInLoadDistance(chunkPos.chunkX(), chunkPos.chunkZ())) continue;
            chunksToRemove.add(chunkPos);
        }
        for (ChunkPosition chunkPos : chunksToRemove) {
            this.unloadChunk(chunkPos);
        }
    }

    public void requestSubChunks(int chunkX, int chunkZ, int from, int to) {
        for (int i = from; i < to; ++i) {
            this.requestSubChunk(chunkX, i, chunkZ);
        }
    }

    public void requestSubChunk(int chunkX, int subChunkY, int chunkZ) {
        if (!this.isInLoadDistance(chunkX, chunkZ)) {
            return;
        }
        this.subChunkRequests.add(new SubChunkPosition(chunkX, subChunkY, chunkZ));
    }

    public boolean mergeSubChunk(int chunkX, int subChunkY, int chunkZ, BedrockChunkSection other, List<BedrockBlockEntity> blockEntities) {
        if (!this.isInLoadDistance(chunkX, chunkZ)) {
            return false;
        }
        SubChunkPosition position = new SubChunkPosition(chunkX, subChunkY, chunkZ);
        if (!this.pendingSubChunks.contains(position)) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received sub chunk that was not requested: " + position);
            return false;
        }
        this.pendingSubChunks.remove(position);
        BedrockChunk chunk = this.getChunk(chunkX, chunkZ);
        if (chunk == null) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received sub chunk for unloaded chunk: " + position);
            return false;
        }
        BedrockChunkSection section = chunk.getSections()[subChunkY + Math.abs(this.minY >> 4)];
        section.mergeWith(this.handleBlockPalette(other));
        section.applyPendingBlockUpdates(this.airId());
        blockEntities.forEach(blockEntity -> chunk.removeBlockEntityAt(blockEntity.position()));
        chunk.blockEntities().addAll(blockEntities);
        return true;
    }

    public IntObjectPair<BlockEntity> handleBlockChange(BlockPosition blockPosition, int layer, int blockState) {
        BedrockDataPalette palette;
        BedrockChunkSection section = this.getChunkSection(blockPosition);
        if (section == null) {
            return null;
        }
        BlockStateRewriter blockStateRewriter = (BlockStateRewriter)this.user().get(BlockStateRewriter.class);
        EntityTracker entityTracker = (EntityTracker)this.user().get(EntityTracker.class);
        int sectionX = blockPosition.x() & 0xF;
        int sectionY = blockPosition.y() & 0xF;
        int sectionZ = blockPosition.z() & 0xF;
        if (section.hasPendingBlockUpdates()) {
            section.addPendingBlockUpdate(sectionX, sectionY, sectionZ, layer, blockState);
            return null;
        }
        while (section.palettesCount(PaletteType.BLOCKS) <= layer) {
            palette = new BedrockDataPalette();
            palette.addId(this.airId());
            section.addPalette(PaletteType.BLOCKS, palette);
        }
        palette = section.palettes(PaletteType.BLOCKS).get(layer);
        int prevBlockState = palette.idAt(sectionX, sectionY, sectionZ);
        String prevTag = blockStateRewriter.tag(prevBlockState);
        String tag = blockStateRewriter.tag(blockState);
        palette.setIdAt(sectionX, sectionY, sectionZ, blockState);
        int remappedBlockState = this.getJavaBlockState(section, sectionX, sectionY, sectionZ);
        if (!Objects.equals(prevTag, tag)) {
            this.getChunk(blockPosition.x() >> 4, blockPosition.z() >> 4).removeBlockEntityAt(blockPosition);
            entityTracker.removeItemFrame(blockPosition);
        }
        if (prevBlockState != blockState) {
            if (BlockEntityRewriter.isJavaBlockEntity(tag)) {
                BedrockBlockEntity bedrockBlockEntity = this.getBlockEntity(blockPosition);
                BlockEntity javaBlockEntity = null;
                if (bedrockBlockEntity != null) {
                    javaBlockEntity = BlockEntityRewriter.toJava(this.user(), blockState, bedrockBlockEntity);
                    if (javaBlockEntity instanceof BlockEntityWithBlockState) {
                        BlockEntityWithBlockState blockEntityWithBlockState = (BlockEntityWithBlockState)javaBlockEntity;
                        remappedBlockState = blockEntityWithBlockState.blockState();
                    }
                } else if (BedrockProtocol.MAPPINGS.getJavaBlockEntities().containsKey((Object)tag)) {
                    int javaType = (Integer)BedrockProtocol.MAPPINGS.getJavaBlockEntities().get((Object)tag);
                    javaBlockEntity = new BlockEntityImpl(BlockEntity.pack((int)sectionX, (int)sectionZ), (short)blockPosition.y(), javaType, new CompoundTag());
                }
                if (javaBlockEntity != null && javaBlockEntity.tag() != null) {
                    return new IntObjectImmutablePair(remappedBlockState, (Object)javaBlockEntity);
                }
            } else if ("item_frame".equals(tag)) {
                entityTracker.spawnItemFrame(blockPosition, blockStateRewriter.blockState(blockState));
            }
        }
        return new IntObjectImmutablePair(remappedBlockState, null);
    }

    public BedrockChunkSection handleBlockPalette(BedrockChunkSection section) {
        this.replaceLegacyBlocks(section);
        this.resolvePersistentIds(section);
        return section;
    }

    public void sendChunkInNextTick(int chunkX, int chunkZ) {
        this.dirtyChunks.add(ChunkPosition.chunkKey((int)chunkX, (int)chunkZ));
    }

    public void sendChunk(int chunkX, int chunkZ) {
        BedrockChunk chunk = this.getChunk(chunkX, chunkZ);
        if (chunk == null) {
            return;
        }
        Chunk remappedChunk = this.remapChunk(chunk);
        PacketWrapper levelChunkWithLight = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.LEVEL_CHUNK_WITH_LIGHT, (UserConnection)this.user());
        BitSet lightMask = new BitSet();
        lightMask.set(0, remappedChunk.getSections().length + 2);
        levelChunkWithLight.write(this.chunkType, (Object)remappedChunk);
        levelChunkWithLight.write(Types.LONG_ARRAY_PRIMITIVE, (Object)lightMask.toLongArray());
        levelChunkWithLight.write(Types.LONG_ARRAY_PRIMITIVE, (Object)new long[0]);
        levelChunkWithLight.write(Types.LONG_ARRAY_PRIMITIVE, (Object)new long[0]);
        levelChunkWithLight.write(Types.LONG_ARRAY_PRIMITIVE, (Object)lightMask.toLongArray());
        levelChunkWithLight.write((Type)Types.VAR_INT, (Object)(remappedChunk.getSections().length + 2));
        for (int i = 0; i < remappedChunk.getSections().length + 2; ++i) {
            levelChunkWithLight.write(Types.BYTE_ARRAY_PRIMITIVE, (Object)((byte[])FULL_LIGHT.clone()));
        }
        levelChunkWithLight.write((Type)Types.VAR_INT, (Object)0);
        levelChunkWithLight.send(BedrockProtocol.class);
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.worldHeight - Math.abs(this.minY);
    }

    public int getWorldHeight() {
        return this.worldHeight;
    }

    public int airId() {
        return ((BlockStateRewriter)this.user().get(BlockStateRewriter.class)).bedrockId(BedrockBlockState.AIR);
    }

    public boolean isEmpty() {
        boolean empty = true;
        empty &= this.chunks.isEmpty();
        return empty &= this.subChunkRequests.isEmpty() && this.pendingSubChunks.isEmpty();
    }

    public void tick() {
        for (Long dirtyChunk : this.dirtyChunks) {
            ChunkPosition chunkPos = new ChunkPosition(dirtyChunk.longValue());
            this.sendChunk(chunkPos.chunkX(), chunkPos.chunkZ());
        }
        this.dirtyChunks.clear();
        if (this.user().get(EntityTracker.class) == null || !((EntityTracker)this.user().get(EntityTracker.class)).getClientPlayer().isInitiallySpawned()) {
            return;
        }
        this.subChunkRequests.removeIf(s -> !this.isInLoadDistance(s.chunkX, s.chunkZ));
        BlockPosition basePosition = new BlockPosition(this.centerX, 0, this.centerZ);
        while (!this.subChunkRequests.isEmpty()) {
            Set group = this.subChunkRequests.stream().limit(256L).collect(Collectors.toSet());
            this.subChunkRequests.removeAll(group);
            this.pendingSubChunks.addAll(group);
            PacketWrapper subChunkRequest = PacketWrapper.create((PacketType)ServerboundBedrockPackets.SUB_CHUNK_REQUEST, (UserConnection)this.user());
            subChunkRequest.write((Type)BedrockTypes.VAR_INT, (Object)this.dimension.ordinal());
            subChunkRequest.write(BedrockTypes.POSITION_3I, (Object)basePosition);
            subChunkRequest.write((Type)BedrockTypes.INT_LE, (Object)group.size());
            for (SubChunkPosition subChunkPosition : group) {
                BlockPosition offset = new BlockPosition(subChunkPosition.chunkX - basePosition.x(), subChunkPosition.subChunkY, subChunkPosition.chunkZ - basePosition.z());
                subChunkRequest.write(BedrockTypes.SUB_CHUNK_OFFSET, (Object)offset);
            }
            subChunkRequest.sendToServer(BedrockProtocol.class);
        }
    }

    private Chunk remapChunk(BedrockChunk chunk) {
        BlockStateRewriter blockStateRewriter = (BlockStateRewriter)this.user().get(BlockStateRewriter.class);
        int airId = this.airId();
        Chunk1_21_5 remappedChunk = new Chunk1_21_5(chunk.getX(), chunk.getZ(), new ChunkSection[chunk.getSections().length], new Heightmap[2], new ArrayList());
        BedrockChunkSection[] bedrockSections = chunk.getSections();
        ChunkSection[] remappedSections = remappedChunk.getSections();
        for (int idx = 0; idx < bedrockSections.length; ++idx) {
            int i2;
            BedrockChunkSection bedrockSection = bedrockSections[idx];
            List<DataPalette> blockPalettes = bedrockSection.palettes(PaletteType.BLOCKS);
            remappedSections[idx] = new ChunkSectionImpl(false);
            ChunkSectionImpl remappedSection = remappedSections[idx];
            DataPalette remappedBlockPalette = remappedSection.palette(PaletteType.BLOCKS);
            if (!blockPalettes.isEmpty()) {
                DataPalette layer1;
                DataPalette layer0 = blockPalettes.get(0);
                if (layer0.size() == 1) {
                    remappedBlockPalette.addId(layer0.idByIndex(0));
                } else {
                    this.transferPaletteData(layer0, remappedBlockPalette);
                }
                String[] paletteIndexBlockStateTags = new String[remappedBlockPalette.size()];
                for (i2 = 0; i2 < remappedBlockPalette.size(); ++i2) {
                    int bedrockBlockState = remappedBlockPalette.idByIndex(i2);
                    int javaBlockState = blockStateRewriter.javaId(bedrockBlockState);
                    if (javaBlockState == -1) {
                        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing block state: " + bedrockBlockState);
                        javaBlockState = 0;
                    }
                    remappedBlockPalette.setIdByIndex(i2, javaBlockState);
                    paletteIndexBlockStateTags[i2] = blockStateRewriter.tag(bedrockBlockState);
                }
                int nonAirBlockCount = 0;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < 16; ++y) {
                            String tag;
                            int paletteIndex = remappedBlockPalette.paletteIndexAt(remappedBlockPalette.index(x, y, z));
                            int javaBlockState = remappedBlockPalette.idByIndex(paletteIndex);
                            if (javaBlockState != 0) {
                                ++nonAirBlockCount;
                            }
                            if ((tag = paletteIndexBlockStateTags[paletteIndex]) == null) continue;
                            int absY = this.minY + idx * 16 + y;
                            BlockPosition position = new BlockPosition(chunk.getX() * 16 + x, absY, chunk.getZ() * 16 + z);
                            if (BlockEntityRewriter.isJavaBlockEntity(tag)) {
                                BedrockBlockEntity bedrockBlockEntity = chunk.getBlockEntityAt(position);
                                if (bedrockBlockEntity != null) {
                                    BlockEntity javaBlockEntity = BlockEntityRewriter.toJava(this.user(), layer0.idAt(x, y, z), bedrockBlockEntity);
                                    if (javaBlockEntity instanceof BlockEntityWithBlockState) {
                                        BlockEntityWithBlockState blockEntityWithBlockState = (BlockEntityWithBlockState)javaBlockEntity;
                                        remappedBlockPalette.setIdAt(x, y, z, blockEntityWithBlockState.blockState());
                                    }
                                    if (javaBlockEntity == null || javaBlockEntity.tag() == null) continue;
                                    remappedChunk.blockEntities().add(javaBlockEntity);
                                    continue;
                                }
                                if (!BedrockProtocol.MAPPINGS.getJavaBlockEntities().containsKey((Object)tag)) continue;
                                int javaType = (Integer)BedrockProtocol.MAPPINGS.getJavaBlockEntities().get((Object)tag);
                                BlockEntityImpl javaBlockEntity = new BlockEntityImpl(BlockEntity.pack((int)x, (int)z), (short)absY, javaType, new CompoundTag());
                                remappedChunk.blockEntities().add(javaBlockEntity);
                                continue;
                            }
                            if (!"item_frame".equals(tag)) continue;
                            ((EntityTracker)this.user().get(EntityTracker.class)).spawnItemFrame(position, blockStateRewriter.blockState(layer0.idAt(x, y, z)));
                        }
                    }
                }
                remappedSection.setNonAirBlocksCount(nonAirBlockCount);
                if (blockPalettes.size() > 1 && ((layer1 = blockPalettes.get(1)).size() != 1 || layer1.idByIndex(0) != airId)) {
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            for (int y = 0; y < 16; ++y) {
                                int blockState;
                                int prevBlockState = layer0.idAt(x, y, z);
                                if (prevBlockState == airId || (blockState = layer1.idAt(x, y, z)) == airId) continue;
                                int javaBlockState = remappedBlockPalette.idAt(x, y, z);
                                if ("water".equals(blockStateRewriter.tag(blockState))) {
                                    int remappedBlockState = blockStateRewriter.waterlog(javaBlockState);
                                    if (remappedBlockState == -1) {
                                        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing waterlogged block state: " + prevBlockState);
                                        continue;
                                    }
                                    remappedBlockPalette.setIdAt(x, y, z, remappedBlockState);
                                    continue;
                                }
                                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Invalid layer 2 block state. L1: " + prevBlockState + ", L2: " + blockState);
                            }
                        }
                    }
                }
            } else {
                remappedBlockPalette.addId(0);
            }
            DataPalette biomePalette = bedrockSection.palette(PaletteType.BIOMES);
            DataPaletteImpl remappedBiomePalette = new DataPaletteImpl(64);
            remappedSection.addPalette(PaletteType.BIOMES, (DataPalette)remappedBiomePalette);
            if (biomePalette != null) {
                if (biomePalette.size() == 1) {
                    remappedBiomePalette.addId(biomePalette.idByIndex(0));
                } else {
                    for (int x = 0; x < 4; ++x) {
                        for (int z = 0; z < 4; ++z) {
                            for (int y = 0; y < 4; ++y) {
                                Int2IntOpenHashMap subBiomes = new Int2IntOpenHashMap();
                                int maxBiomeId = -1;
                                int maxValue = -1;
                                for (int subX = 0; subX < 4; ++subX) {
                                    for (int subZ = 0; subZ < 4; ++subZ) {
                                        for (int subY = 0; subY < 4; ++subY) {
                                            int biomeId = biomePalette.idAt(x * 4 + subX, y * 4 + subY, z * 4 + subZ);
                                            int value = subBiomes.getOrDefault(biomeId, 0) + 1;
                                            subBiomes.put(biomeId, value);
                                            if (value <= maxValue) continue;
                                            maxBiomeId = biomeId;
                                            maxValue = value;
                                        }
                                    }
                                }
                                remappedBiomePalette.setIdAt(x, y, z, maxBiomeId);
                            }
                        }
                    }
                }
                for (i2 = 0; i2 < remappedBiomePalette.size(); ++i2) {
                    int javaBiome;
                    int bedrockBiome = remappedBiomePalette.idByIndex(i2);
                    String bedrockBiomeName = (String)BedrockProtocol.MAPPINGS.getBedrockBiomes().inverse().get((Object)bedrockBiome);
                    if (bedrockBiomeName == null) {
                        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing biome: " + bedrockBiome);
                        javaBiome = (Integer)BedrockProtocol.MAPPINGS.getJavaBiomes().get((Object)"the_void");
                    } else {
                        javaBiome = (Integer)BedrockProtocol.MAPPINGS.getJavaBiomes().get((Object)bedrockBiomeName);
                    }
                    remappedBiomePalette.setIdByIndex(i2, javaBiome);
                }
                continue;
            }
            remappedBiomePalette.addId(0);
        }
        IntSet motionBlockingBlockStates = BedrockProtocol.MAPPINGS.getJavaHeightMapBlockStates().get("motion_blocking");
        int[] worldSurface = new int[256];
        int[] motionBlocking = new int[256];
        Arrays.fill(worldSurface, Integer.MIN_VALUE);
        Arrays.fill(motionBlocking, Integer.MIN_VALUE);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int index = z << 4 | x;
                block17: for (int idx = remappedSections.length - 1; idx >= 0; --idx) {
                    DataPalette blockPalette = remappedSections[idx].palette(PaletteType.BLOCKS);
                    if (blockPalette.size() == 1 && blockPalette.idByIndex(0) == 0) continue;
                    for (int y = 15; y >= 0; --y) {
                        int blockState = blockPalette.idAt(x, y, z);
                        if (blockState == 0) continue;
                        int value = idx * 16 + y + 1;
                        if (worldSurface[index] == Integer.MIN_VALUE) {
                            worldSurface[index] = value;
                        }
                        if (motionBlocking[index] != Integer.MIN_VALUE || !motionBlockingBlockStates.contains(blockState)) continue;
                        motionBlocking[index] = value;
                        break block17;
                    }
                }
                if (worldSurface[index] == Integer.MIN_VALUE) {
                    worldSurface[index] = this.minY;
                }
                if (motionBlocking[index] != Integer.MIN_VALUE) continue;
                motionBlocking[index] = this.minY;
            }
        }
        int bitsPerEntry = MathUtil.ceilLog2((int)(this.worldHeight + 1));
        remappedChunk.heightmaps()[0] = new Heightmap(HeightmapType.WORLD_SURFACE.ordinal(), CompactArrayUtil.createCompactArrayWithPadding((int)bitsPerEntry, (int)worldSurface.length, i -> worldSurface[i]));
        remappedChunk.heightmaps()[1] = new Heightmap(HeightmapType.MOTION_BLOCKING.ordinal(), CompactArrayUtil.createCompactArrayWithPadding((int)bitsPerEntry, (int)motionBlocking.length, i -> motionBlocking[i]));
        return remappedChunk;
    }

    private void resolvePersistentIds(BedrockChunkSection bedrockSection) {
        BlockStateRewriter blockStateRewriter = (BlockStateRewriter)this.user().get(BlockStateRewriter.class);
        List<DataPalette> palettes = bedrockSection.palettes(PaletteType.BLOCKS);
        for (DataPalette palette : palettes) {
            BedrockDataPalette bedrockPalette;
            if (!(palette instanceof BedrockDataPalette) || !(bedrockPalette = (BedrockDataPalette)palette).usesPersistentIds()) continue;
            bedrockPalette.addId(this.airId());
            bedrockPalette.resolvePersistentIds((Object2IntFunction<Tag>)((Object2IntFunction)tag -> {
                int remappedBlockState = blockStateRewriter.bedrockId((CompoundTag)tag);
                if (remappedBlockState == -1) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing block state: " + tag);
                    remappedBlockState = blockStateRewriter.bedrockId(BedrockBlockState.INFO_UPDATE);
                }
                return remappedBlockState;
            }));
        }
    }

    private void replaceLegacyBlocks(BedrockChunkSection bedrockSection) {
        BlockStateRewriter blockStateRewriter = (BlockStateRewriter)this.user().get(BlockStateRewriter.class);
        List<DataPalette> palettes = bedrockSection.palettes(PaletteType.BLOCKS);
        for (DataPalette palette : palettes) {
            if (!(palette instanceof BedrockBlockArray)) continue;
            BedrockBlockArray blockArray = (BedrockBlockArray)palette;
            BedrockDataPalette dataPalette = new BedrockDataPalette();
            this.transferPaletteData(blockArray, dataPalette);
            for (int i = 0; i < dataPalette.size(); ++i) {
                int blockState = dataPalette.idByIndex(i);
                int remappedBlockState = blockStateRewriter.bedrockId(blockState);
                if (remappedBlockState == -1) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing legacy block state: " + blockState);
                    remappedBlockState = this.airId();
                }
                dataPalette.setIdByIndex(i, remappedBlockState);
            }
            palettes.set(palettes.indexOf(palette), dataPalette);
        }
    }

    private void transferPaletteData(DataPalette source, DataPalette target) {
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    target.setIdAt(x, y, z, source.idAt(x, y, z));
                }
            }
        }
    }

    static {
        Arrays.fill(FULL_LIGHT, (byte)-1);
    }

    private record SubChunkPosition(int chunkX, int subChunkY, int chunkZ) {
    }
}

