/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.entitydata;

import com.viaversion.viaversion.api.minecraft.entitydata.EntityDataType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.DataItemType;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public enum EntityDataTypesBedrock implements EntityDataType
{
    BYTE(DataItemType.Byte, (Type<?>)Types.BYTE),
    SHORT(DataItemType.Short, BedrockTypes.SHORT_LE),
    INT(DataItemType.Int, BedrockTypes.VAR_INT),
    FLOAT(DataItemType.Float, BedrockTypes.FLOAT_LE),
    STRING(DataItemType.String, BedrockTypes.STRING),
    TAG(DataItemType.CompoundTag, BedrockTypes.NETWORK_TAG),
    POSITION_3I(DataItemType.Pos, BedrockTypes.POSITION_3I),
    LONG(DataItemType.Int64, BedrockTypes.VAR_LONG),
    POSITION_3F(DataItemType.Vec3, BedrockTypes.POSITION_3F);

    private final DataItemType dataItemType;
    private final Type<?> type;

    private EntityDataTypesBedrock(DataItemType dataItemType, Type<?> type) {
        this.dataItemType = dataItemType;
        this.type = type;
    }

    public static EntityDataTypesBedrock byDataItemType(DataItemType dataItemType) {
        return EntityDataTypesBedrock.values()[dataItemType.getValue()];
    }

    public DataItemType dataItemType() {
        return this.dataItemType;
    }

    public int typeId() {
        return this.dataItemType.getValue();
    }

    public Type<?> type() {
        return this.type;
    }
}

