/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.item;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.IntSortedSet;
import io.netty.buffer.ByteBuf;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class BedrockItemType
extends Type<BedrockItem> {
    private final int blockingId;
    private final Int2ObjectMap<IntSortedSet> blockItemValidBlockStates;
    private final boolean writeItemNetId;

    public BedrockItemType(int blockingId, Int2ObjectMap<IntSortedSet> blockItemValidBlockStates, boolean writeItemNetId) {
        super(BedrockItem.class);
        this.blockingId = blockingId;
        this.blockItemValidBlockStates = blockItemValidBlockStates;
        this.writeItemNetId = writeItemNetId;
    }

    public BedrockItem read(ByteBuf buffer) {
        int id = BedrockTypes.VAR_INT.read(buffer);
        if (id == 0 || id == -1) {
            return BedrockItem.empty();
        }
        BedrockItem item = new BedrockItem(id);
        item.setAmount(buffer.readUnsignedShortLE());
        item.setData(BedrockTypes.UNSIGNED_VAR_INT.read(buffer));
        if (buffer.readBoolean()) {
            item.setNetId(BedrockTypes.VAR_INT.read(buffer));
        }
        item.setBlockRuntimeId(BedrockTypes.VAR_INT.read(buffer));
        IntSortedSet validBlockStates = (IntSortedSet)this.blockItemValidBlockStates.get(item.identifier());
        if (validBlockStates != null) {
            item.setData(0);
            if (!validBlockStates.contains(item.blockRuntimeId())) {
                item.setBlockRuntimeId(validBlockStates.firstInt());
            }
        } else {
            item.setBlockRuntimeId(0);
        }
        ByteBuf userData = buffer.readSlice(BedrockTypes.UNSIGNED_VAR_INT.read(buffer).intValue());
        try {
            short marker = userData.readShortLE();
            if (marker == 0) {
                return item;
            }
            if (marker != -1) {
                throw new IllegalStateException("Expected -1 marker but got " + marker);
            }
            byte version = userData.readByte();
            if (version == 1) {
                item.setTag((CompoundTag)BedrockTypes.TAG_LE.read(userData));
                item.setCanPlace((String[])BedrockTypes.UTF8_STRING_ARRAY.read(userData));
                item.setCanBreak((String[])BedrockTypes.UTF8_STRING_ARRAY.read(userData));
                if (item.identifier() == this.blockingId) {
                    item.setBlockingTicks(userData.readLongLE());
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return item;
    }

    public void write(ByteBuf buffer, BedrockItem value) {
        if (value.isEmpty()) {
            BedrockTypes.VAR_INT.write(buffer, 0);
            return;
        }
        BedrockTypes.VAR_INT.write(buffer, value.identifier());
        buffer.writeShortLE(value.amount());
        BedrockTypes.UNSIGNED_VAR_INT.write(buffer, Integer.valueOf(value.data()));
        if (this.writeItemNetId) {
            buffer.writeBoolean(value.netId() != null);
            if (value.netId() != null) {
                BedrockTypes.VAR_INT.write(buffer, value.netId());
            }
        } else {
            buffer.writeBoolean(false);
        }
        BedrockTypes.VAR_INT.write(buffer, value.blockRuntimeId());
        ByteBuf userData = buffer.alloc().buffer();
        if (value.tag() != null) {
            userData.writeShortLE(-1);
            userData.writeByte(1);
            BedrockTypes.TAG_LE.write(userData, (Object)value.tag());
        } else {
            userData.writeShortLE(0);
        }
        BedrockTypes.UTF8_STRING_ARRAY.write(userData, (Object)value.canPlace());
        BedrockTypes.UTF8_STRING_ARRAY.write(userData, (Object)value.canBreak());
        if (value.identifier() == this.blockingId) {
            userData.writeLongLE(value.blockingTicks());
        }
        BedrockTypes.UNSIGNED_VAR_INT.write(buffer, userData.readableBytes());
        buffer.writeBytes(userData);
        userData.release();
    }
}

