/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.model;

import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.CommandOriginType;
import net.raphimc.viabedrock.protocol.model.CommandOriginData;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class CommandOriginDataType
extends Type<CommandOriginData> {
    public CommandOriginDataType() {
        super(CommandOriginData.class);
    }

    public CommandOriginData read(ByteBuf buffer) {
        CommandOriginType type = CommandOriginType.getByValue(BedrockTypes.UNSIGNED_VAR_INT.read(buffer), CommandOriginType.ExecuteContext);
        UUID uuid = (UUID)BedrockTypes.UUID.read(buffer);
        String requestId = (String)BedrockTypes.STRING.read(buffer);
        long event = -1L;
        if (type == CommandOriginType.DevConsole || type == CommandOriginType.Test) {
            event = BedrockTypes.VAR_LONG.read(buffer);
        }
        return new CommandOriginData(type, uuid, requestId, event);
    }

    public void write(ByteBuf buffer, CommandOriginData value) {
        BedrockTypes.UNSIGNED_VAR_INT.write(buffer, value.type().getValue());
        BedrockTypes.UUID.write(buffer, (Object)value.uuid());
        BedrockTypes.STRING.write(buffer, (Object)value.requestId());
        if (value.type() == CommandOriginType.DevConsole || value.type() == CommandOriginType.Test) {
            BedrockTypes.VAR_LONG.write(buffer, value.event());
        }
    }
}

