/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.model;

import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.raphimc.viabedrock.api.util.EnumUtil;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AbilitiesIndex;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.SerializedAbilitiesData_SerializedAbilitiesLayer;
import net.raphimc.viabedrock.protocol.model.PlayerAbilities;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class PlayerAbilitiesType
extends Type<PlayerAbilities> {
    public PlayerAbilitiesType() {
        super(PlayerAbilities.class);
    }

    public PlayerAbilities read(ByteBuf buffer) {
        long uniqueEntityId = buffer.readLongLE();
        byte playerPermission = buffer.readByte();
        byte commandPermission = buffer.readByte();
        int layerCount = BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(buffer);
        EnumMap<SerializedAbilitiesData_SerializedAbilitiesLayer, PlayerAbilities.AbilitiesLayer> abilityLayers = new EnumMap<SerializedAbilitiesData_SerializedAbilitiesLayer, PlayerAbilities.AbilitiesLayer>(SerializedAbilitiesData_SerializedAbilitiesLayer.class);
        for (int i = 0; i < layerCount; ++i) {
            SerializedAbilitiesData_SerializedAbilitiesLayer layer = SerializedAbilitiesData_SerializedAbilitiesLayer.getByValue(buffer.readUnsignedShortLE(), SerializedAbilitiesData_SerializedAbilitiesLayer.CustomCache);
            Set<AbilitiesIndex> abilitiesSet = EnumUtil.getEnumSetFromBitmask(AbilitiesIndex.class, buffer.readUnsignedIntLE(), AbilitiesIndex::getValue);
            Set<AbilitiesIndex> abilityValues = EnumUtil.getEnumSetFromBitmask(AbilitiesIndex.class, buffer.readUnsignedIntLE(), AbilitiesIndex::getValue);
            float flySpeed = buffer.readFloatLE();
            float verticalFlySpeed = buffer.readFloatLE();
            float walkSpeed = buffer.readFloatLE();
            if (abilityLayers.containsKey((Object)layer)) continue;
            abilityLayers.put(layer, new PlayerAbilities.AbilitiesLayer(abilitiesSet, abilityValues, walkSpeed, flySpeed, verticalFlySpeed));
        }
        return new PlayerAbilities(uniqueEntityId, playerPermission, commandPermission, abilityLayers);
    }

    public void write(ByteBuf buffer, PlayerAbilities value) {
        buffer.writeLongLE(value.uniqueEntityId());
        buffer.writeByte((int)value.playerPermission());
        buffer.writeByte((int)value.commandPermission());
        BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(buffer, value.abilityLayers().size());
        for (Map.Entry<SerializedAbilitiesData_SerializedAbilitiesLayer, PlayerAbilities.AbilitiesLayer> entry : value.abilityLayers().entrySet()) {
            buffer.writeShortLE(entry.getKey().getValue());
            buffer.writeIntLE(EnumUtil.getIntBitmaskFromEnumSet(entry.getValue().abilitiesSet(), AbilitiesIndex::getValue));
            buffer.writeIntLE(EnumUtil.getIntBitmaskFromEnumSet(entry.getValue().abilityValues(), AbilitiesIndex::getValue));
            buffer.writeFloatLE(entry.getValue().flySpeed());
            buffer.writeFloatLE(entry.getValue().verticalFlySpeed());
            buffer.writeFloatLE(entry.getValue().walkSpeed());
        }
    }
}

