/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.primitive;

import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.util.Pair;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class PackIdAndVersionType
extends Type<Pair<UUID, String>> {
    public PackIdAndVersionType() {
        super("PackID and Version", Pair.class);
    }

    public Pair<UUID, String> read(ByteBuf buffer) {
        UUID packUUID;
        String packIdAndVersion = (String)BedrockTypes.STRING.read(buffer);
        String[] packIdAndVersionSplit = packIdAndVersion.split("_", 2);
        String packId = packIdAndVersionSplit[0];
        String packVersion = packIdAndVersionSplit.length > 1 ? packIdAndVersionSplit[1] : null;
        try {
            packUUID = UUID.fromString(packId);
        }
        catch (IllegalArgumentException e) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Invalid pack UUID: " + packId, e);
            packUUID = new UUID(0L, 0L);
        }
        return new Pair((Object)packUUID, (Object)packVersion);
    }

    public void write(ByteBuf buffer, Pair<UUID, String> value) {
        BedrockTypes.STRING.write(buffer, (Object)(((UUID)value.key()).toString() + (String)(value.value() != null ? "_" + (String)value.value() : "")));
    }
}

