/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.chunk.blockstate;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.Tag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.raphimc.viabedrock.api.model.BedrockBlockState;
import net.raphimc.viabedrock.api.util.NbtUtil;

public class BlockStateSanitizer {
    private final Map<String, Map<String, Set<Object>>> allowedPropertyValues = new HashMap<String, Map<String, Set<Object>>>();

    public BlockStateSanitizer(List<BedrockBlockState> blockStates) {
        for (BedrockBlockState blockState : blockStates) {
            String identifier = blockState.blockStateTag().getStringTag("name").getValue();
            CompoundTag statesTag = blockState.blockStateTag().getCompoundTag("states");
            Map propertyValues = this.allowedPropertyValues.computeIfAbsent(identifier, k -> new HashMap());
            for (Map.Entry entry : statesTag.entrySet()) {
                propertyValues.computeIfAbsent((String)entry.getKey(), k -> new LinkedHashSet()).add(((Tag)entry.getValue()).getValue());
            }
        }
    }

    public void sanitize(CompoundTag tag) {
        String property;
        BedrockBlockState.sanitizeName(tag);
        String identifier = tag.getStringTag("name").getValue();
        Map<String, Set<Object>> propertyValues = this.allowedPropertyValues.get(identifier);
        if (propertyValues == null) {
            return;
        }
        CompoundTag statesTag = tag.getCompoundTag("states");
        if (statesTag == null) {
            if (propertyValues.isEmpty()) {
                return;
            }
            statesTag = new CompoundTag();
            tag.put("states", (Tag)statesTag);
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry entry : statesTag.entrySet()) {
            property = (String)entry.getKey();
            Set<Object> allowedValues = propertyValues.get(property);
            if (allowedValues == null) {
                toRemove.add(property);
                continue;
            }
            if (allowedValues.contains(((Tag)entry.getValue()).getValue())) continue;
            entry.setValue(NbtUtil.createTag(allowedValues.iterator().next()));
        }
        for (String string : toRemove) {
            statesTag.remove(string);
        }
        for (Map.Entry entry : propertyValues.entrySet()) {
            property = (String)entry.getKey();
            if (statesTag.contains(property)) continue;
            statesTag.put(property, NbtUtil.createTag(((Set)entry.getValue()).iterator().next()));
        }
    }
}

