/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.chunk.datapalette;

import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;

public class BedrockBiomeArray
implements DataPalette,
Cloneable {
    private byte[] biomes;

    public BedrockBiomeArray() {
        this.biomes = new byte[256];
    }

    public BedrockBiomeArray(byte[] biomes) {
        this.biomes = biomes;
    }

    public int index(int x, int y, int z) {
        return z << 4 | x;
    }

    public int idAt(int sectionCoordinate) {
        return this.biomes[sectionCoordinate] & 0xFF;
    }

    public void setIdAt(int sectionCoordinate, int id) {
        if (id > 255) {
            throw new IllegalArgumentException("Too large biome id: " + id);
        }
        this.biomes[sectionCoordinate] = (byte)id;
    }

    public int idByIndex(int index) {
        return this.idAt(index);
    }

    public void setIdByIndex(int index, int id) {
        this.setIdAt(index, id);
    }

    public int paletteIndexAt(int packedCoordinate) {
        throw new UnsupportedOperationException();
    }

    public void setPaletteIndexAt(int sectionCoordinate, int index) {
        throw new UnsupportedOperationException();
    }

    public void addId(int id) {
    }

    public void replaceId(int oldId, int newId) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.idAt(i) != oldId) continue;
            this.setIdAt(i, newId);
        }
    }

    public int size() {
        return this.biomes.length;
    }

    public void clear() {
        this.biomes = new byte[this.biomes.length];
    }

    public BedrockBiomeArray clone() {
        return new BedrockBiomeArray((byte[])this.biomes.clone());
    }
}

