/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.chunk.datapalette;

import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrayList;
import com.viaversion.viaversion.libs.fastutil.ints.IntList;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntFunction;
import java.util.List;
import net.raphimc.viabedrock.api.chunk.bitarray.BitArray;
import net.raphimc.viabedrock.api.chunk.bitarray.BitArrayVersion;

public class BedrockDataPalette
implements DataPalette,
Cloneable {
    private final IntList palette;
    private BitArray bitArray;
    private List<Tag> persistentPalette;

    public BedrockDataPalette() {
        this(BitArrayVersion.V2);
    }

    public BedrockDataPalette(BitArrayVersion version) {
        this.bitArray = version.createArray(4096);
        this.palette = new IntArrayList((int)version.getEntriesPerWord());
    }

    public BedrockDataPalette(IntList palette, BitArray bitArray) {
        this.palette = palette;
        this.bitArray = bitArray;
    }

    public BedrockDataPalette(List<Tag> persistentPalette, BitArray bitArray) {
        this.persistentPalette = persistentPalette;
        this.bitArray = bitArray;
        this.palette = new IntArrayList(persistentPalette.size());
    }

    public int index(int x, int y, int z) {
        return (x << 8) + (z << 4) + y;
    }

    public int idAt(int sectionCoordinate) {
        this.checkPersistentIds();
        return this.palette.getInt(this.bitArray.get(sectionCoordinate));
    }

    public void setIdAt(int sectionCoordinate, int id) {
        this.checkPersistentIds();
        int index = this.palette.indexOf(id);
        if (index == -1) {
            index = this.palette.size();
            this.addId(id);
        }
        this.bitArray.set(sectionCoordinate, index);
    }

    public int idByIndex(int index) {
        this.checkPersistentIds();
        return this.palette.getInt(index);
    }

    public void setIdByIndex(int index, int id) {
        this.checkPersistentIds();
        this.palette.set(index, id);
    }

    public int paletteIndexAt(int packedCoordinate) {
        return this.bitArray.get(packedCoordinate);
    }

    public void setPaletteIndexAt(int sectionCoordinate, int index) {
        this.bitArray.set(sectionCoordinate, index);
    }

    public void addId(int id) {
        BitArrayVersion nextVersion;
        this.palette.add(id);
        BitArrayVersion currentVersion = this.bitArray.getVersion();
        if (this.palette.size() >= currentVersion.getMaxEntryValue() && (nextVersion = currentVersion.getNext()) != null) {
            BitArray newBitArray = nextVersion.createArray(this.bitArray.size());
            for (int i = 0; i < this.bitArray.size(); ++i) {
                newBitArray.set(i, this.bitArray.get(i));
            }
            this.bitArray = newBitArray;
        }
    }

    public void replaceId(int oldId, int newId) {
        this.checkPersistentIds();
        int index = this.palette.indexOf(oldId);
        if (index == -1) {
            return;
        }
        for (int i = 0; i < this.palette.size(); ++i) {
            if (this.palette.getInt(i) != oldId) continue;
            this.palette.set(i, newId);
        }
    }

    public int size() {
        if (this.usesPersistentIds()) {
            return this.persistentPalette.size();
        }
        return this.palette.size();
    }

    public void clear() {
        if (this.usesPersistentIds()) {
            this.persistentPalette = null;
        }
        this.palette.clear();
    }

    public BedrockDataPalette clone() {
        return new BedrockDataPalette((IntList)new IntArrayList(this.palette), this.bitArray.clone());
    }

    public BitArray getBitArray() {
        return this.bitArray;
    }

    public boolean usesPersistentIds() {
        return this.persistentPalette != null;
    }

    public List<Tag> getPersistentPalette() {
        return this.persistentPalette;
    }

    public void resolvePersistentIds(Object2IntFunction<Tag> persistentToRuntimeId) {
        if (this.usesPersistentIds()) {
            this.palette.clear();
            for (Tag tag : this.persistentPalette) {
                this.palette.add(persistentToRuntimeId.getInt((Object)tag));
            }
            this.persistentPalette = null;
        }
    }

    private void checkPersistentIds() {
        if (this.usesPersistentIds()) {
            throw new IllegalStateException("Palette uses persistent ids");
        }
    }
}

