/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.container;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.libs.mcstructs.text.TextComponent;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ContainerType;
import net.raphimc.viabedrock.protocol.data.enums.java.ClickType;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.rewriter.ItemRewriter;

public abstract class Container {
    protected final UserConnection user;
    protected final byte containerId;
    protected final ContainerType type;
    protected final TextComponent title;
    protected final BlockPosition position;
    protected final BedrockItem[] items;
    protected final Set<String> validBlockTags;

    public Container(UserConnection user, byte containerId, ContainerType type, TextComponent title, BlockPosition position, int size, String ... validBlockTags) {
        this.user = user;
        this.containerId = containerId;
        this.type = type;
        this.title = title;
        this.position = position;
        this.items = BedrockItem.emptyArray(size);
        this.validBlockTags = Set.of(validBlockTags);
    }

    protected Container(UserConnection user, byte containerId, ContainerType type, TextComponent title, BlockPosition position, BedrockItem[] items, Set<String> validBlockTags) {
        this.user = user;
        this.containerId = containerId;
        this.type = type;
        this.title = title;
        this.position = position;
        this.items = items;
        this.validBlockTags = validBlockTags;
    }

    public boolean handleClick(int revision, short slot, byte button, ClickType action) {
        return false;
    }

    public void clearItems() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = BedrockItem.empty();
        }
    }

    public Item getJavaItem(int slot) {
        return ((ItemRewriter)this.user.get(ItemRewriter.class)).javaItem(this.getItem(slot));
    }

    public Item[] getJavaItems() {
        return ((ItemRewriter)this.user.get(ItemRewriter.class)).javaItems(this.items);
    }

    public BedrockItem getItem(int slot) {
        return this.items[slot];
    }

    public BedrockItem[] getItems() {
        return Arrays.copyOf(this.items, this.items.length);
    }

    public boolean setItem(int slot, BedrockItem item) {
        if (slot < 0 || slot >= this.items.length) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Tried to set item for " + this.type + ", but slot was out of bounds (" + slot + ")");
            return false;
        }
        BedrockItem oldItem = this.items[slot];
        this.items[slot] = item;
        this.onSlotChanged(slot, oldItem, item);
        return true;
    }

    public boolean setItems(BedrockItem[] items) {
        if (items.length != this.items.length) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Tried to set items for " + this.type + ", but items array length was not correct (" + items.length + " != " + this.items.length + ")");
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            this.setItem(i, items[i]);
        }
        return true;
    }

    public int javaSlot(int slot) {
        return slot;
    }

    public byte javaContainerId() {
        return this.containerId();
    }

    public int size() {
        return this.items.length;
    }

    public byte containerId() {
        return this.containerId;
    }

    public ContainerType type() {
        return this.type;
    }

    public TextComponent title() {
        return this.title;
    }

    public BlockPosition position() {
        return this.position;
    }

    public boolean isValidBlockTag(String tag) {
        if (tag == null) {
            return false;
        }
        return this.validBlockTags.contains(tag);
    }

    protected void onSlotChanged(int slot, BedrockItem oldItem, BedrockItem newItem) {
    }
}

