/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.container.dynamic;

import com.viaversion.nbt.tag.IntTag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.util.Pair;
import net.raphimc.viabedrock.api.model.container.Container;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ContainerID;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ContainerType;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.model.FullContainerName;
import net.raphimc.viabedrock.protocol.rewriter.ItemRewriter;
import net.raphimc.viabedrock.protocol.storage.InventoryTracker;

public class BundleContainer
extends Container {
    private final FullContainerName containerName;

    public BundleContainer(UserConnection user, FullContainerName containerName) {
        super(user, (byte)ContainerID.CONTAINER_ID_REGISTRY.getValue(), ContainerType.NONE, null, null, 64, new String[0]);
        this.containerName = containerName;
    }

    @Override
    public Item getJavaItem(int slot) {
        Pair<Container, Integer> holdingContainer = this.findHoldingContainer();
        if (holdingContainer == null) {
            throw new IllegalStateException("Could not find bundle in any container");
        }
        return ((Container)holdingContainer.key()).getJavaItem((Integer)holdingContainer.value());
    }

    @Override
    public Item[] getJavaItems() {
        Pair<Container, Integer> holdingContainer = this.findHoldingContainer();
        if (holdingContainer == null) {
            throw new IllegalStateException("Could not find bundle in any container");
        }
        return ((Container)holdingContainer.key()).getJavaItems();
    }

    @Override
    public boolean setItem(int slot, BedrockItem item) {
        return super.setItem(slot, item) && this.findHoldingContainer() != null;
    }

    @Override
    public boolean setItems(BedrockItem[] items) {
        if (items.length != this.size()) {
            BedrockItem[] newItems = this.getItems();
            System.arraycopy(items, 0, newItems, 0, Math.min(items.length, newItems.length));
            items = newItems;
        }
        return super.setItems(items) && this.findHoldingContainer() != null;
    }

    @Override
    public int javaSlot(int slot) {
        Pair<Container, Integer> holdingContainer = this.findHoldingContainer();
        if (holdingContainer == null) {
            throw new IllegalStateException("Could not find bundle in any container");
        }
        return ((Container)holdingContainer.key()).javaSlot((Integer)holdingContainer.value());
    }

    @Override
    public byte javaContainerId() {
        Pair<Container, Integer> holdingContainer = this.findHoldingContainer();
        if (holdingContainer == null) {
            throw new IllegalStateException("Could not find bundle in any container");
        }
        return ((Container)holdingContainer.key()).javaContainerId();
    }

    public Item[] getJavaBundleItems() {
        return super.getJavaItems();
    }

    private Pair<Container, Integer> findHoldingContainer() {
        InventoryTracker inventoryTracker = (InventoryTracker)this.user.get(InventoryTracker.class);
        int slot = this.findBundleInContainer(inventoryTracker.getInventoryContainer());
        if (slot != -1) {
            return new Pair((Object)inventoryTracker.getInventoryContainer(), (Object)slot);
        }
        slot = this.findBundleInContainer(inventoryTracker.getCurrentContainer());
        if (slot != -1) {
            return new Pair((Object)inventoryTracker.getCurrentContainer(), (Object)slot);
        }
        slot = this.findBundleInContainer(inventoryTracker.getOffhandContainer());
        if (slot != -1) {
            return new Pair((Object)inventoryTracker.getOffhandContainer(), (Object)slot);
        }
        slot = this.findBundleInContainer(inventoryTracker.getArmorContainer());
        if (slot != -1) {
            return new Pair((Object)inventoryTracker.getArmorContainer(), (Object)slot);
        }
        slot = this.findBundleInContainer(inventoryTracker.getHudContainer());
        if (slot != -1) {
            return new Pair((Object)inventoryTracker.getHudContainer(), (Object)slot);
        }
        return null;
    }

    private int findBundleInContainer(Container container) {
        if (container == null) {
            return -1;
        }
        ItemRewriter itemRewriter = (ItemRewriter)this.user.get(ItemRewriter.class);
        BedrockItem[] items = container.getItems();
        for (int i = 0; i < items.length; ++i) {
            IntTag bundleIdTag;
            String itemTag;
            BedrockItem item = items[i];
            if (item.isEmpty() || item.tag() == null || !(itemTag = BedrockProtocol.MAPPINGS.getBedrockItemTags().getOrDefault(itemRewriter.getItems().inverse().get((Object)item.identifier()), "")).equals("bundle") || (bundleIdTag = item.tag().getIntTag("bundle_id")) == null || bundleIdTag.asInt() == 0 || bundleIdTag.asInt() != this.containerName.dynamicId().intValue()) continue;
            return i;
        }
        return -1;
    }
}

