/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.entity;

import com.google.common.collect.BiMap;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_21_6;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityData;
import com.viaversion.viaversion.api.minecraft.entitydata.types.EntityDataTypes1_21_5;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.Entity;
import net.raphimc.viabedrock.api.model.entity.PlayerEntity;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AbilitiesIndex;
import net.raphimc.viabedrock.protocol.model.EntityAttribute;
import net.raphimc.viabedrock.protocol.model.EntityEffect;

public class LivingEntity
extends Entity {
    protected final Map<String, EntityAttribute> attributes = new HashMap<String, EntityAttribute>();
    protected final Map<String, EntityEffect> effects = new HashMap<String, EntityEffect>();

    public LivingEntity(UserConnection user, long uniqueId, long runtimeId, String type, int javaId, UUID javaUuid, EntityTypes1_21_6 javaType) {
        super(user, uniqueId, runtimeId, type, javaId, javaUuid, javaType);
        this.attributes.put("minecraft:health", new EntityAttribute("minecraft:health", 20.0f, 0.0f, 20.0f));
    }

    @Override
    public void tick() {
        super.tick();
        HashSet<String> effectsToRemove = new HashSet<String>();
        for (EntityEffect effect : this.effects.values()) {
            if (effect.duration().get() == -1 || effect.duration().decrementAndGet() > 0) continue;
            effectsToRemove.add(effect.identifier());
        }
        for (String identifier : effectsToRemove) {
            PacketWrapper removeMobEffect = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.REMOVE_MOB_EFFECT, (UserConnection)this.user);
            this.removeEffect(identifier, removeMobEffect);
            removeMobEffect.send(BedrockProtocol.class);
        }
    }

    public final void sendAttribute(String name) {
        EntityAttribute attribute = this.attributes.get(name);
        if (attribute != null) {
            this.updateAttributes(new EntityAttribute[]{attribute});
        }
    }

    public final void updateAttributes(EntityAttribute[] attributes) {
        PacketWrapper updateAttributes = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.UPDATE_ATTRIBUTES, (UserConnection)this.user);
        this.updateAttributes(attributes, updateAttributes);
        updateAttributes.send(BedrockProtocol.class);
    }

    public final void updateAttributes(EntityAttribute[] attributes, PacketWrapper javaAttributes) {
        javaAttributes.write((Type)Types.VAR_INT, (Object)this.javaId);
        javaAttributes.write((Type)Types.VAR_INT, (Object)0);
        AtomicInteger attributeCount = new AtomicInteger(0);
        ArrayList<EntityData> javaEntityData = new ArrayList<EntityData>();
        for (EntityAttribute attribute : attributes) {
            PlayerEntity player;
            LivingEntity livingEntity;
            if (attribute.name().equals("minecraft:health") && (livingEntity = this) instanceof PlayerEntity && (player = (PlayerEntity)livingEntity).abilities().getBooleanValue(AbilitiesIndex.Invulnerable)) {
                EntityAttribute oldAttribute = this.attributes.get(attribute.name());
                if (attribute.computeClampedValue() <= oldAttribute.computeClampedValue()) continue;
            }
            this.attributes.put(attribute.name(), attribute);
            if (this.translateAttribute(attribute, javaAttributes, attributeCount, javaEntityData)) continue;
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received unknown entity attribute: " + attribute.name() + " for entity type: " + this.javaType());
        }
        if (attributeCount.get() > 0) {
            javaAttributes.set((Type)Types.VAR_INT, 1, (Object)attributeCount.get());
        }
        if (!javaEntityData.isEmpty()) {
            PacketWrapper setEntityData = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.SET_ENTITY_DATA, (UserConnection)this.user);
            setEntityData.write((Type)Types.VAR_INT, (Object)this.javaId);
            setEntityData.write(VersionedTypes.V1_21_6.entityDataList, javaEntityData);
            setEntityData.send(BedrockProtocol.class);
        }
    }

    public final void sendEffects() {
        for (EntityEffect effect : this.effects.values()) {
            PacketWrapper updateMobEffect = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.UPDATE_MOB_EFFECT, (UserConnection)this.user);
            this.updateEffect(effect, updateMobEffect);
            updateMobEffect.send(BedrockProtocol.class);
        }
    }

    public final void updateEffect(EntityEffect effect, PacketWrapper javaEffect) {
        this.effects.put(effect.identifier(), effect);
        javaEffect.write((Type)Types.VAR_INT, (Object)this.javaId);
        javaEffect.write((Type)Types.VAR_INT, (Object)((Integer)BedrockProtocol.MAPPINGS.getJavaEffects().get((Object)BedrockProtocol.MAPPINGS.getBedrockToJavaEffects().get(effect.identifier()))));
        javaEffect.write((Type)Types.VAR_INT, (Object)effect.amplifier());
        javaEffect.write((Type)Types.VAR_INT, (Object)(effect.duration().get() != -1 ? Math.max(effect.duration().get(), 0) : -1));
        javaEffect.write((Type)Types.BYTE, (Object)((byte)(effect.showParticles() ? 2 : 0)));
    }

    public final void removeEffect(String identifier, PacketWrapper javaEffect) {
        this.effects.remove(identifier);
        javaEffect.write((Type)Types.VAR_INT, (Object)this.javaId);
        javaEffect.write((Type)Types.VAR_INT, (Object)((Integer)BedrockProtocol.MAPPINGS.getJavaEffects().get((Object)BedrockProtocol.MAPPINGS.getBedrockToJavaEffects().get(identifier))));
    }

    public final void clearEffects() {
        this.effects.clear();
    }

    public boolean isDead() {
        return this.attributes.get("minecraft:health").computeClampedValue() <= 0.0f;
    }

    public void setHealth(float health) {
        this.attributes.put("minecraft:health", this.attributes.get("minecraft:health").withValue(health));
    }

    public Map<String, EntityAttribute> attributes() {
        return this.attributes;
    }

    public Map<String, EntityEffect> effects() {
        return this.effects;
    }

    protected boolean translateAttribute(EntityAttribute attribute, PacketWrapper javaAttributes, AtomicInteger attributeCount, List<EntityData> javaEntityData) {
        return switch (attribute.name()) {
            case "minecraft:attack_damage", "minecraft:knockback_resistance", "minecraft:movement" -> {
                BiMap<String, Integer> v0 = BedrockProtocol.MAPPINGS.getJavaEntityAttributes();
                String v1 = switch (attribute.name()) {
                    case "minecraft:attack_damage" -> "minecraft:attack_damage";
                    case "minecraft:knockback_resistance" -> "minecraft:knockback_resistance";
                    case "minecraft:movement" -> "minecraft:movement_speed";
                    default -> throw new IllegalStateException("Unhandled entity attribute: " + attribute.name());
                };
                javaAttributes.write((Type)Types.VAR_INT, (Object)((Integer)v0.get((Object)v1)));
                javaAttributes.write((Type)Types.DOUBLE, (Object)attribute.computeClampedValue());
                javaAttributes.write((Type)Types.VAR_INT, (Object)0);
                attributeCount.incrementAndGet();
                yield true;
            }
            case "minecraft:health" -> {
                javaEntityData.add(new EntityData(this.getJavaEntityDataIndex("HEALTH"), ((EntityDataTypes1_21_5)VersionedTypes.V1_21_6.entityDataTypes).floatType, (Object)Float.valueOf(attribute.computeClampedValue())));
                javaAttributes.write((Type)Types.VAR_INT, (Object)((Integer)BedrockProtocol.MAPPINGS.getJavaEntityAttributes().get((Object)"minecraft:max_health")));
                javaAttributes.write((Type)Types.DOUBLE, (Object)attribute.maxValue());
                javaAttributes.write((Type)Types.VAR_INT, (Object)0);
                attributeCount.incrementAndGet();
                yield true;
            }
            case "minecraft:absorption", "minecraft:follow_range", "minecraft:luck" -> true;
            case "minecraft:lava_movement", "minecraft:underwater_movement" -> true;
            default -> false;
        };
    }
}

