/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.resourcepack;

import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.util.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class BiomeDefinitions {
    private final Map<String, BiomeDefinition> biomes = new HashMap<String, BiomeDefinition>();

    public BiomeDefinitions(ResourcePacksStorage resourcePacksStorage) {
        for (ResourcePack pack : resourcePacksStorage.getPackStackBottomToTop()) {
            for (String biomePath : pack.content().getFilesDeep("biomes/", ".json")) {
                try {
                    JsonObject biome = pack.content().getJson(biomePath).getAsJsonObject("minecraft:client_biome");
                    String name = biome.getAsJsonObject("description").get("identifier").getAsString();
                    BiomeDefinition biomeDefinition = new BiomeDefinition(name);
                    if (biome.has("components")) {
                        JsonObject components = biome.getAsJsonObject("components");
                        if (components.has("minecraft:sky_color")) {
                            biomeDefinition.skyColor = Integer.parseInt(components.getAsJsonObject("minecraft:sky_color").get("sky_color").getAsString().substring(1, 7), 16);
                        }
                        if (components.has("minecraft:water_appearance")) {
                            biomeDefinition.waterSurfaceColor = Integer.parseInt(components.getAsJsonObject("minecraft:water_appearance").get("surface_color").getAsString().substring(1, 7), 16);
                        }
                        if (components.has("minecraft:fog_appearance")) {
                            biomeDefinition.fog = Key.namespaced((String)components.getAsJsonObject("minecraft:fog_appearance").get("fog_identifier").getAsString());
                        }
                    }
                    this.biomes.put(name, biomeDefinition);
                }
                catch (Throwable e) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to parse biome definition " + biomePath + " in pack " + pack.packId(), e);
                }
            }
        }
    }

    public BiomeDefinition get(String name) {
        return this.biomes.get(name);
    }

    public Map<String, BiomeDefinition> biomes() {
        return Collections.unmodifiableMap(this.biomes);
    }

    public static class BiomeDefinition {
        private final String name;
        private Integer skyColor;
        private Integer waterSurfaceColor;
        private String fog;

        public BiomeDefinition(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public Integer skyColor() {
            return this.skyColor;
        }

        public Integer waterSurfaceColor() {
            return this.waterSurfaceColor;
        }

        public String fog() {
            return this.fog;
        }
    }
}

