/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.resourcepack;

import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.util.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class FogDefinitions {
    private final Map<String, FogDefinition> fogs = new HashMap<String, FogDefinition>();

    public FogDefinitions(ResourcePacksStorage resourcePacksStorage) {
        for (ResourcePack pack : resourcePacksStorage.getPackStackBottomToTop()) {
            for (String fogPath : pack.content().getFilesDeep("fogs/", ".json")) {
                try {
                    JsonObject fog = pack.content().getJson(fogPath).getAsJsonObject("minecraft:fog_settings");
                    String identifier = Key.namespaced((String)fog.getAsJsonObject("description").get("identifier").getAsString());
                    HashMap<String, Integer> colors = new HashMap<String, Integer>();
                    JsonObject distance = fog.getAsJsonObject("distance");
                    for (Map.Entry entry : distance.entrySet()) {
                        JsonObject value = ((JsonElement)entry.getValue()).getAsJsonObject();
                        if (!value.has("fog_color")) continue;
                        colors.put((String)entry.getKey(), Integer.parseInt(value.get("fog_color").getAsString().substring(1), 16));
                    }
                    this.fogs.put(identifier, new FogDefinition(identifier, colors));
                }
                catch (Throwable e) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to parse fog definition " + fogPath + " in pack " + pack.packId(), e);
                }
            }
        }
    }

    public FogDefinition get(String identifier) {
        return this.fogs.get(identifier);
    }

    public record FogDefinition(String identifier, Map<String, Integer> colors) {
    }
}

