/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.resourcepack;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.util.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class ItemDefinitions {
    private final Map<String, ItemDefinition> items = new HashMap<String, ItemDefinition>();

    public ItemDefinitions(ResourcePacksStorage resourcePacksStorage) {
        for (ResourcePack pack : resourcePacksStorage.getPackStackBottomToTop()) {
            for (String itemPath : pack.content().getFilesDeep("items/", ".json")) {
                try {
                    JsonObject item = pack.content().getJson(itemPath).getAsJsonObject("minecraft:item");
                    String identifier = Key.namespaced((String)item.getAsJsonObject("description").get("identifier").getAsString());
                    ItemDefinition itemDefinition = new ItemDefinition(identifier);
                    if (item.has("components")) {
                        JsonObject components = item.getAsJsonObject("components");
                        if (components.has("minecraft:icon")) {
                            itemDefinition.iconComponent = components.get("minecraft:icon").getAsString();
                        }
                        if (components.has("minecraft:display_name")) {
                            itemDefinition.displayNameComponent = components.get("minecraft:display_name").getAsString();
                        }
                    }
                    this.items.put(identifier, itemDefinition);
                }
                catch (Throwable e) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to parse item definition " + itemPath + " in pack " + pack.packId(), e);
                }
            }
        }
    }

    public void addFromNetworkTag(String identifier, CompoundTag tag) {
        ItemDefinition itemDefinition = new ItemDefinition(identifier);
        Tag tag2 = tag.get("components");
        if (tag2 instanceof CompoundTag) {
            CompoundTag displayName;
            CompoundTag texture;
            Tag tag3;
            Tag icon;
            Tag tag4;
            CompoundTag itemProperties;
            Tag tag5;
            CompoundTag components = (CompoundTag)tag2;
            Tag tag6 = components.get("item_properties");
            if (tag6 instanceof CompoundTag && (tag5 = (itemProperties = (CompoundTag)tag6).get("minecraft:icon")) instanceof CompoundTag && (tag4 = (icon = (CompoundTag)tag5).get("textures")) instanceof CompoundTag && (tag3 = (texture = (CompoundTag)tag4).get("default")) instanceof StringTag) {
                StringTag defaultTexture = (StringTag)tag3;
                itemDefinition.iconComponent = defaultTexture.getValue();
            }
            if ((icon = components.get("minecraft:display_name")) instanceof CompoundTag && (tag5 = (displayName = (CompoundTag)icon).get("value")) instanceof StringTag) {
                StringTag value = (StringTag)tag5;
                itemDefinition.displayNameComponent = value.getValue();
            }
        }
        this.items.put(identifier, itemDefinition);
    }

    public ItemDefinition get(String identifier) {
        return this.items.get(identifier);
    }

    public void remove(String identifier) {
        this.items.remove(identifier);
    }

    public static class ItemDefinition {
        private final String identifier;
        private String iconComponent;
        private String displayNameComponent;

        public ItemDefinition(String identifier) {
            this.identifier = identifier;
        }

        public String identifier() {
            return this.identifier;
        }

        public String iconComponent() {
            return this.iconComponent;
        }

        public String displayNameComponent() {
            return this.displayNameComponent;
        }
    }
}

