/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.resourcepack;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import org.cube.converter.model.impl.bedrock.BedrockGeometryModel;
import org.cube.converter.parser.bedrock.geometry.BedrockGeometryParser;

public class ModelDefinitions {
    private final Map<String, BedrockGeometryModel> entityModels = new HashMap<String, BedrockGeometryModel>();

    public ModelDefinitions(ResourcePacksStorage resourcePacksStorage) {
        for (ResourcePack pack : resourcePacksStorage.getPackStackBottomToTop()) {
            for (String modelPath : pack.content().getFilesDeep("models/", ".json")) {
                try {
                    for (BedrockGeometryModel bedrockGeometry : BedrockGeometryParser.parse((String)pack.content().getString(modelPath))) {
                        if (!modelPath.startsWith("models/entity/")) continue;
                        this.entityModels.put(bedrockGeometry.getIdentifier(), bedrockGeometry);
                    }
                }
                catch (Throwable e) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to parse model definition " + modelPath + " in pack " + pack.packId(), e);
                }
            }
        }
    }

    public BedrockGeometryModel getEntityModel(String name) {
        return this.entityModels.get(name);
    }

    public Map<String, BedrockGeometryModel> entityModels() {
        return Collections.unmodifiableMap(this.entityModels);
    }
}

