/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.resourcepack;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import org.cube.converter.data.bedrock.controller.BedrockRenderController;
import org.cube.converter.parser.bedrock.controller.BedrockControllerParser;

public class RenderControllerDefinitions {
    private final Map<String, BedrockRenderController> renderControllers = new HashMap<String, BedrockRenderController>();

    public RenderControllerDefinitions(ResourcePacksStorage resourcePacksStorage) {
        for (ResourcePack pack : resourcePacksStorage.getPackStackBottomToTop()) {
            for (String controllerPath : pack.content().getFilesDeep("render_controllers/", ".json")) {
                try {
                    for (BedrockRenderController bedrockRenderController : BedrockControllerParser.parse((String)pack.content().getString(controllerPath))) {
                        this.renderControllers.put(bedrockRenderController.identifier(), bedrockRenderController);
                    }
                }
                catch (Throwable e) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to parse render controller " + controllerPath + " in pack " + pack.packId(), e);
                }
            }
        }
    }

    public BedrockRenderController get(String name) {
        return this.renderControllers.get(name);
    }

    public Map<String, BedrockRenderController> renderControllers() {
        return Collections.unmodifiableMap(this.renderControllers);
    }
}

