/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.resourcepack;

import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.util.GsonUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.imageio.ImageIO;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.util.JsonUtil;
import net.raphimc.viabedrock.api.util.MathUtil;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.PackType;

public class ResourcePack {
    private static final byte[] CONTENTS_JSON_ENCRYPTED_MAGIC = new byte[]{-4, -71, -49, -101};
    private UUID packId;
    private String version;
    private byte[] contentKey;
    private final String subPackName;
    private final String contentId;
    private final boolean hasScripts;
    private final boolean isAddonPack;
    private final boolean raytracingCapable;
    private byte[] hash;
    private boolean premium;
    private PackType type;
    private URL cdnUrl;
    private int maxChunkSize;
    private boolean[] receivedChunks;
    private byte[] compressedData;
    private Content content;

    public ResourcePack(UUID packId, String version, byte[] contentKey, String subPackName, String contentId, boolean hasScripts, boolean isAddonPack, boolean raytracingCapable, URL cdnUrl, long compressedSize, PackType type) {
        this.packId = packId;
        this.version = version;
        this.contentKey = contentKey;
        this.subPackName = subPackName;
        this.contentId = contentId;
        this.hasScripts = hasScripts;
        this.isAddonPack = isAddonPack;
        this.raytracingCapable = raytracingCapable;
        this.cdnUrl = cdnUrl;
        this.compressedData = new byte[(int)compressedSize];
        this.type = type;
    }

    public boolean processDataChunk(int chunkIndex, byte[] data) throws NoSuchAlgorithmException, IOException, InvalidAlgorithmParameterException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (this.receivedChunks[chunkIndex]) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received duplicate resource pack chunk data: " + this.packId);
            return false;
        }
        int offset = chunkIndex * this.maxChunkSize;
        if (offset + data.length > this.compressedData.length) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received resource pack chunk data with invalid offset: " + this.packId);
            return false;
        }
        System.arraycopy(data, 0, this.compressedData, offset, data.length);
        this.receivedChunks[chunkIndex] = true;
        if (this.hasReceivedAllChunks()) {
            this.decompressAndDecrypt();
            return true;
        }
        return false;
    }

    public boolean isDecompressed() {
        return this.compressedData == null;
    }

    public UUID packId() {
        return this.packId;
    }

    public String version() {
        return this.version;
    }

    public byte[] contentKey() {
        return this.contentKey;
    }

    public void setContentKey(byte[] contentKey) {
        this.contentKey = contentKey;
    }

    public String subPackName() {
        return this.subPackName;
    }

    public String contentId() {
        return this.contentId;
    }

    public boolean hasScripts() {
        return this.hasScripts;
    }

    public boolean isAddonPack() {
        return this.isAddonPack;
    }

    public boolean raytracingCapable() {
        return this.raytracingCapable;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public boolean premium() {
        return this.premium;
    }

    public void setPremium(boolean premium) {
        this.premium = premium;
    }

    public PackType type() {
        return this.type;
    }

    public void setType(PackType type) {
        this.type = type;
    }

    public URL cdnUrl() {
        return this.cdnUrl;
    }

    public void setCdnUrl(URL cdnUrl) {
        this.cdnUrl = cdnUrl;
    }

    public int compressedDataLength() {
        if (this.compressedData == null) {
            return 0;
        }
        return this.compressedData.length;
    }

    public void setCompressedDataLength(int length, int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        this.receivedChunks = new boolean[MathUtil.ceil((float)length / (float)maxChunkSize)];
        this.compressedData = new byte[length];
    }

    public Content content() {
        if (!this.isDecompressed()) {
            throw new IllegalStateException("Pack is not decompressed");
        }
        return this.content;
    }

    private void decompressAndDecrypt() throws NoSuchAlgorithmException, IOException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        JsonObject manifestJson;
        int formatVersion;
        Object key;
        MessageDigest sha256;
        byte[] hash;
        if (this.hash != null && !Arrays.equals(hash = (sha256 = MessageDigest.getInstance("SHA-256")).digest(this.compressedData), this.hash)) {
            throw new IllegalStateException("Resource pack hash mismatch: " + this.packId);
        }
        this.content = new Content(this.compressedData);
        this.compressedData = null;
        if (!this.content.contains("manifest.json") && !this.content.contains("pack_manifest.json") && this.cdnUrl != null && this.content.size() == 1 && ((String)(key = this.content.content.keySet().iterator().next())).endsWith(".zip")) {
            this.content = new Content(this.content.get((String)key));
        }
        if (!this.content.contains("manifest.json") && !this.content.contains("pack_manifest.json")) {
            for (String path : new HashSet<String>(this.content.content.keySet())) {
                if (!path.contains("/")) continue;
                this.content.put(path.substring(path.indexOf(47) + 1), this.content.content.remove(path));
            }
        }
        if (!this.content.contains("manifest.json") && !this.content.contains("pack_manifest.json")) {
            throw new IllegalStateException("Missing manifest.json in resource pack: " + this.packId);
        }
        if (this.contentKey.length != 0) {
            if (!this.content.contains("contents.json")) {
                throw new IllegalStateException("Missing contents.json in resource pack: " + this.packId);
            }
            Cipher aesCfb8 = Cipher.getInstance("AES/CFB8/NoPadding");
            aesCfb8.init(2, (Key)new SecretKeySpec(this.contentKey, "AES"), new IvParameterSpec(Arrays.copyOfRange(this.contentKey, 0, 16)));
            ByteBuf contents = Unpooled.wrappedBuffer((byte[])this.content.get("contents.json"));
            contents.skipBytes(4);
            byte[] magic = new byte[4];
            contents.readBytes(magic);
            if (!Arrays.equals(magic, CONTENTS_JSON_ENCRYPTED_MAGIC)) {
                throw new IllegalStateException("contents.json magic mismatch: " + Arrays.toString(CONTENTS_JSON_ENCRYPTED_MAGIC) + " != " + Arrays.toString(magic));
            }
            contents.readerIndex(16);
            short contentIdLength = contents.readUnsignedByte();
            byte[] contentIdBytes = new byte[contentIdLength];
            contents.readBytes(contentIdBytes);
            String contentId = new String(contentIdBytes, StandardCharsets.UTF_8);
            if (!this.contentId.equalsIgnoreCase(contentId)) {
                throw new IllegalStateException("contents.json contentId mismatch: " + this.contentId + " != " + contentId);
            }
            contents.readerIndex(256);
            byte[] encryptedContents = new byte[contents.readableBytes()];
            contents.readBytes(encryptedContents);
            this.content.put("contents.json", aesCfb8.doFinal(encryptedContents));
            JsonObject contentsJson = this.content.getJson("contents.json");
            JsonArray contentArray = contentsJson.getAsJsonArray("content");
            block10: for (JsonElement element : contentArray) {
                JsonObject contentItem = element.getAsJsonObject();
                if (!contentItem.has("key") || contentItem.get("key").isJsonNull()) continue;
                String key2 = contentItem.get("key").getAsString();
                String path = contentItem.get("path").getAsString();
                if (!this.content.contains(path)) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing resource pack file: " + path);
                    continue;
                }
                switch (path) {
                    case "manifest.json": 
                    case "pack_manifest.json": 
                    case "pack_icon.png": 
                    case "README.txt": {
                        continue block10;
                    }
                }
                byte[] encryptedData = this.content.get(path);
                byte[] keyBytes = key2.getBytes(StandardCharsets.ISO_8859_1);
                aesCfb8.init(2, (Key)new SecretKeySpec(keyBytes, "AES"), new IvParameterSpec(Arrays.copyOfRange(keyBytes, 0, 16)));
                this.content.put(path, aesCfb8.doFinal(encryptedData));
            }
        }
        if ((formatVersion = (manifestJson = this.content.contains("manifest.json") ? this.content.getJson("manifest.json") : this.content.getJson("pack_manifest.json")).get("format_version").getAsInt()) != 1 && formatVersion != 2) {
            throw new IllegalStateException("Unsupported resource pack format version: " + formatVersion);
        }
        JsonObject headerObj = manifestJson.getAsJsonObject("header");
        UUID packId = UUID.fromString(headerObj.get("uuid").getAsString());
        if (this.packId == null) {
            this.packId = packId;
        } else if (!this.packId.equals(packId)) {
            throw new IllegalStateException("manifest.json packId mismatch: " + this.packId + " != " + packId);
        }
        JsonArray versionArray = headerObj.getAsJsonArray("version");
        StringBuilder version = new StringBuilder();
        for (JsonElement digit : versionArray) {
            version.append(digit.getAsString()).append(".");
        }
        version.deleteCharAt(version.length() - 1);
        if (this.version == null) {
            this.version = version.toString();
        } else if (!this.version.contentEquals(version)) {
            throw new IllegalStateException("manifest.json version mismatch: " + this.version + " != " + version);
        }
    }

    private boolean hasReceivedAllChunks() {
        for (boolean receivedChunk : this.receivedChunks) {
            if (receivedChunk) continue;
            return false;
        }
        return true;
    }

    public static class Content {
        private final Map<String, byte[]> content;
        private final Map<String, Map<String, String>> langCache;

        public Content() {
            this(false);
        }

        public Content(boolean concurrent) {
            if (concurrent) {
                this.content = new ConcurrentHashMap<String, byte[]>();
                this.langCache = new ConcurrentHashMap<String, Map<String, String>>();
            } else {
                this.content = new HashMap<String, byte[]>();
                this.langCache = new HashMap<String, Map<String, String>>();
            }
        }

        public Content(byte[] zipData) throws IOException {
            this(false);
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(zipData));
            byte[] buf = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int len;
                if (zipEntry.isDirectory()) continue;
                while ((len = zipInputStream.read(buf)) > 0) {
                    baos.write(buf, 0, len);
                }
                this.content.put(zipEntry.getName(), baos.toByteArray());
                baos.reset();
            }
        }

        public List<String> getFilesShallow(String path, String extension) {
            return this.content.keySet().stream().filter(file -> file.startsWith(path) && !file.substring(path.length()).contains("/") && file.endsWith(extension)).collect(Collectors.toList());
        }

        public List<String> getFilesDeep(String path, String extension) {
            return this.content.keySet().stream().filter(file -> file.startsWith(path) && file.endsWith(extension)).collect(Collectors.toList());
        }

        public String getFullPath(String shortNamePath, String ... extensions) {
            if (this.contains(shortNamePath)) {
                return shortNamePath;
            }
            for (String extension : extensions) {
                String path = shortNamePath + "." + extension;
                if (!this.contains(path)) continue;
                return path;
            }
            return null;
        }

        public boolean contains(String path) {
            return this.content.containsKey(path);
        }

        public byte[] get(String path) {
            return this.content.get(path);
        }

        public boolean put(String path, byte[] data) {
            return this.content.put(path, data) != null;
        }

        public String getString(String path) {
            byte[] bytes = this.get(path);
            if (bytes == null) {
                return null;
            }
            return new String(bytes, StandardCharsets.UTF_8);
        }

        public boolean putString(String path, String string) {
            return this.put(path, string.getBytes(StandardCharsets.UTF_8));
        }

        public List<String> getLines(String path) {
            String string = this.getString(path);
            if (string == null) {
                return null;
            }
            return List.of(string.split("\\n"));
        }

        public boolean putLines(String path, List<String> lines) {
            return this.putString(path, String.join((CharSequence)"\\n", lines));
        }

        public Map<String, String> getLang(String path) {
            return this.langCache.computeIfAbsent(path, k -> {
                List<String> lines = this.getLines((String)k);
                return Collections.unmodifiableMap(lines.stream().filter(line -> !line.startsWith("##")).filter(line -> line.contains("=")).map(line -> line.contains("##") ? line.substring(0, line.indexOf("##")) : line).map(String::trim).map(line -> line.split("=", 2)).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1], (o, n) -> n)));
            });
        }

        public JsonObject getJson(String path) {
            String string = this.getString(path);
            if (string == null) {
                return null;
            }
            return (JsonObject)GsonUtil.getGson().fromJson(string.trim(), JsonObject.class);
        }

        public JsonObject getSortedJson(String path) {
            return JsonUtil.sort(this.getJson(path), Comparator.naturalOrder());
        }

        public boolean putJson(String path, JsonObject json) {
            return this.putString(path, GsonUtil.getGson().toJson((JsonElement)json));
        }

        public LazyImage getShortnameImage(String path) {
            return this.getImage(this.getFullPath(path, "png", "jpg"));
        }

        public LazyImage getImage(String path) {
            boolean isJpg;
            byte[] bytes = this.get(path);
            if (bytes == null) {
                return null;
            }
            boolean isPng = bytes.length > 8 && bytes[0] == -119 && bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71 && bytes[4] == 13 && bytes[5] == 10 && bytes[6] == 26 && bytes[7] == 10;
            boolean bl = isJpg = bytes.length > 2 && bytes[0] == -1 && bytes[1] == -40 && bytes[2] == -1;
            if (!isPng && !isJpg) {
                return null;
            }
            return new LazyImage(bytes, isPng ? "png" : "jpg");
        }

        public boolean putPngImage(String path, LazyImage image) {
            return this.put(path, image.getPngBytes());
        }

        public boolean putPngImage(String path, BufferedImage image) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)image, "png", baos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.put(path, baos.toByteArray());
        }

        public void copyFrom(Content content, String sourcePath, String targetPath) {
            this.put(targetPath, content.get(sourcePath));
        }

        public byte[] toZip() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x400000);
            ZipOutputStream zipOutputStream = new ZipOutputStream(baos);
            for (Map.Entry<String, byte[]> entry : this.content.entrySet()) {
                zipOutputStream.putNextEntry(new ZipEntry(entry.getKey()));
                zipOutputStream.write(entry.getValue());
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
            return baos.toByteArray();
        }

        public int size() {
            return this.content.size();
        }

        public static class LazyImage {
            private final byte[] bytes;
            private final String format;
            private BufferedImage image;

            public LazyImage(byte[] bytes, String format) {
                this.bytes = bytes;
                this.format = format;
            }

            public BufferedImage getImage() {
                if (this.image == null) {
                    try {
                        this.image = ImageIO.read(new ByteArrayInputStream(this.bytes));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.image;
            }

            public byte[] getPngBytes() {
                return this.getPngBytes(false);
            }

            public byte[] getPngBytes(boolean forceWrite) {
                if (this.format.equals("png") && !forceWrite) {
                    return this.bytes;
                }
                BufferedImage image = this.getImage();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)image, "png", baos);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return baos.toByteArray();
            }
        }
    }
}

