/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.scoreboard;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import java.util.HashMap;
import java.util.Map;
import net.raphimc.viabedrock.api.model.scoreboard.ScoreboardEntry;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.IdentityDefinition_Type;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ObjectiveSortOrder;

public class ScoreboardObjective {
    private final String name;
    private final Map<Long, ScoreboardEntry> entries;
    private final ObjectiveSortOrder sortOrder;

    public ScoreboardObjective(String name, ObjectiveSortOrder sortOrder) {
        this.name = name;
        this.entries = new HashMap<Long, ScoreboardEntry>();
        this.sortOrder = sortOrder;
    }

    public ScoreboardEntry getEntry(long scoreboardId) {
        return this.entries.get(scoreboardId);
    }

    public ScoreboardEntry getEntryWithSameTarget(ScoreboardEntry entry) {
        for (ScoreboardEntry value : this.entries.values()) {
            if (!value.isSameTarget(entry)) continue;
            return value;
        }
        return null;
    }

    public ScoreboardEntry getEntryForPlayer(long uniqueEntityId) {
        for (ScoreboardEntry value : this.entries.values()) {
            if (value.uniqueEntityId() == null || value.type() != IdentityDefinition_Type.Player || uniqueEntityId != value.uniqueEntityId()) continue;
            return value;
        }
        return null;
    }

    public void addEntry(UserConnection user, long scoreboardId, ScoreboardEntry entry) {
        this.entries.put(scoreboardId, entry);
        entry.updateJavaName(user);
        this.updateEntry0(user, entry);
    }

    public void updateEntry(UserConnection user, ScoreboardEntry entry) {
        this.removeEntry0(user, entry);
        entry.updateJavaName(user);
        this.updateEntry0(user, entry);
    }

    public void updateEntryInPlace(UserConnection user, ScoreboardEntry entry) {
        this.updateEntry0(user, entry);
    }

    public void removeEntry(UserConnection user, long scoreboardId) {
        this.removeEntry0(user, this.entries.remove(scoreboardId));
    }

    private void updateEntry0(UserConnection user, ScoreboardEntry entry) {
        PacketWrapper setScore = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.SET_SCORE, (UserConnection)user);
        setScore.write(Types.STRING, (Object)entry.javaName());
        setScore.write(Types.STRING, (Object)this.name);
        setScore.write((Type)Types.VAR_INT, (Object)(this.sortOrder == ObjectiveSortOrder.Ascending ? -entry.score() : entry.score()));
        setScore.write(Types.OPTIONAL_TAG, null);
        setScore.write((Type)Types.BOOLEAN, (Object)false);
        setScore.send(BedrockProtocol.class);
    }

    private void removeEntry0(UserConnection user, ScoreboardEntry entry) {
        PacketWrapper resetScore = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.RESET_SCORE, (UserConnection)user);
        resetScore.write(Types.STRING, (Object)entry.javaName());
        resetScore.write(Types.OPTIONAL_STRING, (Object)this.name);
        resetScore.send(BedrockProtocol.class);
    }
}

