/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.util;

import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.PlayerAuthInputPacket_InputData;
import net.raphimc.viabedrock.protocol.model.Position2f;
import net.raphimc.viabedrock.protocol.model.Position3f;

public class MathUtil {
    public static int ceil(float f) {
        int i = (int)f;
        return f > (float)i ? i + 1 : i;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static float lerp(float progress, float start, float end) {
        return start + progress * (end - start);
    }

    public static int getOrFallback(int value, int min, int max, int fallback) {
        return value < min || value > max ? fallback : value;
    }

    public static byte float2Byte(float f) {
        return (byte)(f * 256.0f / 360.0f);
    }

    public static float byte2Float(byte b) {
        return (float)b * 360.0f / 256.0f;
    }

    public static boolean roughlyEquals(float a, float b) {
        return MathUtil.roughlyEquals(a, b, 1.0E-4f);
    }

    public static boolean roughlyEquals(float a, float b, float epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public static float randomFloatInclusive(float min, float max) {
        if (min == max) {
            return min;
        }
        return min + ThreadLocalRandom.current().nextFloat() * (max - min);
    }

    public static Position2f calculateMovementDirections(Set<PlayerAuthInputPacket_InputData> authInputData, boolean sneaking) {
        float[] directions = new float[2];
        float f = authInputData.contains((Object)PlayerAuthInputPacket_InputData.Left) ? 1.0f : (directions[0] = authInputData.contains((Object)PlayerAuthInputPacket_InputData.Right) ? -1.0f : 0.0f);
        directions[1] = authInputData.contains((Object)PlayerAuthInputPacket_InputData.Up) ? 1.0f : (authInputData.contains((Object)PlayerAuthInputPacket_InputData.Down) ? -1.0f : 0.0f);
        boolean both = directions[0] != 0.0f && directions[1] != 0.0f;
        for (int i = 0; i < directions.length; ++i) {
            if (both) {
                int n = i;
                directions[n] = directions[n] * (float)(1.0 / Math.sqrt(2.0));
            }
            if (!sneaking) continue;
            int n = i;
            directions[n] = directions[n] * 0.3f;
        }
        return new Position2f(directions[0], directions[1]);
    }

    public static Position3f calculateCameraOrientation(float yaw, float pitch) {
        float yawRad = (float)Math.toRadians(yaw);
        float pitchRad = (float)Math.toRadians(pitch);
        float x = -MathUtil.clamp((float)Math.sin(yawRad) * (float)Math.cos(pitchRad), -1.0f, 1.0f);
        float y = -MathUtil.clamp((float)Math.sin(pitchRad), -1.0f, 1.0f);
        float z = MathUtil.clamp((float)Math.cos(yawRad) * (float)Math.cos(pitchRad), -1.0f, 1.0f);
        return new Position3f(x, y, z);
    }
}

