/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.data;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.libs.fastutil.ints.IntIntPair;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.BiomeDefinitions;
import net.raphimc.viabedrock.api.model.resourcepack.FogDefinitions;
import net.raphimc.viabedrock.api.util.MathUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class JavaRegistries {
    private static final int BEDROCK_DEFAULT_WATER_COLOR = 4501493;
    private static final int JAVA_DEFAULT_FOG_COLOR = 12638463;

    public static CompoundTag createJavaRegistries(GameSessionStorage gameSession, ResourcePacksStorage resourcePacksStorage) {
        CompoundTag registries = BedrockProtocol.MAPPINGS.getJavaRegistries().copy();
        registries.put("minecraft:worldgen/biome", (Tag)JavaRegistries.buildJavaBiomeRegistry(gameSession.getBedrockBiomeDefinitions(), resourcePacksStorage));
        JavaRegistries.modifyDimensionRegistry(gameSession, registries.getCompoundTag("minecraft:dimension_type"));
        registries.remove("minecraft:dialog");
        registries.remove("minecraft:test_instance");
        registries.remove("minecraft:chat_type");
        registries.remove("minecraft:test_environment");
        return registries;
    }

    private static void modifyDimensionRegistry(GameSessionStorage gameSession, CompoundTag dimensionRegistry) {
        dimensionRegistry.remove("minecraft:overworld_caves");
        if (gameSession.getBedrockVanillaVersion().isLowerThan("1.18.0")) {
            dimensionRegistry.getCompoundTag("minecraft:overworld").putInt("min_y", 0);
            dimensionRegistry.getCompoundTag("minecraft:overworld").putInt("height", 256);
            dimensionRegistry.getCompoundTag("minecraft:overworld").putInt("logical_height", 256);
        }
        for (Map.Entry<String, IntIntPair> entry : gameSession.getBedrockDimensionDefinitions().entrySet()) {
            CompoundTag dimensionTag = new CompoundTag();
            int height = entry.getValue().rightInt() - entry.getValue().leftInt();
            dimensionTag.putInt("min_y", entry.getValue().leftInt());
            dimensionTag.putInt("height", height);
            dimensionTag.putInt("logical_height", height);
            dimensionRegistry.getCompoundTag(entry.getKey()).putAll(dimensionTag);
        }
    }

    private static CompoundTag buildJavaBiomeRegistry(CompoundTag biomeDefinitions, ResourcePacksStorage resourcePacksStorage) {
        CompoundTag javaBiomes = new CompoundTag();
        javaBiomes.put("minecraft:the_void", (Tag)JavaRegistries.getTheVoidBiome());
        Map<String, Object> foliageColor = BedrockProtocol.MAPPINGS.getBedrockToJavaBiomeExtraData().get("foliage_color");
        Map<String, Object> grassColor = BedrockProtocol.MAPPINGS.getBedrockToJavaBiomeExtraData().get("grass_color");
        Map<String, Object> grassColorModifier = BedrockProtocol.MAPPINGS.getBedrockToJavaBiomeExtraData().get("grass_color_modifier");
        Map<String, Object> moodSound = BedrockProtocol.MAPPINGS.getBedrockToJavaBiomeExtraData().get("mood_sound");
        for (String bedrockBiomeName : BedrockProtocol.MAPPINGS.getBedrockBiomes().keySet()) {
            FogDefinitions.FogDefinition bedrockFogDefinition;
            CompoundTag bedrockBiome = biomeDefinitions.getCompoundTag(bedrockBiomeName);
            BiomeDefinitions.BiomeDefinition bedrockBiomeDefinition = resourcePacksStorage.getBiomes().get(bedrockBiomeName);
            FogDefinitions.FogDefinition fogDefinition = bedrockFogDefinition = bedrockBiomeDefinition != null ? resourcePacksStorage.getFogs().get(bedrockBiomeDefinition.fog()) : null;
            if (bedrockBiome == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing biome definition for " + bedrockBiomeName);
                continue;
            }
            String javaIdentifier = "minecraft:" + bedrockBiomeName;
            CompoundTag javaBiome = new CompoundTag();
            javaBiome.put("temperature", bedrockBiome.get("temperature"));
            javaBiome.put("downfall", bedrockBiome.get("downfall"));
            javaBiome.put("has_precipitation", bedrockBiome.get("rain"));
            CompoundTag effects = new CompoundTag();
            javaBiome.put("effects", (Tag)effects);
            float blue_spores = bedrockBiome.getFloat("blue_spores");
            float white_ash = bedrockBiome.getFloat("white_ash");
            float red_spores = bedrockBiome.getFloat("red_spores");
            float ash = bedrockBiome.getFloat("ash");
            if (blue_spores > 0.0f) {
                effects.put("particle", (Tag)JavaRegistries.createBiomeParticle("minecraft:warped_spore", blue_spores / 10.0f));
            } else if (white_ash > 0.0f) {
                effects.put("particle", (Tag)JavaRegistries.createBiomeParticle("minecraft:white_ash", white_ash / 10.0f));
            } else if (red_spores > 0.0f) {
                effects.put("particle", (Tag)JavaRegistries.createBiomeParticle("minecraft:crimson_spore", red_spores / 10.0f));
            } else if (ash > 0.0f) {
                effects.put("particle", (Tag)JavaRegistries.createBiomeParticle("minecraft:ash", ash / 10.0f));
            }
            if (bedrockBiomeDefinition != null && bedrockBiomeDefinition.waterSurfaceColor() != null) {
                effects.putInt("water_color", bedrockBiomeDefinition.waterSurfaceColor().intValue());
            } else {
                effects.putInt("water_color", 4501493);
            }
            if (bedrockBiomeDefinition != null && bedrockBiomeDefinition.skyColor() != null) {
                effects.putInt("sky_color", bedrockBiomeDefinition.skyColor().intValue());
            } else {
                effects.putInt("sky_color", JavaRegistries.getSkyColor(bedrockBiome.getFloatTag("temperature").asFloat()));
            }
            if (bedrockFogDefinition != null && bedrockFogDefinition.colors().containsKey("air")) {
                effects.putInt("fog_color", bedrockFogDefinition.colors().get("air").intValue());
            } else {
                effects.putInt("fog_color", 12638463);
            }
            if (bedrockFogDefinition != null && bedrockFogDefinition.colors().containsKey("water")) {
                effects.putInt("water_fog_color", bedrockFogDefinition.colors().get("water").intValue());
            } else {
                effects.putInt("water_fog_color", 4501493);
            }
            List<String> tags = bedrockBiome.getListTag("tags").stream().map(StringTag.class::cast).map(StringTag::getValue).toList();
            for (String tag : tags) {
                if (foliageColor.containsKey(tag)) {
                    effects.putInt("foliage_color", ((Integer)foliageColor.get(tag)).intValue());
                }
                if (grassColor.containsKey(tag)) {
                    effects.putInt("grass_color", ((Integer)grassColor.get(tag)).intValue());
                }
                if (grassColorModifier.containsKey(tag)) {
                    effects.putString("grass_color_modifier", (String)grassColorModifier.get(tag));
                }
                if (!moodSound.containsKey(tag)) continue;
                effects.put("mood_sound", (Tag)JavaRegistries.createMoodSound((String)moodSound.get(tag)));
            }
            if (!effects.contains("mood_sound")) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing mood sound for " + bedrockBiomeName + ": " + bedrockBiome);
            }
            javaBiomes.put(javaIdentifier, (Tag)javaBiome);
        }
        return javaBiomes;
    }

    private static CompoundTag getTheVoidBiome() {
        CompoundTag biome = new CompoundTag();
        biome.putFloat("temperature", 0.5f);
        biome.putFloat("downfall", 0.5f);
        biome.putBoolean("has_precipitation", false);
        CompoundTag effects = new CompoundTag();
        biome.put("effects", (Tag)effects);
        effects.putInt("sky_color", JavaRegistries.getSkyColor(0.5f));
        effects.putInt("water_fog_color", 4501493);
        effects.putInt("fog_color", 12638463);
        effects.putInt("water_color", 4501493);
        effects.put("mood_sound", (Tag)JavaRegistries.createMoodSound("minecraft:ambient.cave"));
        return biome;
    }

    private static CompoundTag createBiomeParticle(String name, float probability) {
        CompoundTag particle = new CompoundTag();
        particle.putFloat("probability", probability);
        CompoundTag options = new CompoundTag();
        particle.put("options", (Tag)options);
        options.putString("type", name);
        return particle;
    }

    private static CompoundTag createMoodSound(String soundId) {
        CompoundTag moodSound = new CompoundTag();
        moodSound.putInt("tick_delay", 6000);
        moodSound.putFloat("offset", 2.0f);
        moodSound.putString("sound", soundId);
        moodSound.putInt("block_search_extent", 8);
        return moodSound;
    }

    private static int getSkyColor(float temperature) {
        float f = temperature / 3.0f;
        f = MathUtil.clamp(f, -1.0f, 1.0f);
        return Color.HSBtoRGB(0.62222224f - f * 0.05f, 0.5f + f * 0.1f, 1.0f) & 0xFFFFFF;
    }
}

