/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.model;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataContainer;
import com.viaversion.viaversion.api.minecraft.item.Item;
import java.util.Arrays;
import java.util.Objects;

public class BedrockItem
implements Item {
    private int id;
    private short data;
    private byte amount;
    private CompoundTag tag;
    private String[] canPlace;
    private String[] canBreak;
    private long blockingTicks;
    private int blockRuntimeId;
    private Integer netId;

    public BedrockItem(int id) {
        this(id, 0, 1);
    }

    public BedrockItem(int id, short data, byte amount) {
        this(id, data, amount, null);
    }

    public BedrockItem(int id, short data, byte amount, CompoundTag tag) {
        this(id, data, amount, tag, new String[0], new String[0], 0L, 0, null);
    }

    public BedrockItem(int id, short data, byte amount, CompoundTag tag, String[] canPlace, String[] canBreak, long blockingTicks, int blockRuntimeId, Integer netId) {
        this.setIdentifier(id);
        this.setData(data);
        this.amount = amount;
        this.tag = tag;
        this.canPlace = canPlace;
        this.canBreak = canBreak;
        this.blockingTicks = blockingTicks;
        this.blockRuntimeId = blockRuntimeId;
        this.netId = netId;
    }

    public static BedrockItem empty() {
        return new BedrockItem(0, 0, 0);
    }

    public static BedrockItem[] emptyArray(int size) {
        BedrockItem[] items = new BedrockItem[size];
        for (int i = 0; i < items.length; ++i) {
            items[i] = BedrockItem.empty();
        }
        return items;
    }

    public int identifier() {
        return this.id;
    }

    public void setIdentifier(int identifier) {
        this.id = identifier % 65536;
    }

    public short data() {
        return this.data;
    }

    public void setData(short data) {
        this.data = data < 0 ? (short)0 : data;
    }

    public void setData(int data) {
        this.setData((short)data);
    }

    public int amount() {
        return this.amount & 0xFF;
    }

    public void setAmount(int amount) {
        this.amount = (byte)amount;
    }

    public CompoundTag tag() {
        return this.tag;
    }

    public void setTag(CompoundTag tag) {
        this.tag = tag;
    }

    public StructuredDataContainer dataContainer() {
        throw new UnsupportedOperationException();
    }

    public String[] canPlace() {
        return this.canPlace;
    }

    public void setCanPlace(String[] canPlace) {
        this.canPlace = canPlace;
    }

    public String[] canBreak() {
        return this.canBreak;
    }

    public void setCanBreak(String[] canBreak) {
        this.canBreak = canBreak;
    }

    public long blockingTicks() {
        return this.blockingTicks;
    }

    public void setBlockingTicks(long blockingTicks) {
        this.blockingTicks = blockingTicks;
    }

    public int blockRuntimeId() {
        return this.blockRuntimeId;
    }

    public void setBlockRuntimeId(int blockRuntimeId) {
        this.blockRuntimeId = blockRuntimeId;
    }

    public Integer netId() {
        return this.netId;
    }

    public void setNetId(Integer netId) {
        this.netId = netId;
    }

    public boolean isEmpty() {
        return this.id == 0 || this.id == -1 || this.amount <= 0;
    }

    public boolean isDifferent(BedrockItem o) {
        if (o == null) {
            return true;
        }
        return this.id != o.id || this.data != o.data || this.blockRuntimeId != o.blockRuntimeId || !Objects.equals(this.tag, o.tag);
    }

    public BedrockItem copy() {
        return new BedrockItem(this.id, this.data, this.amount, this.tag != null ? this.tag.copy() : null, (String[])this.canPlace.clone(), (String[])this.canBreak.clone(), this.blockingTicks, this.blockRuntimeId, this.netId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BedrockItem that = (BedrockItem)o;
        return this.id == that.id && this.data == that.data && this.amount == that.amount && this.blockingTicks == that.blockingTicks && this.blockRuntimeId == that.blockRuntimeId && Objects.equals(this.tag, that.tag) && Objects.deepEquals(this.canPlace, that.canPlace) && Objects.deepEquals(this.canBreak, that.canBreak) && Objects.equals(this.netId, that.netId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.data, this.amount, this.tag, Arrays.hashCode(this.canPlace), Arrays.hashCode(this.canBreak), this.blockingTicks, this.blockRuntimeId, this.netId);
    }

    public String toString() {
        return "BedrockItem{id=" + this.id + ", data=" + this.data + ", amount=" + this.amount() + ", tag=" + this.tag + ", canPlace=" + Arrays.toString(this.canPlace) + ", canBreak=" + Arrays.toString(this.canBreak) + ", blockingTicks=" + this.blockingTicks + ", blockRuntimeId=" + this.blockRuntimeId + ", netId=" + this.netId + "}";
    }
}

