/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.CommandRegistry_HardNonTerminal;

public record CommandData(String name, String description, int flags, byte permission, EnumData alias, OverloadData[] overloads) {

    public static class EnumData {
        private final String name;
        private final Map<String, Set<Byte>> values;
        private final boolean soft;

        public EnumData(String name, Set<String> values, boolean soft) {
            this.name = name;
            this.values = new HashMap<String, Set<Byte>>();
            for (String value : values) {
                this.values.put(value, new HashSet());
            }
            this.soft = soft;
        }

        public String name() {
            return this.name;
        }

        public Map<String, Set<Byte>> values() {
            return this.values;
        }

        public void addValues(Set<String> values) {
            for (String value : values) {
                this.values.put(value, new HashSet());
            }
        }

        public void removeValues(Set<String> values) {
            for (String value : values) {
                this.values.remove(value);
            }
        }

        public boolean soft() {
            return this.soft;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnumData enumData = (EnumData)o;
            return this.soft == enumData.soft && Objects.equals(this.name, enumData.name) && Objects.equals(this.values, enumData.values);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.values, this.soft);
        }

        public String toString() {
            return "EnumData{name='" + this.name + "', values=" + this.values + ", soft=" + this.soft + "}";
        }
    }

    public record OverloadData(boolean chaining, ParamData[] parameters) {

        public record ParamData(String name, boolean optional, short flags, CommandRegistry_HardNonTerminal type, EnumData enumData, SubCommandData subCommandData, String postfix) {
        }
    }

    public record SubCommandData(String name, Map<String, Integer> values) {
        public void addValues(Map<String, Integer> values) {
            this.values.putAll(values);
        }
    }
}

