/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.model;

import java.util.HashSet;
import net.raphimc.viabedrock.api.util.MathUtil;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AttributeModifierOperation;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AttributeOperands;

public record EntityAttribute(String name, float currentValue, float minValue, float maxValue, float defaultValue, float defaultMinValue, float defaultMaxValue, Modifier[] modifiers) {
    public EntityAttribute(String name, float currentValue, float minValue, float maxValue) {
        this(name, currentValue, minValue, maxValue, currentValue, minValue, maxValue, new Modifier[0]);
    }

    public EntityAttribute withValue(float value) {
        return new EntityAttribute(this.name, value, this.minValue, this.maxValue, this.defaultValue, this.defaultMinValue, this.defaultMaxValue, this.modifiers);
    }

    public EntityAttribute withModifiers(Modifier[] modifiers) {
        return new EntityAttribute(this.name, this.currentValue, this.minValue, this.maxValue, this.defaultValue, this.defaultMinValue, this.defaultMaxValue, modifiers);
    }

    public float computeClampedValue() {
        float minValue = this.computeMinValue();
        float maxValue = this.computeMaxValue();
        return MathUtil.clamp(this.currentValue, minValue, maxValue);
    }

    public float computeCurrentValue() {
        return this.applyModifiers(this.defaultValue, AttributeOperands.OPERAND_CURRENT);
    }

    public float computeMinValue() {
        return Math.max(this.applyModifiers(this.minValue, AttributeOperands.OPERAND_MIN), this.minValue);
    }

    public float computeMaxValue() {
        return Math.min(this.applyModifiers(this.maxValue, AttributeOperands.OPERAND_MAX), this.maxValue);
    }

    private float applyModifiers(float value, AttributeOperands operand) {
        if (this.modifiers.length == 0) {
            return value;
        }
        float result = value;
        HashSet<String> applied = new HashSet<String>();
        for (Modifier modifier : this.modifiers) {
            if (modifier.operation != AttributeModifierOperation.OPERATION_ADDITION || modifier.operand != operand || applied.contains(modifier.name)) continue;
            result += modifier.amount;
            applied.add(modifier.name);
        }
        applied.clear();
        float base = result;
        for (Modifier modifier : this.modifiers) {
            if (modifier.operation != AttributeModifierOperation.OPERATION_MULTIPLY_BASE || modifier.operand != operand || applied.contains(modifier.name)) continue;
            result += base * modifier.amount;
            applied.add(modifier.name);
        }
        applied.clear();
        for (Modifier modifier : this.modifiers) {
            if (modifier.operation != AttributeModifierOperation.OPERATION_MULTIPLY_TOTAL || modifier.operand != operand || applied.contains(modifier.name)) continue;
            result *= 1.0f + modifier.amount;
            applied.add(modifier.name);
        }
        applied.clear();
        for (Modifier modifier : this.modifiers) {
            if (modifier.operation != AttributeModifierOperation.OPERATION_CAP || modifier.operand != operand || applied.contains(modifier.name)) continue;
            result = Math.min(result, modifier.amount);
            applied.add(modifier.name);
        }
        return result;
    }

    public record Modifier(String id, String name, float amount, AttributeModifierOperation operation, AttributeOperands operand, boolean isSerializable) {
    }
}

