/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.model;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AbilitiesIndex;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.SerializedAbilitiesData_SerializedAbilitiesLayer;

public record PlayerAbilities(long uniqueEntityId, byte playerPermission, byte commandPermission, Map<SerializedAbilitiesData_SerializedAbilitiesLayer, AbilitiesLayer> abilityLayers) {
    public PlayerAbilities(long uniqueEntityId, byte playerPermission, byte commandPermission) {
        this(uniqueEntityId, playerPermission, commandPermission, new EnumMap<SerializedAbilitiesData_SerializedAbilitiesLayer, AbilitiesLayer>(SerializedAbilitiesData_SerializedAbilitiesLayer.class));
        EnumSet<AbilitiesIndex> abilitiesSet = EnumSet.allOf(AbilitiesIndex.class);
        abilitiesSet.remove((Object)AbilitiesIndex.Invalid);
        this.abilityLayers.put(SerializedAbilitiesData_SerializedAbilitiesLayer.Base, new AbilitiesLayer(abilitiesSet, EnumSet.of(AbilitiesIndex.Build, new AbilitiesIndex[]{AbilitiesIndex.Mine, AbilitiesIndex.DoorsAndSwitches, AbilitiesIndex.OpenContainers, AbilitiesIndex.AttackPlayers, AbilitiesIndex.AttackMobs}), 0.1f, 0.05f, 1.0f));
    }

    public boolean getBooleanValue(AbilitiesIndex ability) {
        for (SerializedAbilitiesData_SerializedAbilitiesLayer layer : SerializedAbilitiesData_SerializedAbilitiesLayer.values()) {
            AbilitiesLayer abilitiesLayer = this.abilityLayers.get((Object)layer);
            if (abilitiesLayer == null || !abilitiesLayer.abilitiesSet().contains((Object)ability)) continue;
            return abilitiesLayer.abilityValues().contains((Object)ability);
        }
        return false;
    }

    public float getFloatValue(AbilitiesIndex ability) {
        for (SerializedAbilitiesData_SerializedAbilitiesLayer layer : SerializedAbilitiesData_SerializedAbilitiesLayer.values()) {
            AbilitiesLayer abilitiesLayer = this.abilityLayers.get((Object)layer);
            if (abilitiesLayer == null || !abilitiesLayer.abilitiesSet().contains((Object)ability)) continue;
            return switch (ability) {
                case AbilitiesIndex.WalkSpeed -> abilitiesLayer.walkSpeed();
                case AbilitiesIndex.FlySpeed -> abilitiesLayer.flySpeed();
                case AbilitiesIndex.VerticalFlySpeed -> abilitiesLayer.verticalFlySpeed();
                default -> throw new IllegalArgumentException("Ability " + ability + " is not a float value");
            };
        }
        return 0.0f;
    }

    public AbilitiesLayer getOrCreateCacheLayer() {
        return this.abilityLayers.computeIfAbsent(SerializedAbilitiesData_SerializedAbilitiesLayer.CustomCache, layer -> new AbilitiesLayer(EnumSet.noneOf(AbilitiesIndex.class), EnumSet.noneOf(AbilitiesIndex.class), 0.0f, 0.0f, 0.0f));
    }

    public record AbilitiesLayer(Set<AbilitiesIndex> abilitiesSet, Set<AbilitiesIndex> abilityValues, float walkSpeed, float flySpeed, float verticalFlySpeed) {
        public void setAbility(AbilitiesIndex ability, boolean value) {
            this.abilitiesSet.add(ability);
            if (value) {
                this.abilityValues.add(ability);
            } else {
                this.abilityValues.remove((Object)ability);
            }
        }
    }
}

