/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packet;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.GameProfile;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.exception.InformativeException;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import com.viaversion.viaversion.util.Pair;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import net.lenni0451.mcstructs_bedrock.text.components.RootBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.components.TranslationBedrockComponent;
import net.lenni0451.mcstructs_bedrock.text.serializer.BedrockComponentSerializer;
import net.lenni0451.mcstructs_bedrock.text.utils.BedrockTranslator;
import net.lenni0451.mcstructs_bedrock.text.utils.TranslatorOptions;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.Entity;
import net.raphimc.viabedrock.api.model.scoreboard.ScoreboardEntry;
import net.raphimc.viabedrock.api.model.scoreboard.ScoreboardObjective;
import net.raphimc.viabedrock.api.util.BitSets;
import net.raphimc.viabedrock.api.util.MathUtil;
import net.raphimc.viabedrock.api.util.PacketFactory;
import net.raphimc.viabedrock.api.util.StringUtil;
import net.raphimc.viabedrock.api.util.TextUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.BossEventUpdateType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.IdentityDefinition_Type;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ObjectiveSortOrder;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.PlayerListPacketType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ScorePacketType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ScoreboardIdentityPacketType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.SetTitlePacket_TitleType;
import net.raphimc.viabedrock.protocol.data.enums.java.BossEventOperationType;
import net.raphimc.viabedrock.protocol.data.enums.java.CustomChatCompletionsAction;
import net.raphimc.viabedrock.protocol.data.enums.java.ObjectiveAction;
import net.raphimc.viabedrock.protocol.data.enums.java.ObjectiveCriteriaRenderType;
import net.raphimc.viabedrock.protocol.data.enums.java.PlayerInfoUpdateAction;
import net.raphimc.viabedrock.protocol.model.SkinData;
import net.raphimc.viabedrock.protocol.provider.SkinProvider;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.PlayerListStorage;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import net.raphimc.viabedrock.protocol.storage.ScoreboardTracker;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class HudPackets {
    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.PLAYER_LIST, (ClientboundPacketType)ClientboundPackets1_21_6.PLAYER_INFO_UPDATE, wrapper -> {
            PlayerListStorage playerListStorage = (PlayerListStorage)wrapper.user().get(PlayerListStorage.class);
            ScoreboardTracker scoreboardTracker = (ScoreboardTracker)wrapper.user().get(ScoreboardTracker.class);
            byte rawAction = (Byte)wrapper.read((Type)Types.BYTE);
            PlayerListPacketType action = PlayerListPacketType.getByValue(rawAction);
            if (action == null) {
                throw new IllegalStateException("Unknown PlayerListPacketType: " + rawAction);
            }
            switch (action) {
                case Add: {
                    int i;
                    int length = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
                    UUID[] uuids = new UUID[length];
                    long[] uniqueEntityIds = new long[length];
                    String[] names = new String[length];
                    wrapper.write((Type)Types.PROFILE_ACTIONS_ENUM1_21_4, (Object)BitSets.create(8, PlayerInfoUpdateAction.ADD_PLAYER, PlayerInfoUpdateAction.UPDATE_LISTED, PlayerInfoUpdateAction.UPDATE_DISPLAY_NAME));
                    wrapper.write((Type)Types.VAR_INT, (Object)length);
                    for (i = 0; i < length; ++i) {
                        uuids[i] = (UUID)wrapper.read(BedrockTypes.UUID);
                        wrapper.write(Types.UUID, (Object)uuids[i]);
                        wrapper.write(Types.STRING, (Object)StringUtil.encodeUUID(uuids[i]));
                        uniqueEntityIds[i] = (Long)wrapper.read((Type)BedrockTypes.VAR_LONG);
                        names[i] = (String)wrapper.read(BedrockTypes.STRING);
                        String xuid = (String)wrapper.read(BedrockTypes.STRING);
                        String platformOnlineId = (String)wrapper.read(BedrockTypes.STRING);
                        int deviceOs = (Integer)wrapper.read((Type)BedrockTypes.INT_LE);
                        SkinData skin = (SkinData)wrapper.read(BedrockTypes.SKIN);
                        boolean isTeacher = (Boolean)wrapper.read((Type)Types.BOOLEAN);
                        boolean isHost = (Boolean)wrapper.read((Type)Types.BOOLEAN);
                        boolean isSubClient = (Boolean)wrapper.read((Type)Types.BOOLEAN);
                        wrapper.read((Type)BedrockTypes.INT_LE);
                        wrapper.write(Types.PROFILE_PROPERTY_ARRAY, (Object)new GameProfile.Property[]{new GameProfile.Property("xuid", xuid), new GameProfile.Property("platform_online_id", platformOnlineId), new GameProfile.Property("device_os", String.valueOf(deviceOs)), new GameProfile.Property("is_teacher", String.valueOf(isTeacher)), new GameProfile.Property("is_host", String.valueOf(isHost)), new GameProfile.Property("is_subclient", String.valueOf(isSubClient))});
                        wrapper.write((Type)Types.BOOLEAN, (Object)true);
                        wrapper.write(Types.OPTIONAL_TAG, (Object)TextUtil.stringToNbt(names[i]));
                        ((SkinProvider)Via.getManager().getProviders().get(SkinProvider.class)).setSkin(wrapper.user(), uuids[i], skin);
                    }
                    try {
                        for (i = 0; i < length; ++i) {
                            wrapper.read((Type)Types.BOOLEAN);
                        }
                    }
                    catch (InformativeException i2) {
                        // empty catch block
                    }
                    ArrayList<UUID> toRemoveUUIDs = new ArrayList<UUID>();
                    ArrayList<String> toRemoveNames = new ArrayList<String>();
                    for (int i3 = 0; i3 < uuids.length; ++i3) {
                        Pair<ScoreboardObjective, ScoreboardEntry> scoreboardEntry;
                        Pair<Long, String> entry = playerListStorage.addPlayer(uuids[i3], uniqueEntityIds[i3], names[i3]);
                        if (entry != null) {
                            toRemoveUUIDs.add(uuids[i3]);
                            toRemoveNames.add((String)entry.value());
                        }
                        if ((scoreboardEntry = scoreboardTracker.getEntryForPlayer(uniqueEntityIds[i3])) == null) continue;
                        ((ScoreboardObjective)scoreboardEntry.key()).updateEntry(wrapper.user(), (ScoreboardEntry)scoreboardEntry.value());
                    }
                    if (!toRemoveUUIDs.isEmpty()) {
                        PacketWrapper playerInfoRemove = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.PLAYER_INFO_REMOVE, (UserConnection)wrapper.user());
                        playerInfoRemove.write(Types.UUID_ARRAY, (Object)toRemoveUUIDs.toArray(new UUID[0]));
                        playerInfoRemove.send(BedrockProtocol.class);
                        PacketFactory.sendJavaCustomChatCompletions(wrapper.user(), CustomChatCompletionsAction.REMOVE, toRemoveNames.toArray(new String[0]));
                    }
                    PacketFactory.sendJavaCustomChatCompletions(wrapper.user(), CustomChatCompletionsAction.ADD, names);
                    break;
                }
                case Remove: {
                    wrapper.setPacketType((PacketType)ClientboundPackets1_21_6.PLAYER_INFO_REMOVE);
                    UUID[] uuids = (UUID[])wrapper.read(BedrockTypes.UUID_ARRAY);
                    wrapper.write(Types.UUID_ARRAY, (Object)uuids);
                    ArrayList<String> names = new ArrayList<String>();
                    for (UUID uuid : uuids) {
                        Pair<Long, String> entry = playerListStorage.removePlayer(uuid);
                        if (entry == null) continue;
                        names.add((String)entry.value());
                        Pair<ScoreboardObjective, ScoreboardEntry> scoreboardEntry = scoreboardTracker.getEntryForPlayer((Long)entry.key());
                        if (scoreboardEntry == null) continue;
                        ((ScoreboardObjective)scoreboardEntry.key()).updateEntry(wrapper.user(), (ScoreboardEntry)scoreboardEntry.value());
                    }
                    PacketFactory.sendJavaCustomChatCompletions(wrapper.user(), CustomChatCompletionsAction.REMOVE, names.toArray(new String[0]));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled PlayerListPacketType: " + action);
                }
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_TITLE, null, wrapper -> {
            int rawType = (Integer)wrapper.read((Type)BedrockTypes.VAR_INT);
            SetTitlePacket_TitleType type = SetTitlePacket_TitleType.getByValue(rawType);
            if (type == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown SetTitlePacket_TitleType: " + rawType);
                wrapper.cancel();
                return;
            }
            String text = (String)wrapper.read(BedrockTypes.STRING);
            int fadeInTicks = (Integer)wrapper.read((Type)BedrockTypes.VAR_INT);
            int stayTicks = (Integer)wrapper.read((Type)BedrockTypes.VAR_INT);
            int fadeOutTicks = (Integer)wrapper.read((Type)BedrockTypes.VAR_INT);
            wrapper.read(BedrockTypes.STRING);
            wrapper.read(BedrockTypes.STRING);
            wrapper.read(BedrockTypes.STRING);
            Function<String, String> translator = ((ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class)).getTexts().lookup();
            String originalText = text;
            try {
                if (type.getValue() >= SetTitlePacket_TitleType.TitleTextObject.getValue() && type.getValue() <= SetTitlePacket_TitleType.ActionbarTextObject.getValue()) {
                    RootBedrockComponent rootComponent = BedrockComponentSerializer.deserialize((String)text);
                    rootComponent.forEach(c -> {
                        if (c instanceof TranslationBedrockComponent) {
                            ((TranslationBedrockComponent)c).setTranslator(translator);
                        }
                    });
                    text = rootComponent.asString();
                }
                switch (type) {
                    case Clear: 
                    case Reset: {
                        wrapper.setPacketType((PacketType)ClientboundPackets1_21_6.CLEAR_TITLES);
                        wrapper.write((Type)Types.BOOLEAN, (Object)(type == SetTitlePacket_TitleType.Reset ? 1 : 0));
                        break;
                    }
                    case Title: 
                    case TitleTextObject: {
                        wrapper.setPacketType((PacketType)ClientboundPackets1_21_6.SET_TITLE_TEXT);
                        wrapper.write(Types.TAG, (Object)TextUtil.stringToNbt(text));
                        break;
                    }
                    case Subtitle: 
                    case SubtitleTextObject: {
                        wrapper.setPacketType((PacketType)ClientboundPackets1_21_6.SET_SUBTITLE_TEXT);
                        wrapper.write(Types.TAG, (Object)TextUtil.stringToNbt(text));
                        break;
                    }
                    case Actionbar: 
                    case ActionbarTextObject: {
                        wrapper.setPacketType((PacketType)ClientboundPackets1_21_6.SET_ACTION_BAR_TEXT);
                        wrapper.write(Types.TAG, (Object)TextUtil.stringToNbt(text));
                        break;
                    }
                    case Times: {
                        wrapper.setPacketType((PacketType)ClientboundPackets1_21_6.SET_TITLES_ANIMATION);
                        wrapper.write((Type)Types.INT, (Object)fadeInTicks);
                        wrapper.write((Type)Types.INT, (Object)stayTicks);
                        wrapper.write((Type)Types.INT, (Object)fadeOutTicks);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled SetTitlePacket_TitleType: " + type);
                    }
                }
            }
            catch (Throwable e) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Error while translating '" + originalText + "'", e);
                wrapper.cancel();
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_DISPLAY_OBJECTIVE, (ClientboundPacketType)ClientboundPackets1_21_6.SET_DISPLAY_OBJECTIVE, wrapper -> {
            ScoreboardTracker scoreboardTracker = (ScoreboardTracker)wrapper.user().get(ScoreboardTracker.class);
            String displaySlot = (String)wrapper.read(BedrockTypes.STRING);
            String objectiveName = (String)wrapper.read(BedrockTypes.STRING);
            String displayName = (String)wrapper.read(BedrockTypes.STRING);
            wrapper.read(BedrockTypes.STRING);
            ObjectiveSortOrder sortOrder = ObjectiveSortOrder.getByValue((Integer)wrapper.read((Type)BedrockTypes.VAR_INT), ObjectiveSortOrder.Descending);
            switch (displaySlot) {
                case "sidebar": {
                    wrapper.write((Type)Types.VAR_INT, (Object)1);
                    break;
                }
                case "belowname": {
                    wrapper.write((Type)Types.VAR_INT, (Object)2);
                    break;
                }
                case "list": {
                    wrapper.write((Type)Types.VAR_INT, (Object)0);
                    break;
                }
                default: {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown bedrock scoreboard display slot: " + displaySlot);
                    wrapper.cancel();
                    return;
                }
            }
            wrapper.write(Types.STRING, (Object)objectiveName);
            if (objectiveName.isEmpty()) {
                return;
            }
            if (!scoreboardTracker.hasObjective(objectiveName)) {
                scoreboardTracker.addObjective(objectiveName, new ScoreboardObjective(objectiveName, sortOrder));
                PacketWrapper scoreboardObjective = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.SET_OBJECTIVE, (UserConnection)wrapper.user());
                scoreboardObjective.write(Types.STRING, (Object)objectiveName);
                scoreboardObjective.write((Type)Types.BYTE, (Object)((byte)ObjectiveAction.ADD.ordinal()));
                scoreboardObjective.write(Types.TAG, (Object)TextUtil.stringToNbt(((ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class)).getTexts().translate(displayName)));
                scoreboardObjective.write((Type)Types.VAR_INT, (Object)ObjectiveCriteriaRenderType.INTEGER.ordinal());
                scoreboardObjective.write((Type)Types.BOOLEAN, (Object)false);
                scoreboardObjective.send(BedrockProtocol.class);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_SCORE, null, wrapper -> {
            wrapper.cancel();
            ScoreboardTracker scoreboardTracker = (ScoreboardTracker)wrapper.user().get(ScoreboardTracker.class);
            byte rawAction = (Byte)wrapper.read((Type)Types.BYTE);
            ScorePacketType action = ScorePacketType.getByValue(rawAction);
            if (action == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown ScorePacketType: " + rawAction);
                return;
            }
            int count = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
            for (int i = 0; i < count; ++i) {
                long scoreboardId = (Long)wrapper.read((Type)BedrockTypes.VAR_LONG);
                String objectiveName = (String)wrapper.read(BedrockTypes.STRING);
                int score = (Integer)wrapper.read((Type)BedrockTypes.INT_LE);
                ScoreboardEntry entry = switch (action) {
                    case ScorePacketType.Change -> {
                        byte rawType = (Byte)wrapper.read((Type)Types.BYTE);
                        IdentityDefinition_Type type = IdentityDefinition_Type.getByValue(rawType, IdentityDefinition_Type.Invalid);
                        Long uniqueEntityId = null;
                        String fakePlayerName = null;
                        switch (type) {
                            case Player: 
                            case Entity: {
                                uniqueEntityId = (Long)wrapper.read((Type)BedrockTypes.VAR_LONG);
                                break;
                            }
                            case FakePlayer: {
                                fakePlayerName = (String)wrapper.read(BedrockTypes.STRING);
                                break;
                            }
                            case Invalid: {
                                throw new IllegalStateException("Invalid IdentityDefinition_Type: " + rawType);
                            }
                            default: {
                                throw new IllegalStateException("Unhandled IdentityDefinition_Type: " + rawType);
                            }
                        }
                        yield new ScoreboardEntry(score, type, uniqueEntityId, fakePlayerName);
                    }
                    case ScorePacketType.Remove -> null;
                    default -> throw new IllegalStateException("Unhandled ScorePacketType: " + action);
                };
                ScoreboardObjective objective = scoreboardTracker.getObjective(objectiveName);
                Pair<ScoreboardObjective, ScoreboardEntry> existingEntry = scoreboardTracker.getEntry(scoreboardId);
                if (existingEntry != null) {
                    ((ScoreboardObjective)existingEntry.key()).removeEntry(wrapper.user(), scoreboardId);
                    if (entry == null || objective == null) continue;
                    ((ScoreboardEntry)existingEntry.value()).setScore(entry.score());
                    objective.addEntry(wrapper.user(), scoreboardId, (ScoreboardEntry)existingEntry.value());
                    continue;
                }
                if (entry == null || objective == null) continue;
                ScoreboardEntry sameTargetEntry = objective.getEntryWithSameTarget(entry);
                if (sameTargetEntry != null) {
                    sameTargetEntry.setScore(entry.score());
                    objective.updateEntryInPlace(wrapper.user(), sameTargetEntry);
                    continue;
                }
                if (!entry.isValid()) continue;
                objective.addEntry(wrapper.user(), scoreboardId, entry);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_SCOREBOARD_IDENTITY, null, wrapper -> {
            wrapper.cancel();
            ScoreboardTracker scoreboardTracker = (ScoreboardTracker)wrapper.user().get(ScoreboardTracker.class);
            byte rawAction = (Byte)wrapper.read((Type)Types.BYTE);
            ScoreboardIdentityPacketType action = ScoreboardIdentityPacketType.getByValue(rawAction);
            if (action == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown ScoreboardIdentityPacketType: " + rawAction);
                return;
            }
            int count = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
            block4: for (int i = 0; i < count; ++i) {
                long scoreboardId = (Long)wrapper.read((Type)BedrockTypes.VAR_LONG);
                Pair<ScoreboardObjective, ScoreboardEntry> entry = scoreboardTracker.getEntry(scoreboardId);
                switch (action) {
                    case Update: {
                        ScoreboardEntry scoreboardEntry;
                        long uniqueEntityId = (Long)wrapper.read((Type)BedrockTypes.VAR_LONG);
                        if (entry == null || (scoreboardEntry = (ScoreboardEntry)entry.value()).uniqueEntityId() != null) continue block4;
                        scoreboardEntry.updateTarget(IdentityDefinition_Type.Player, uniqueEntityId, scoreboardEntry.fakePlayerName());
                        ((ScoreboardObjective)entry.key()).updateEntry(wrapper.user(), scoreboardEntry);
                        continue block4;
                    }
                    case Remove: {
                        ScoreboardEntry scoreboardEntry;
                        if (entry == null || (scoreboardEntry = (ScoreboardEntry)entry.value()).fakePlayerName() == null) continue block4;
                        scoreboardEntry.updateTarget(IdentityDefinition_Type.FakePlayer, null, scoreboardEntry.fakePlayerName());
                        ((ScoreboardObjective)entry.key()).updateEntry(wrapper.user(), scoreboardEntry);
                        continue block4;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled ScoreboardIdentityPacketType: " + action);
                    }
                }
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.REMOVE_OBJECTIVE, (ClientboundPacketType)ClientboundPackets1_21_6.SET_OBJECTIVE, (PacketHandler)new PacketHandlers(){

            protected void register() {
                this.map(BedrockTypes.STRING, Types.STRING);
                this.create((Type)Types.BYTE, (byte)ObjectiveAction.REMOVE.ordinal());
                this.handler(wrapper -> ((ScoreboardTracker)wrapper.user().get(ScoreboardTracker.class)).removeObjective((String)wrapper.get(Types.STRING, 0)));
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.BOSS_EVENT, (ClientboundPacketType)ClientboundPackets1_21_6.BOSS_EVENT, wrapper -> {
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            long bossUniqueEntityId = (Long)wrapper.read((Type)BedrockTypes.VAR_LONG);
            int rawUpdateType = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
            BossEventUpdateType updateType = BossEventUpdateType.getByValue(rawUpdateType);
            if (updateType == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown BossEventUpdateType: " + rawUpdateType);
                wrapper.cancel();
                return;
            }
            Entity entity = entityTracker.getEntityByUid(bossUniqueEntityId);
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            wrapper.write(Types.UUID, (Object)entity.javaUuid());
            switch (updateType) {
                case Add: {
                    if (!entity.hasBossBar()) {
                        entity.setHasBossBar(true);
                        wrapper.write((Type)Types.VAR_INT, (Object)BossEventOperationType.ADD.ordinal());
                        wrapper.write(Types.TAG, (Object)TextUtil.stringToNbt(((ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class)).getTexts().translate((String)wrapper.read(BedrockTypes.STRING))));
                        wrapper.read(BedrockTypes.STRING);
                        wrapper.write((Type)Types.FLOAT, (Object)((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)));
                        wrapper.read((Type)BedrockTypes.UNSIGNED_SHORT_LE);
                        wrapper.write((Type)Types.VAR_INT, (Object)MathUtil.getOrFallback((Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT), 0, 5, 0));
                        wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
                        wrapper.write((Type)Types.VAR_INT, (Object)0);
                        wrapper.write((Type)Types.UNSIGNED_BYTE, (Object)0);
                        break;
                    }
                    wrapper.cancel();
                    break;
                }
                case Remove: {
                    entity.setHasBossBar(false);
                    wrapper.write((Type)Types.VAR_INT, (Object)BossEventOperationType.REMOVE.ordinal());
                    break;
                }
                case Update_Percent: {
                    wrapper.write((Type)Types.VAR_INT, (Object)BossEventOperationType.UPDATE_PROGRESS.ordinal());
                    wrapper.write((Type)Types.FLOAT, (Object)((Float)wrapper.read((Type)BedrockTypes.FLOAT_LE)));
                    break;
                }
                case Update_Name: {
                    wrapper.write((Type)Types.VAR_INT, (Object)BossEventOperationType.UPDATE_NAME.ordinal());
                    wrapper.write(Types.TAG, (Object)TextUtil.stringToNbt(((ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class)).getTexts().translate((String)wrapper.read(BedrockTypes.STRING))));
                    wrapper.read(BedrockTypes.STRING);
                    break;
                }
                case Update_Properties: {
                    wrapper.write((Type)Types.VAR_INT, (Object)BossEventOperationType.UPDATE_STYLE.ordinal());
                    wrapper.read((Type)BedrockTypes.UNSIGNED_SHORT_LE);
                    wrapper.write((Type)Types.VAR_INT, (Object)MathUtil.getOrFallback((Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT), 0, 5, 0));
                    wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
                    wrapper.write((Type)Types.VAR_INT, (Object)0);
                    break;
                }
                case Update_Style: {
                    wrapper.write((Type)Types.VAR_INT, (Object)BossEventOperationType.UPDATE_STYLE.ordinal());
                    wrapper.write((Type)Types.VAR_INT, (Object)MathUtil.getOrFallback((Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT), 0, 5, 0));
                    wrapper.read((Type)BedrockTypes.UNSIGNED_VAR_INT);
                    wrapper.write((Type)Types.VAR_INT, (Object)0);
                    break;
                }
                case PlayerAdded: 
                case PlayerRemoved: 
                case Query: {
                    wrapper.cancel();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled BossEventUpdateType: " + updateType);
                }
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.DEATH_INFO, null, wrapper -> {
            wrapper.cancel();
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            EntityTracker entityTracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
            String message = (String)wrapper.read(BedrockTypes.STRING);
            Object[] parameters = (String[])wrapper.read(BedrockTypes.STRING_ARRAY);
            Function<String, String> translator = ((ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class)).getTexts().lookup();
            gameSession.setDeathMessage(TextUtil.stringToTextComponent(BedrockTranslator.translate((String)message, translator, (Object[])parameters, (TranslatorOptions[])new TranslatorOptions[0])));
            if (entityTracker.getClientPlayer().isDead()) {
                PacketWrapper playerCombatKill = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.PLAYER_COMBAT_KILL, (UserConnection)wrapper.user());
                playerCombatKill.write((Type)Types.VAR_INT, (Object)entityTracker.getClientPlayer().javaId());
                playerCombatKill.write(Types.TAG, (Object)TextUtil.textComponentToNbt(gameSession.getDeathMessage()));
                playerCombatKill.send(BedrockProtocol.class);
            }
        });
    }
}

